set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8827853';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.236178,
      3,
      3.678102,
      5,
      2.346938,
      1.071016,
      NULL,
      '044',
      NULL,
      NULL,
      37.264779,
      '2104431',
      2,
      1,
      1,
      3,
      NULL,
      4,
      1.232338,
      NULL,
      NULL,
      '11-23-1997',
      59.313655,
      120,
      NULL,
      1,
      1.358013,
      ' 1-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      3.441421,
      ' 3- 9-1994',
      ' 8- 6-1975',
      '11- 3-1985',
      3,
      NULL,
      NULL,
      0,
      1.685157,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      10.333181,
      3.418569,
      NULL,
      NULL,
      NULL,
      NULL,
      6.664891,
      0.801713,
      NULL,
      1.892885,
      1.860095,
      NULL,
      0.117473,
      NULL,
      1.409343,
      NULL,
      NULL,
      NULL,
      0,
      4.631620,
      2.997792,
      3.000467,
      8,
      3,
      6,
      NULL,
      0.588011,
      NULL,
      5.560404,
      1.063101,
      5.782119,
      0.571178,
      2.078119,
      2.917496,
      7,
      0.902622,
      10.472119,
      1.466313,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.110674,
      NULL,
      NULL,
      NULL,
      1.806660,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.015845,
      0.187896,
      NULL,
      0.778466,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.569123,
      1,
      4.350018,
      NULL,
      3.576571,
      2.915573,
      3,
      0.511082,
      NULL,
      0,
      1,
      5.909460,
      2,
      0.718968,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0.533669,
      NULL,
      1.290023,
      1.718297,
      NULL,
      2.636861,
      0.980026,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.442982,
      0.904823,
      2,
      0,
      2.494190,
      5.917521,
      5,
      NULL,
      NULL,
      1,
      4.656549,
      4,
      1,
      ' 4-15-1992',
      167.807573,
      ' 9- 8-1993',
      31,
      2,
      1,
      1.427616,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.428533,
      0.461771,
      0.037060,
      1.562448,
      1.705829,
      1.907516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975119,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.564703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085330,
      1.288352,
      0,
      5,
      NULL,
      1,
      1.392823,
      NULL,
      NULL,
      NULL,
      1.743443,
      2.665244,
      0.759295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.824554,
      NULL,
      1,
      NULL,
      1,
      0,
      3.403387,
      16,
      0,
      0.487277,
      NULL,
      NULL,
      NULL,
      2.012326,
      0.085881,
      2,
      3,
      2.655243,
      2.398581,
      3,
      3,
      2.972275,
      2,
      2,
      3,
      2,
      0.005492,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.293259,
      0,
      1,
      0,
      1.397659,
      NULL,
      NULL,
      1.137696,
      NULL,
      6.633282,
      2.292744,
      4,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      28.426892,
      3.837946,
      1.214740,
      46,
      NULL,
      3,
      21,
      1.220872,
      1,
      3,
      '31323',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      3.656733,
      NULL,
      '',
      '',
      3,
      5,
      81,
      NULL,
      2.430002,
      37.045175,
      NULL,
      3.693123,
      1,
      1,
      NULL,
      NULL,
      0.357916,
      NULL,
      NULL,
      0.102265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044307,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.878296,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621746,
      NULL,
      NULL,
      1.887957,
      NULL,
      NULL,
      0.475762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832723,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208951,
      NULL,
      NULL,
      1.853358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.774086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.955695,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.641445,
      NULL,
      NULL,
      1.707207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      6,
      5,
      1.486611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.127151,
      1,
      2.830167,
      NULL,
      NULL,
      0.270370,
      7.344437,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1.950711,
      0.767274,
      1,
      1.936116,
      1.663269,
      1,
      0.929310,
      3.179330,
      2.181490,
      3.597153,
      NULL,
      3.912119,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.989697,
      1.121272,
      0.208668,
      1.489915,
      0.240353,
      0.378466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.032635,
      1.055986,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.466083,
      29.517662,
      5.596006,
      NULL,
      3,
      2.839187,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.036577,
      NULL,
      0,
      196.295170,
      2.825644,
      0,
      NULL,
      NULL,
      1.368473,
      0,
      NULL,
      1.217796,
      1,
      1,
      1.775399,
      1.239140,
      1.086143,
      0.797499,
      0.879446,
      0.571650,
      0.620329,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.159563,
      NULL,
      NULL,
      NULL,
      3.687021,
      NULL,
      NULL,
      NULL,
      5,
      16.416585,
      36.452333,
      NULL,
      2.394703,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.116955,
      NULL,
      0.697935,
      NULL,
      2.152423,
      NULL,
      3,
      NULL,
      1.655350,
      NULL,
      3,
      NULL,
      0.334194,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.854583,
      0.299148,
      NULL,
      1,
      NULL,
      0.723864,
      NULL,
      NULL,
      NULL,
      1.818995,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.133587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.940743,
      NULL,
      1,
      NULL,
      1.813901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.844486,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.345942,
      NULL,
      1.143030,
      NULL,
      0.661763,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.000902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.827640,
      NULL,
      1.336289,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.609671,
      0.792563,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      62,
      NULL,
      3,
      NULL,
      2.179392,
      NULL,
      0,
      1,
      NULL,
      23,
      NULL,
      3,
      2,
      3.372543,
      3.982028,
      0.980188,
      2.678331,
      1.642242,
      0,
      NULL,
      2.322559,
      NULL,
      3,
      5.637545,
      NULL,
      2.403548,
      1.723511,
      NULL,
      NULL,
      NULL,
      1.722717,
      0,
      NULL,
      0.454182,
      1.280225,
      NULL,
      0.818528,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.037391,
      1.240617,
      NULL,
      1,
      0,
      NULL,
      0.605364,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.948934,
      NULL,
      1,
      NULL,
      1.059046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599527,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      37,
      1,
      5,
      NULL,
      NULL,
      '42022',
      '03214',
      0.185537,
      NULL,
      '',
      '',
      NULL,
      '3032',
      '',
      '');
commit;
end;
/


