set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      9.471956,
      6,
      3,
      1.122713,
      5,
      NULL,
      1,
      1.344349,
      '032',
      '02430121',
      NULL,
      40.966780,
      NULL,
      NULL,
      1.731461,
      5,
      NULL,
      '3142',
      5.108705,
      NULL,
      NULL,
      NULL,
      ' 7-26-1976',
      37,
      43.631941,
      NULL,
      NULL,
      2.000108,
      '10- 2-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 7-19-1999',
      ' 5- 1-2000',
      NULL,
      3,
      NULL,
      NULL,
      3,
      0.671325,
      1,
      3.768283,
      3,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      1.597356,
      1,
      1.242530,
      1,
      NULL,
      0.043975,
      0.683635,
      2.351848,
      NULL,
      1.253061,
      1,
      2,
      NULL,
      3,
      2.687074,
      7.890779,
      1,
      2,
      1,
      NULL,
      0,
      3,
      NULL,
      0.581468,
      NULL,
      2.156845,
      1,
      6.286984,
      1,
      2,
      1.019817,
      1,
      1,
      NULL,
      NULL,
      0.636793,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.899349,
      0.543183,
      0,
      2,
      2,
      NULL,
      3,
      NULL,
      3.585626,
      1,
      0.109962,
      0.042726,
      NULL,
      1.960590,
      0.487881,
      1,
      3,
      3,
      0.392127,
      9.831956,
      NULL,
      5,
      1,
      1.762391,
      NULL,
      NULL,
      0.336571,
      NULL,
      NULL,
      7.429693,
      4,
      5.185946,
      0,
      NULL,
      1.635666,
      4.075631,
      NULL,
      1.388054,
      0,
      0,
      0.991517,
      NULL,
      NULL,
      0.178260,
      NULL,
      0,
      1.982162,
      0,
      NULL,
      0,
      1,
      6.332202,
      3.532115,
      6.821088,
      0,
      5.237444,
      0,
      1,
      NULL,
      8.619771,
      NULL,
      NULL,
      8,
      0.051762,
      2.587717,
      1,
      4.552461,
      2.610661,
      10.413705,
      NULL,
      3,
      4,
      2,
      5.072561,
      1.066516,
      2.360800,
      1,
      ' 7-26-1991',
      NULL,
      ' 9- 5-1991',
      62,
      2.778709,
      0.777441,
      NULL,
      3.567177,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573393,
      NULL,
      NULL,
      0.128000,
      0.736088,
      NULL,
      NULL,
      0.202747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7,
      NULL,
      0.578006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.299776,
      1.756967,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.812477,
      2,
      5,
      NULL,
      4.769194,
      0.576209,
      NULL,
      NULL,
      0.507429,
      1,
      0.547856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405447,
      0,
      0.868646,
      1,
      0,
      NULL,
      NULL,
      3.524094,
      48.208889,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118662,
      0,
      NULL,
      3.059127,
      0,
      0.009833,
      1,
      NULL,
      NULL,
      2.783834,
      0.984135,
      0.077244,
      2.964362,
      2.331658,
      1.820007,
      3.757502,
      4,
      0.966448,
      NULL,
      3,
      1.008612,
      1.922386,
      1,
      NULL,
      1.833701,
      1,
      1,
      0,
      1.350927,
      NULL,
      5,
      0.476153,
      2.240747,
      11.238225,
      NULL,
      1.325312,
      NULL,
      3.074544,
      3,
      3,
      4.219119,
      2.732229,
      0.089236,
      NULL,
      26,
      NULL,
      NULL,
      51,
      NULL,
      27,
      NULL,
      0.627088,
      4.719568,
      1.612906,
      '11303',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      1.297568,
      '2423',
      '',
      '',
      0.855997,
      NULL,
      45.677428,
      37,
      2.155998,
      NULL,
      3,
      NULL,
      1.743967,
      NULL,
      0,
      0.110197,
      0,
      NULL,
      NULL,
      1,
      0,
      2.907518,
      1,
      NULL,
      NULL,
      0.117615,
      NULL,
      NULL,
      NULL,
      0.799915,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0.396732,
      2,
      0.082969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647501,
      1,
      3,
      0,
      1.388720,
      NULL,
      NULL,
      NULL,
      1.192270,
      NULL,
      NULL,
      NULL,
      1.317473,
      2.654070,
      0.948012,
      1.693908,
      0,
      1.306401,
      3,
      0,
      3.043638,
      1.231691,
      0,
      1.290778,
      3.450138,
      NULL,
      0,
      2.625886,
      0,
      3.613884,
      3.609788,
      0,
      1,
      0.139043,
      NULL,
      NULL,
      0.219449,
      0.801702,
      1.137199,
      3.082070,
      3.423958,
      NULL,
      3,
      0.850127,
      1,
      0,
      9.188489,
      1.089806,
      1.690298,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.494872,
      3.401376,
      2,
      1.220810,
      1,
      NULL,
      NULL,
      NULL,
      5.370305,
      2,
      1.241399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.746630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.229222,
      3.050271,
      NULL,
      3.062878,
      0,
      NULL,
      7,
      4,
      6.190918,
      6,
      0,
      3,
      0.980531,
      NULL,
      NULL,
      2.174850,
      NULL,
      NULL,
      2,
      2.628258,
      0.294013,
      3.939322,
      NULL,
      1.393746,
      2,
      NULL,
      3,
      3.403687,
      1,
      2.563832,
      2.964489,
      0.837430,
      1.019685,
      2,
      NULL,
      2.740036,
      1,
      NULL,
      0,
      NULL,
      7.027976,
      7,
      5,
      NULL,
      3.096460,
      1,
      NULL,
      7,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.103668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.778051,
      NULL,
      NULL,
      1.661578,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.550713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.271676,
      2,
      NULL,
      NULL,
      0,
      2.254876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      163.331411,
      NULL,
      NULL,
      NULL,
      0.518131,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.809591,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.266671,
      NULL,
      NULL,
      NULL,
      0.750470,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.275587,
      NULL,
      NULL,
      NULL,
      0.045279,
      NULL,
      NULL,
      NULL,
      3.645171,
      NULL,
      NULL,
      NULL,
      8.801042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.244791,
      NULL,
      NULL,
      1,
      NULL,
      1.088631,
      76,
      5,
      NULL,
      1.074508,
      0,
      1.840652,
      0.687039,
      0,
      1,
      1,
      0.116108,
      0,
      0,
      0,
      1.033109,
      0,
      0,
      0.589892,
      1.360016,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.319871,
      0.500762,
      1.990958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427933,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.319934,
      NULL,
      NULL,
      NULL,
      0.061476,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.639064,
      NULL,
      0.632925,
      NULL,
      0,
      NULL,
      0.504113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312377,
      0.922374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.156729,
      NULL,
      NULL,
      NULL,
      1.051146,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.611071,
      5,
      NULL,
      3.347854,
      1,
      5,
      NULL,
      1.244471,
      0.233715,
      0,
      0.952449,
      0.308237,
      NULL,
      3,
      2.251554,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.190317,
      NULL,
      NULL,
      2.992796,
      NULL,
      2,
      3.783315,
      NULL,
      0.611329,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      3.763897,
      NULL,
      0,
      NULL,
      1.928911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.959911,
      NULL,
      5,
      2.531822,
      8,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      0,
      4.754895,
      1.591398,
      '04114',
      NULL,
      '',
      0.298889,
      '',
      '',
      '',
      2.081788,
      '1301',
      NULL,
      '');
commit;
end;
/


