set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7717600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      2.888708,
      NULL,
      0,
      2,
      '3334',
      1,
      1,
      NULL,
      NULL,
      ' 7- 6-1997',
      18.977416,
      NULL,
      NULL,
      0.016931,
      0.009032,
      NULL,
      NULL,
      1.223433,
      127.365429,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1984',
      ' 2-13-1989',
      0.538702,
      NULL,
      3,
      1.207074,
      1,
      0.925307,
      0,
      0.892480,
      0.072459,
      8,
      0,
      15,
      9,
      NULL,
      29.322729,
      9,
      14,
      2.371927,
      3,
      NULL,
      3.001687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.270433,
      4,
      9,
      NULL,
      4.786199,
      1.556525,
      0,
      0,
      0.628759,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568906,
      0,
      NULL,
      4.299454,
      NULL,
      5.510208,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      0,
      0.101927,
      0,
      0.946532,
      1.525843,
      1.704422,
      2.238334,
      0.426783,
      0,
      2,
      0.302055,
      3,
      NULL,
      2.444335,
      1.234887,
      NULL,
      1,
      5,
      0,
      1,
      0,
      1.199222,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.506076,
      1.273689,
      0,
      1,
      0,
      1,
      0.618289,
      0,
      0.113831,
      1,
      0,
      1.752973,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.422264,
      NULL,
      2.260244,
      NULL,
      0.913877,
      1.991648,
      0.788826,
      0.461150,
      0.910785,
      0.939699,
      NULL,
      1.860943,
      1.412245,
      NULL,
      1,
      4.459055,
      4,
      1,
      8,
      1.802346,
      3,
      7,
      5.130346,
      0,
      1.129959,
      0.520892,
      NULL,
      NULL,
      '11-27-1980',
      339,
      NULL,
      2.645378,
      NULL,
      4,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.851720,
      NULL,
      NULL,
      1,
      3.582189,
      1,
      0.178125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      256,
      0.984239,
      0,
      4.629428,
      0,
      3.067745,
      1,
      0,
      0.059526,
      5,
      1.635126,
      0,
      NULL,
      1.048428,
      NULL,
      3.031335,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.299538,
      1,
      NULL,
      1,
      0.302308,
      0,
      0.425162,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.667090,
      0.352178,
      3,
      3,
      2,
      1.377774,
      0,
      3,
      0,
      1,
      1.328469,
      3.960033,
      3,
      2,
      NULL,
      0.482399,
      NULL,
      0.858111,
      1.061912,
      NULL,
      1,
      1,
      1.357343,
      NULL,
      1.017006,
      NULL,
      1,
      NULL,
      0,
      2.650942,
      NULL,
      0.213013,
      11,
      5.444884,
      4.321904,
      11,
      2,
      4,
      1,
      1,
      6.853278,
      3,
      2,
      2.261834,
      5,
      3,
      0.438767,
      NULL,
      19,
      54.297331,
      70,
      NULL,
      NULL,
      NULL,
      '20240',
      '',
      '',
      0.599773,
      '10031',
      '',
      NULL,
      1,
      NULL,
      '40423',
      NULL,
      NULL,
      23,
      195.889490,
      52.671260,
      1.305373,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456385,
      2.182108,
      3,
      NULL,
      0,
      0.701174,
      3.875903,
      0.608427,
      0,
      NULL,
      0.603276,
      0.876342,
      1,
      NULL,
      NULL,
      0.939025,
      1,
      NULL,
      0,
      0,
      NULL,
      3,
      1.469281,
      0,
      0,
      0.326309,
      0.866809,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      1,
      1.615198,
      NULL,
      NULL,
      3,
      1.083395,
      1,
      NULL,
      NULL,
      NULL,
      0.234115,
      NULL,
      NULL,
      NULL,
      2.042030,
      0,
      1.147607,
      NULL,
      NULL,
      NULL,
      0.948606,
      NULL,
      NULL,
      1,
      1.118038,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.112720,
      NULL,
      0,
      0.024184,
      2.942176,
      1.693392,
      0,
      0,
      1,
      0,
      1.975899,
      1.657332,
      0.631198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.415241,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.393877,
      NULL,
      NULL,
      NULL,
      0.737646,
      NULL,
      NULL,
      0.369664,
      NULL,
      NULL,
      0,
      0,
      1,
      1.856137,
      NULL,
      NULL,
      2,
      1.555564,
      NULL,
      0,
      NULL,
      NULL,
      1.300972,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.324978,
      NULL,
      NULL,
      1.437704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279791,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.126895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.856383,
      1.235581,
      0,
      1.790816,
      1,
      NULL,
      0,
      3,
      8.428244,
      2,
      7.524727,
      0,
      0.255329,
      0,
      2.512216,
      3,
      0.672559,
      0,
      0.022293,
      0,
      0,
      NULL,
      0.563749,
      5,
      1,
      5.592355,
      0.429604,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.181700,
      0,
      0,
      NULL,
      0.551321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.561554,
      0.791579,
      0.263136,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.331225,
      NULL,
      1.838657,
      1,
      0.975634,
      0.362239,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.316083,
      NULL,
      1,
      78,
      26.092885,
      1.129637,
      0.074299,
      0,
      1.239406,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      0.037993,
      0,
      1,
      NULL,
      3.040582,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.756956,
      NULL,
      0,
      NULL,
      1.163030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.694300,
      0.777579,
      0,
      NULL,
      0.865815,
      NULL,
      1.396501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.111806,
      1,
      1.120556,
      NULL,
      0.608055,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.157054,
      NULL,
      0.612372,
      NULL,
      0,
      NULL,
      1.117684,
      1,
      3.210014,
      NULL,
      0.604028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403146,
      NULL,
      1,
      NULL,
      1.554263,
      NULL,
      1.757535,
      1,
      1.110095,
      NULL,
      0.713797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.097432,
      NULL,
      0.725378,
      0.127001,
      2,
      NULL,
      0.710933,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.638768,
      1,
      NULL,
      NULL,
      NULL,
      0.617006,
      NULL,
      NULL,
      NULL,
      0.412033,
      NULL,
      0.863691,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      140,
      NULL,
      2,
      NULL,
      2.647681,
      NULL,
      1.133829,
      0,
      2,
      NULL,
      NULL,
      0.383763,
      NULL,
      NULL,
      NULL,
      0.018991,
      NULL,
      1,
      3.240300,
      0.419963,
      0,
      NULL,
      2,
      2,
      1,
      0.044487,
      1.670653,
      3.867771,
      1,
      NULL,
      NULL,
      2.687591,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.076113,
      NULL,
      NULL,
      2.247895,
      NULL,
      0,
      1,
      NULL,
      3.756702,
      1.278757,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      3.485861,
      2,
      NULL,
      0.207644,
      0,
      0.427584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209650,
      NULL,
      0.001694,
      NULL,
      0,
      NULL,
      1,
      7,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.917399,
      NULL,
      NULL,
      '30404',
      '43414',
      '',
      2,
      NULL,
      NULL,
      NULL,
      4,
      '2343',
      '14443',
      '');
commit;
end;
/


