set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6508568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '32',
      0,
      26,
      '0340430',
      2.679335,
      NULL,
      0,
      2,
      '4414',
      4.740165,
      1.776462,
      NULL,
      NULL,
      ' 5- 6-1978',
      47,
      34.731306,
      NULL,
      2.151642,
      1,
      '10- 6-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      0.826534,
      NULL,
      ' 4- 7-1985',
      ' 5- 4-1989',
      1.584339,
      NULL,
      3.784674,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      3.639705,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.327946,
      NULL,
      1.074228,
      1,
      0.543021,
      NULL,
      1,
      1,
      0,
      0.060333,
      NULL,
      NULL,
      1.121952,
      0,
      7,
      1,
      NULL,
      1.378731,
      0,
      NULL,
      NULL,
      2,
      0,
      3,
      1.022360,
      3.556236,
      1,
      1.062867,
      1,
      5,
      0.445241,
      2,
      0.886291,
      0,
      NULL,
      NULL,
      NULL,
      1.182203,
      NULL,
      NULL,
      2.830178,
      1,
      1,
      1.407466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949561,
      0.816941,
      1.796107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784392,
      NULL,
      2.891993,
      0,
      6,
      4.323495,
      1,
      1,
      1,
      NULL,
      1.363558,
      1,
      1.237427,
      0,
      1,
      0.332706,
      0,
      0.102089,
      0.276021,
      NULL,
      NULL,
      NULL,
      0.114370,
      0.075374,
      0,
      0.864189,
      0.040323,
      1,
      1,
      0.569795,
      0,
      1.334082,
      1,
      NULL,
      1.077850,
      6.759723,
      NULL,
      NULL,
      4.400316,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0,
      1,
      0.488477,
      2.408069,
      NULL,
      1,
      ' 9-10-1988',
      24,
      1,
      1.807479,
      0.704998,
      9.333888,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3.873731,
      NULL,
      1,
      1.578283,
      1.117181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.207484,
      NULL,
      36,
      3,
      3.913439,
      5.415463,
      NULL,
      0,
      NULL,
      NULL,
      8,
      1.313479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.147082,
      2.250433,
      2,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204232,
      4.019471,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.889086,
      1,
      0.482697,
      1.796003,
      56.913240,
      0.643342,
      0.286782,
      NULL,
      NULL,
      NULL,
      3,
      0.921591,
      2,
      2.572825,
      1,
      2.013078,
      NULL,
      2,
      0,
      1,
      3.852575,
      0.709114,
      3,
      3,
      2.272579,
      3,
      2,
      NULL,
      1.335844,
      2.675893,
      0,
      1,
      0,
      NULL,
      1.063229,
      1.663346,
      1,
      1,
      1.951807,
      0.072542,
      2.033424,
      0,
      0.045546,
      9.556033,
      NULL,
      NULL,
      5.838921,
      6,
      1.269616,
      3.538893,
      5.068133,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      31.253338,
      33,
      0,
      NULL,
      0.761780,
      '',
      '',
      '',
      NULL,
      '21312',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3.259700,
      12,
      NULL,
      48,
      3.895718,
      53.697723,
      NULL,
      NULL,
      0.675831,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      1.176322,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.407716,
      0.875930,
      0,
      NULL,
      NULL,
      1.727974,
      NULL,
      NULL,
      0.079111,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.298879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856887,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.578211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.561807,
      2.704250,
      0,
      0.367863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.429902,
      3.573506,
      1.018683,
      NULL,
      NULL,
      0.449951,
      1,
      2.623106,
      1.302865,
      2.311715,
      1,
      0.992829,
      5,
      NULL,
      4,
      0,
      0.066102,
      3.168790,
      NULL,
      NULL,
      NULL,
      3.311528,
      5.827409,
      3.402263,
      0.972228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.705598,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.394151,
      0.755578,
      0.683648,
      1.987393,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      6,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.515871,
      1.634310,
      1,
      NULL,
      3,
      0,
      2.095840,
      1.960358,
      2.816680,
      2,
      1,
      6.203131,
      NULL,
      2,
      2.633519,
      2,
      NULL,
      0.157394,
      0,
      1.211823,
      0.641546,
      1.941467,
      0.698605,
      0.643556,
      3.093490,
      2,
      8.658623,
      3.658135,
      1.036402,
      0,
      2.734515,
      2.622426,
      4.959612,
      NULL,
      0.235481,
      1,
      0.867660,
      0.067553,
      0,
      NULL,
      NULL,
      0.499636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008486,
      NULL,
      NULL,
      2.703922,
      NULL,
      NULL,
      0.702768,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.773009,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      1.255803,
      2.952221,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689315,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.635163,
      NULL,
      NULL,
      NULL,
      0.475948,
      NULL,
      NULL,
      NULL,
      2.866493,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.708499,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.047815,
      NULL,
      NULL,
      NULL,
      2.286813,
      0.299855,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.675535,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.907458,
      NULL,
      NULL,
      0.413123,
      1.140757,
      NULL,
      NULL,
      8,
      1.549873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.542643,
      1.267842,
      1,
      13,
      0,
      1,
      NULL,
      NULL,
      1.986281,
      3.112452,
      2,
      1,
      NULL,
      NULL,
      0.117844,
      NULL,
      NULL,
      1.028300,
      NULL,
      1,
      NULL,
      1.144855,
      NULL,
      0.344803,
      1.905013,
      NULL,
      NULL,
      0.745574,
      0.965214,
      0,
      1,
      0,
      1.958109,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.378915,
      3,
      0.398706,
      NULL,
      7.721261,
      1,
      0.061126,
      6.081968,
      NULL,
      2.675636,
      NULL,
      2.529498,
      2,
      2.454736,
      0,
      0,
      3,
      3.936156,
      2.987517,
      0,
      1,
      3.361782,
      NULL,
      NULL,
      2,
      NULL,
      2.543890,
      1.157047,
      NULL,
      2,
      2.680302,
      2,
      1,
      1.113023,
      NULL,
      0,
      3.373442,
      0,
      0.250747,
      NULL,
      NULL,
      1.700939,
      NULL,
      2.240429,
      NULL,
      1.499009,
      1.578756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583754,
      0,
      NULL,
      NULL,
      1.380093,
      1.521213,
      6,
      0.741149,
      1,
      2,
      0,
      87.333453,
      110.393190,
      3.908235,
      0.936805,
      NULL,
      '44423',
      NULL,
      '',
      2,
      '12034',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


