set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8535651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      '12',
      NULL,
      11.911633,
      '1212323',
      1,
      1.103994,
      NULL,
      3,
      '3211',
      3.527909,
      NULL,
      NULL,
      NULL,
      ' 6-18-1997',
      79.812969,
      5.280982,
      NULL,
      NULL,
      1,
      ' 0- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      1.520322,
      ' 6-19-1996',
      ' 6-28-2000',
      ' 6-24-1974',
      NULL,
      NULL,
      1.524833,
      2.321093,
      NULL,
      0,
      1.769931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.398137,
      NULL,
      1.022544,
      1,
      0.717989,
      1.382337,
      2.007110,
      1,
      1.810828,
      0.424244,
      1.770202,
      1.445305,
      1.968410,
      3.525245,
      3.841217,
      1,
      3,
      NULL,
      1.879248,
      0.111351,
      0.426150,
      0.219684,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1.876330,
      1,
      3.982920,
      3.384222,
      0.522446,
      0.378825,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.683751,
      1.813744,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683461,
      0,
      NULL,
      2,
      1.168638,
      0.541674,
      NULL,
      3.160325,
      1.179233,
      3,
      1.485420,
      0.571478,
      NULL,
      0.078005,
      1.151722,
      NULL,
      0.681347,
      3,
      1.850072,
      0,
      NULL,
      NULL,
      1.415344,
      NULL,
      NULL,
      0,
      NULL,
      6,
      0.854049,
      NULL,
      2,
      3.022390,
      NULL,
      1,
      1,
      0.233863,
      0.791646,
      0.071239,
      3,
      1,
      1,
      1,
      0.881730,
      0,
      NULL,
      0.831407,
      1,
      NULL,
      NULL,
      0,
      0.817934,
      5,
      1,
      0.329824,
      0,
      1,
      1.621348,
      1.427390,
      0.958825,
      3,
      0.510738,
      3,
      1,
      2,
      0,
      3.335603,
      1,
      0,
      2.340455,
      3,
      0,
      1.519546,
      NULL,
      ' 9- 9-1982',
      NULL,
      ' 6- 8-1990',
      17,
      NULL,
      0.022213,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.312897,
      1,
      1.947488,
      NULL,
      2.952899,
      4.944251,
      1,
      NULL,
      1.194866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196347,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202293,
      1,
      NULL,
      NULL,
      1,
      4.740628,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.851491,
      1,
      1,
      0,
      0.256130,
      0.445051,
      0,
      3.726985,
      NULL,
      NULL,
      1.393942,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977681,
      0,
      0,
      1,
      1.328129,
      1.867149,
      1,
      NULL,
      2,
      3.900139,
      2,
      4.296369,
      4,
      1.782042,
      0,
      0.341696,
      1.027895,
      1,
      1.984191,
      1.126117,
      0,
      3.163583,
      1.332595,
      0.369778,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.273284,
      8,
      0.404356,
      2.340119,
      9,
      NULL,
      0.003632,
      0,
      1.590016,
      5.475902,
      2,
      3.529701,
      3.481852,
      51.313420,
      3.265456,
      NULL,
      16.795580,
      NULL,
      60.654493,
      58.780832,
      1.989843,
      0,
      1,
      '13011',
      '02004',
      '',
      1.920226,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      18.852554,
      39,
      28.674391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.087736,
      NULL,
      NULL,
      1.701731,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.406924,
      NULL,
      NULL,
      1,
      1,
      2.482619,
      1.487407,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.160542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793346,
      1.217460,
      1,
      1,
      NULL,
      NULL,
      0.540432,
      NULL,
      NULL,
      1.736366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.628304,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844914,
      NULL,
      NULL,
      3,
      0.816504,
      3.207878,
      3.038123,
      3.903098,
      0,
      1.517612,
      NULL,
      NULL,
      1.597883,
      4.913361,
      3.776908,
      NULL,
      2.461287,
      NULL,
      1.134513,
      NULL,
      NULL,
      3.547636,
      NULL,
      2.105828,
      0.745179,
      NULL,
      NULL,
      1.969266,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.898739,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.288657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046427,
      NULL,
      NULL,
      2,
      5,
      3.214575,
      1.453157,
      NULL,
      NULL,
      2,
      1.605440,
      3,
      1,
      NULL,
      NULL,
      0,
      4,
      3,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2.657001,
      3.546704,
      NULL,
      0.704887,
      0.550802,
      2.327516,
      0.431420,
      NULL,
      NULL,
      3.700428,
      1.216682,
      3,
      1.529465,
      NULL,
      0,
      1.225359,
      0.478601,
      3.000170,
      NULL,
      NULL,
      0.976210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073553,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.960575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.046347,
      1.801547,
      NULL,
      0,
      0.397054,
      0.383087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.897407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.572780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.287462,
      NULL,
      NULL,
      0.074105,
      NULL,
      NULL,
      NULL,
      1.933846,
      1.682813,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.460730,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      11.942495,
      0,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.655101,
      NULL,
      0,
      0,
      0,
      1,
      1.653039,
      NULL,
      0.381188,
      0.092334,
      0.287288,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0.573452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111664,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967572,
      0,
      NULL,
      1.791768,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.853392,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.886381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184904,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658718,
      NULL,
      0.000195,
      NULL,
      0.385062,
      NULL,
      NULL,
      NULL,
      0.359203,
      NULL,
      NULL,
      NULL,
      0,
      1.260239,
      1,
      23,
      19.438097,
      2.305607,
      3,
      1,
      NULL,
      2.968506,
      2.109969,
      1.199751,
      0.048717,
      0.024567,
      0,
      4.990026,
      NULL,
      4.218058,
      0,
      2.980881,
      1.271103,
      NULL,
      1,
      0.840024,
      0.255823,
      0.957639,
      1,
      2,
      NULL,
      2.155212,
      1.535560,
      NULL,
      0.479301,
      0,
      NULL,
      1.595204,
      1,
      1.237997,
      0.012454,
      1,
      NULL,
      1,
      0,
      1.234088,
      0.931586,
      0.094692,
      0.225449,
      3.595430,
      1,
      0,
      1,
      NULL,
      1,
      0.204906,
      NULL,
      3.310797,
      0.281807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.125024,
      1,
      1,
      3.821722,
      1.066409,
      7,
      0.932825,
      NULL,
      NULL,
      55.720560,
      NULL,
      0,
      5.969795,
      2.227994,
      '10223',
      '02243',
      NULL,
      1,
      NULL,
      '',
      '',
      0.031176,
      '',
      '',
      '');
commit;
end;
/


