set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1142420',
      1.661290,
      1.818868,
      4,
      NULL,
      '4014',
      1.056515,
      0.607115,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      3.360314,
      NULL,
      NULL,
      ' 0- 3-1995',
      22.680295,
      0.003403,
      251,
      125.045971,
      0.459699,
      ' 1-10-1997',
      ' 5-18-2002',
      ' 9-14-1976',
      1,
      3,
      3,
      1.049217,
      1,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      8,
      8,
      23,
      NULL,
      NULL,
      0,
      6.894637,
      1,
      6,
      1.243500,
      2.687778,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.667273,
      1.815243,
      1.722525,
      1,
      2.871717,
      2,
      1,
      1.964539,
      4.287505,
      0,
      NULL,
      NULL,
      1.400114,
      NULL,
      8.880566,
      1,
      0.754527,
      3,
      1,
      4,
      2,
      1,
      NULL,
      1.366759,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.454690,
      3,
      NULL,
      1.098443,
      0.689784,
      NULL,
      0.461455,
      0,
      3.405061,
      0.422026,
      3,
      1,
      0,
      2.065150,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      5.905109,
      0.023757,
      1,
      1.690923,
      0,
      1.492967,
      0.357740,
      0,
      0.710281,
      0,
      1,
      NULL,
      1.563553,
      0,
      1,
      NULL,
      1.331530,
      0,
      0,
      0,
      0.326221,
      0.051114,
      0,
      8,
      1.165554,
      2,
      NULL,
      NULL,
      7.817182,
      4,
      2.083006,
      4,
      NULL,
      6.475537,
      3.664024,
      7.755429,
      NULL,
      1.530215,
      4,
      NULL,
      0,
      9.900499,
      NULL,
      3,
      ' 2-28-1985',
      97,
      ' 4-17-1991',
      67.568905,
      0,
      NULL,
      1.966229,
      NULL,
      1.000326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.358100,
      0.594217,
      NULL,
      NULL,
      3.925968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245491,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696757,
      0.978085,
      0.098960,
      1,
      2.716329,
      NULL,
      NULL,
      4.575943,
      0,
      3.330830,
      NULL,
      5,
      1.092657,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.508370,
      0.012681,
      1,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122304,
      3.045328,
      2.987585,
      2.535176,
      0.801029,
      NULL,
      0,
      2.889351,
      1.835040,
      1.395949,
      NULL,
      2.241214,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.448560,
      0.098012,
      1.349974,
      NULL,
      1,
      NULL,
      1.832280,
      NULL,
      0.088974,
      1.877909,
      0.325810,
      NULL,
      NULL,
      NULL,
      5,
      0.894688,
      1.178439,
      7.627748,
      6,
      NULL,
      NULL,
      6.778457,
      NULL,
      NULL,
      0,
      21,
      3,
      0.635395,
      NULL,
      0,
      8.939611,
      22.012820,
      0,
      NULL,
      3.738469,
      '04041',
      '',
      '',
      1.551493,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      36.914681,
      46.680239,
      NULL,
      0.826638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.026406,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.824335,
      NULL,
      NULL,
      3,
      3.733463,
      0,
      1.847511,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.667338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568280,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.369721,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.847422,
      0.217991,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.078928,
      0.775584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.173103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.942764,
      NULL,
      NULL,
      NULL,
      0.246588,
      NULL,
      NULL,
      0.507822,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.498062,
      NULL,
      NULL,
      0.838124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524967,
      NULL,
      NULL,
      0.800025,
      NULL,
      NULL,
      0.376289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.097138,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.759622,
      1.417617,
      3.921353,
      3,
      0,
      1.285775,
      5,
      2.938036,
      1.751432,
      3,
      1,
      3,
      2.210575,
      NULL,
      0.607063,
      1.675670,
      3.642355,
      2.918819,
      1.330357,
      0,
      5.460285,
      1.141747,
      7.801329,
      4,
      0.795089,
      2,
      3,
      NULL,
      7.822734,
      NULL,
      0.216813,
      NULL,
      1.978932,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218059,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.022017,
      NULL,
      NULL,
      0.007114,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.040572,
      1.944924,
      NULL,
      0,
      3,
      0.856551,
      NULL,
      NULL,
      1.331685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.485545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545768,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.595853,
      NULL,
      NULL,
      NULL,
      7.995578,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.001362,
      0,
      0,
      0,
      NULL,
      NULL,
      1.639486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.100705,
      NULL,
      NULL,
      0.180174,
      NULL,
      0.262408,
      29.588756,
      NULL,
      NULL,
      1.245941,
      1.988452,
      0.248554,
      0.654059,
      NULL,
      0.091949,
      0.633178,
      0.402853,
      0,
      1.126363,
      0.385388,
      0,
      1.419555,
      1.493118,
      0,
      1.411340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      1,
      3,
      0,
      5.229666,
      7,
      1.029511,
      NULL,
      1.804579,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.321481,
      1.726019,
      NULL,
      0,
      2.597553,
      NULL,
      NULL,
      0.185116,
      NULL,
      2,
      0,
      NULL,
      0.102697,
      NULL,
      NULL,
      1.151157,
      1.689238,
      NULL,
      0.594067,
      0,
      NULL,
      0.116184,
      NULL,
      NULL,
      3,
      0.283256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780901,
      NULL,
      NULL,
      NULL,
      0,
      5,
      7.449859,
      0.111067,
      NULL,
      NULL,
      35,
      65,
      NULL,
      1.422806,
      1.046669,
      NULL,
      '',
      '',
      1.037422,
      '',
      NULL,
      '',
      1.834367,
      NULL,
      NULL,
      NULL);
commit;
end;
/


