set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      '12',
      2.884831,
      15,
      '0342113',
      1,
      NULL,
      3,
      NULL,
      '2344',
      4,
      0,
      NULL,
      NULL,
      ' 2- 3-1999',
      29,
      NULL,
      NULL,
      1.521110,
      2.143429,
      ' 7- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      3.745952,
      NULL,
      NULL,
      ' 0-24-1981',
      2,
      1,
      0,
      0.947217,
      1,
      2,
      1.839526,
      0.003831,
      NULL,
      NULL,
      NULL,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0.572970,
      NULL,
      1,
      1.064657,
      0,
      0,
      1,
      4,
      0.550448,
      0.682988,
      1.320300,
      NULL,
      0.153754,
      3,
      2.021805,
      3,
      1,
      0,
      0.845526,
      1.816054,
      1,
      1.325804,
      0.691103,
      0.761024,
      NULL,
      1,
      0.831325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.200115,
      1.826569,
      NULL,
      1.972145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      5.543979,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.107608,
      NULL,
      2,
      NULL,
      0,
      0.736229,
      6,
      1.642273,
      NULL,
      4,
      0,
      3,
      3,
      6,
      5,
      3,
      2,
      0,
      NULL,
      6,
      5.867442,
      9,
      NULL,
      NULL,
      10,
      9,
      4,
      NULL,
      NULL,
      1,
      ' 5-23-2003',
      205,
      ' 8-27-1982',
      15.539546,
      1.713908,
      1.238658,
      0,
      0.974364,
      1.080030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473877,
      0.577826,
      1,
      NULL,
      NULL,
      0.397155,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0.445354,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859855,
      1,
      5.750311,
      0.022974,
      3.197408,
      0.851454,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.621534,
      NULL,
      1.612591,
      1.253810,
      0.297982,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.537193,
      0.117335,
      0,
      1,
      3.026152,
      0.774481,
      NULL,
      2.736040,
      NULL,
      1,
      1.509974,
      NULL,
      1.668812,
      NULL,
      0,
      3.678805,
      1.520163,
      0.658396,
      0,
      5,
      1.993052,
      0,
      0.082176,
      NULL,
      NULL,
      0.450477,
      NULL,
      1.440756,
      1.881961,
      0,
      1.914675,
      1.117622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.844173,
      NULL,
      NULL,
      NULL,
      2,
      5.628881,
      1,
      '30401',
      NULL,
      '',
      1.489232,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3.564344,
      7,
      NULL,
      15,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.857999,
      2,
      0.663532,
      0.500933,
      NULL,
      NULL,
      1.620958,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.324722,
      NULL,
      NULL,
      NULL,
      3.813359,
      NULL,
      NULL,
      1.187183,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.396833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828240,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.127062,
      3.880315,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.748867,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      2,
      2.618251,
      3,
      0.393543,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.468937,
      NULL,
      NULL,
      0.436219,
      NULL,
      NULL,
      0.936449,
      NULL,
      NULL,
      0.986836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826779,
      NULL,
      NULL,
      0.080327,
      0.914069,
      NULL,
      1.864815,
      NULL,
      NULL,
      4.207179,
      NULL,
      7.075958,
      6.897457,
      5,
      6,
      5,
      8,
      NULL,
      3.340854,
      2.153404,
      3,
      NULL,
      2,
      2,
      1.722586,
      1.602983,
      1,
      8,
      8.714194,
      NULL,
      2,
      1,
      0,
      2,
      0.929170,
      NULL,
      NULL,
      2.248182,
      0,
      NULL,
      0.153245,
      3.641335,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.433349,
      NULL,
      NULL,
      1.579495,
      NULL,
      1.330554,
      0.822947,
      0.333473,
      0.259704,
      NULL,
      NULL,
      0.559504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489900,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.132554,
      NULL,
      NULL,
      0.528021,
      NULL,
      NULL,
      1.390769,
      NULL,
      NULL,
      0.078046,
      NULL,
      NULL,
      1.039471,
      0,
      1.915781,
      1,
      0.399986,
      NULL,
      0.248177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515329,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.386288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.236696,
      NULL,
      NULL,
      NULL,
      0.350382,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.722072,
      NULL,
      NULL,
      NULL,
      1.468525,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.849806,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.314752,
      47.497418,
      516,
      0.402104,
      11.144860,
      138,
      1.394930,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.050837,
      3,
      1.456383,
      1,
      73,
      1.051371,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0.792446,
      0,
      1.939433,
      0,
      0,
      0.926887,
      1.854922,
      0,
      NULL,
      0.412971,
      1.932734,
      1.391758,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204583,
      3.457425,
      2,
      NULL,
      7,
      3,
      0,
      5.839207,
      6,
      2,
      3.002535,
      0.562505,
      0.806661,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.825725,
      NULL,
      1.645219,
      3.978296,
      NULL,
      1.197684,
      1,
      NULL,
      NULL,
      2.881916,
      NULL,
      2.666556,
      1,
      NULL,
      1.818830,
      1.715175,
      NULL,
      1.251402,
      0.968235,
      NULL,
      1.114943,
      0.297643,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.757650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227396,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.338351,
      8.952050,
      0,
      2,
      1.506654,
      2.370204,
      NULL,
      14.955527,
      NULL,
      NULL,
      0,
      '11323',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


