set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6458511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '0113040',
      NULL,
      0,
      3,
      3,
      NULL,
      NULL,
      0.593863,
      NULL,
      NULL,
      ' 9- 4-1995',
      24,
      NULL,
      4.237725,
      NULL,
      1.556302,
      ' 7- 5-1983',
      91,
      1.766060,
      33,
      57.548939,
      2.183776,
      ' 5-25-1985',
      ' 7-27-1994',
      NULL,
      1.399873,
      1.215919,
      0,
      1,
      1.385562,
      2,
      NULL,
      1.517911,
      NULL,
      NULL,
      NULL,
      0.169007,
      NULL,
      16.392427,
      26,
      6.369180,
      24.404975,
      0,
      1.839480,
      5,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1.593919,
      NULL,
      1.806518,
      1,
      4,
      NULL,
      2.174749,
      9,
      1.433907,
      NULL,
      0,
      1.932787,
      1,
      6.781296,
      NULL,
      1,
      1.948391,
      1.487376,
      1.287018,
      5.251144,
      0.764620,
      5,
      1,
      0.641290,
      NULL,
      NULL,
      NULL,
      1.590666,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100099,
      1.433743,
      0,
      1.008857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.111909,
      0.323070,
      NULL,
      1,
      1.010288,
      1,
      1.714598,
      0,
      0.889066,
      NULL,
      1.404248,
      0,
      NULL,
      NULL,
      1.416710,
      0,
      1,
      1.755322,
      1.965638,
      0,
      2,
      1,
      NULL,
      0,
      1.108939,
      0.327125,
      NULL,
      1.652319,
      1.093791,
      0,
      5.126538,
      2.326536,
      1.596999,
      2.499939,
      NULL,
      7,
      7,
      0.234753,
      5.494274,
      1,
      2,
      ' 4- 1-1990',
      341,
      ' 4-24-1996',
      61,
      NULL,
      0,
      0,
      3.492664,
      1.202030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.646001,
      0,
      1.748350,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.937143,
      NULL,
      843.751083,
      1,
      1.958269,
      0.123303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.464462,
      NULL,
      1.244610,
      1,
      0.316358,
      NULL,
      NULL,
      NULL,
      2,
      3.248064,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.434384,
      NULL,
      1,
      0.643171,
      2.563120,
      3,
      43.127934,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.445539,
      1.493541,
      NULL,
      NULL,
      1.800096,
      3,
      NULL,
      1,
      0.215495,
      0,
      1.592901,
      NULL,
      0.775726,
      NULL,
      0.773705,
      0.712946,
      NULL,
      0,
      0.639805,
      0.050553,
      1,
      0.890115,
      0.124994,
      1.348494,
      1,
      0.963129,
      1,
      0,
      1.214892,
      0,
      NULL,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      1,
      3.492745,
      1.726166,
      NULL,
      3.349707,
      3.812454,
      NULL,
      34,
      29,
      NULL,
      4.581306,
      1,
      NULL,
      NULL,
      '',
      '',
      1.962745,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      14.141012,
      180.258071,
      70.139955,
      1.284547,
      42,
      3,
      1.848761,
      1,
      3,
      2.581356,
      3.023966,
      NULL,
      NULL,
      NULL,
      0.083410,
      NULL,
      NULL,
      1.671422,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.384863,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304249,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.044018,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.860090,
      2.053548,
      0.342430,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.330447,
      0.988111,
      1.194948,
      0.869971,
      3.995167,
      1.195838,
      0,
      0,
      1,
      NULL,
      1.758001,
      0.297973,
      1,
      3.593009,
      0.607344,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033434,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0.609391,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700724,
      NULL,
      NULL,
      0.118655,
      NULL,
      NULL,
      1.764178,
      NULL,
      NULL,
      1.703556,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.508155,
      NULL,
      NULL,
      0,
      3.922382,
      0,
      NULL,
      NULL,
      NULL,
      1.599872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068379,
      NULL,
      NULL,
      0.975160,
      NULL,
      NULL,
      0.719454,
      NULL,
      NULL,
      2,
      1.264186,
      NULL,
      0.526014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.916566,
      3.153982,
      NULL,
      NULL,
      1.303100,
      NULL,
      6,
      0.010031,
      1.198243,
      1.254808,
      NULL,
      NULL,
      0,
      NULL,
      0.896947,
      3.010752,
      3,
      2,
      NULL,
      2,
      1,
      3.046902,
      5,
      3,
      NULL,
      1,
      1,
      3.170742,
      1,
      6,
      0,
      1.651397,
      NULL,
      1.775006,
      0.933028,
      NULL,
      NULL,
      NULL,
      1.829715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307862,
      NULL,
      NULL,
      0.291484,
      NULL,
      NULL,
      1.180836,
      NULL,
      NULL,
      0.406184,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.439563,
      NULL,
      NULL,
      1.920031,
      NULL,
      NULL,
      NULL,
      0.808350,
      0.860604,
      1.553965,
      0,
      3.075881,
      1,
      NULL,
      NULL,
      1.903257,
      NULL,
      NULL,
      NULL,
      202,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062626,
      NULL,
      NULL,
      NULL,
      1.968512,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.812675,
      NULL,
      NULL,
      NULL,
      1.827408,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.699789,
      107,
      21.039303,
      1.754622,
      187.705836,
      4.474009,
      1.487745,
      NULL,
      NULL,
      3,
      34.654932,
      2,
      3.021895,
      NULL,
      9.570910,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.781743,
      46,
      49.102649,
      0,
      NULL,
      0.983597,
      0.278080,
      1,
      1.073140,
      1,
      1.361267,
      NULL,
      0.888153,
      NULL,
      1.466482,
      1.177711,
      1.305803,
      0,
      0.002787,
      1,
      0.533791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6.538696,
      2,
      NULL,
      3.410163,
      7,
      2.308011,
      0,
      4.761523,
      1.977844,
      3,
      1.924058,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1.006373,
      0,
      NULL,
      0.133741,
      1,
      NULL,
      0,
      3,
      NULL,
      1.516555,
      2.008209,
      NULL,
      NULL,
      1.064617,
      NULL,
      0,
      1.231995,
      NULL,
      0.939301,
      0,
      NULL,
      0.287856,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1.563546,
      0.813971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      13.790675,
      3,
      1.640085,
      1,
      50.557967,
      48,
      3.439059,
      1,
      1.471490,
      '11220',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.912034,
      '',
      '',
      '');
commit;
end;
/


