set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      '3013',
      2,
      0.769114,
      NULL,
      NULL,
      '10-18-1978',
      22,
      NULL,
      1.434735,
      3.568764,
      1.145982,
      ' 1- 7-1998',
      25,
      2,
      206,
      55,
      0.514344,
      ' 1-26-1997',
      ' 1-29-1989',
      NULL,
      NULL,
      1.886388,
      1,
      1.708390,
      NULL,
      0.108180,
      2.628842,
      1,
      NULL,
      NULL,
      NULL,
      0.848035,
      0.299746,
      29,
      8,
      5,
      NULL,
      1.173211,
      1.125364,
      2.891584,
      1.666821,
      0.555628,
      2,
      0.851964,
      2,
      0.788530,
      0.023015,
      0,
      1,
      NULL,
      0,
      NULL,
      2,
      1,
      3.489127,
      2,
      NULL,
      1.431698,
      9,
      8,
      NULL,
      0.051887,
      1,
      0.233675,
      0.284370,
      NULL,
      NULL,
      9.615240,
      3,
      3,
      1.886734,
      NULL,
      0,
      NULL,
      NULL,
      1.222383,
      1,
      5.252719,
      1.284593,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.916632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.034230,
      4.093809,
      1,
      1.296969,
      1,
      1,
      1,
      0,
      1,
      1.198280,
      1,
      1.664102,
      5,
      0,
      NULL,
      0.759454,
      0.923061,
      1,
      NULL,
      NULL,
      NULL,
      0.573165,
      3.282236,
      5,
      0.688140,
      5,
      NULL,
      0.972318,
      0.698998,
      1.023338,
      1.651720,
      0,
      NULL,
      NULL,
      NULL,
      7.435017,
      6,
      4,
      NULL,
      0.716617,
      1,
      5,
      7.968232,
      4.502327,
      5,
      6.708675,
      NULL,
      ' 1- 9-1998',
      38.751088,
      '10- 9-1997',
      1.398333,
      0,
      4,
      1.653872,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.532538,
      6.710367,
      0.462673,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      1,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.122878,
      2.087361,
      3,
      3.157436,
      0.011822,
      0.726447,
      NULL,
      7,
      1,
      9,
      2.060213,
      NULL,
      NULL,
      NULL,
      3.216317,
      7,
      3,
      NULL,
      2,
      1.242425,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1998',
      2,
      1,
      4.072807,
      NULL,
      0,
      2.232442,
      1.505232,
      0,
      0,
      1,
      0.678926,
      1,
      75.517493,
      0.202726,
      1.190872,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.541315,
      0.842832,
      0,
      3.897247,
      NULL,
      0.557231,
      1.053346,
      3,
      2.234613,
      0,
      2.864206,
      33.917432,
      NULL,
      75.644504,
      23,
      172,
      51.461037,
      1,
      0.130690,
      0.621010,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      0,
      11.865404,
      7,
      7.666825,
      NULL,
      NULL,
      1,
      NULL,
      1.972178,
      7.609419,
      NULL,
      2,
      NULL,
      23,
      5,
      2,
      NULL,
      NULL,
      NULL,
      65.782395,
      NULL,
      1.289621,
      4,
      '20340',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      4,
      16,
      14,
      2,
      23.330039,
      NULL,
      5,
      0,
      0.418670,
      NULL,
      NULL,
      0.353485,
      NULL,
      NULL,
      0.132014,
      NULL,
      NULL,
      0.745132,
      NULL,
      NULL,
      1.172465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350394,
      NULL,
      NULL,
      0.429529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341251,
      NULL,
      NULL,
      0.832537,
      NULL,
      NULL,
      0.468087,
      NULL,
      NULL,
      0.154641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273307,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953073,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.616847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924296,
      NULL,
      NULL,
      0.075092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484861,
      NULL,
      NULL,
      0.598858,
      3.794630,
      1,
      NULL,
      NULL,
      NULL,
      2.130732,
      4.570777,
      2.697638,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      1.312864,
      NULL,
      NULL,
      2.622247,
      1.361925,
      0.796297,
      NULL,
      2,
      0,
      6,
      3.327467,
      NULL,
      NULL,
      NULL,
      1.495081,
      0,
      NULL,
      NULL,
      2.749318,
      NULL,
      2.002665,
      0.934203,
      NULL,
      NULL,
      6,
      2.848412,
      0.509746,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.826963,
      NULL,
      0.624280,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.967301,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.788261,
      2,
      3.049363,
      2.750736,
      1,
      1.349419,
      NULL,
      NULL,
      1.670764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      165,
      NULL,
      0,
      0.697976,
      0,
      NULL,
      0,
      NULL,
      0.030138,
      1,
      0,
      0.771668,
      0.085905,
      1.817948,
      1,
      0,
      0,
      0,
      3,
      2,
      NULL,
      1.276715,
      NULL,
      0.261172,
      1,
      NULL,
      1,
      1.538301,
      1.705629,
      1,
      1.459496,
      0.247055,
      1,
      0.821020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649673,
      0.337995,
      0.969135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429977,
      1.050360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200189,
      1,
      NULL,
      0.338048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213957,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.630409,
      0.721486,
      0,
      0.404284,
      3,
      NULL,
      74,
      1.601127,
      NULL,
      0,
      1.106689,
      1,
      2,
      0,
      NULL,
      20.284130,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706613,
      1.458602,
      NULL,
      5.364538,
      3.458970,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2.230274,
      1,
      0.142671,
      1,
      NULL,
      1.783952,
      NULL,
      0,
      0.236415,
      0.174473,
      0,
      0,
      0.616028,
      NULL,
      0,
      1,
      3.231656,
      0.578623,
      2,
      1,
      1.796236,
      1,
      1,
      3.788733,
      0,
      0.144847,
      1,
      NULL,
      1.321277,
      2.585588,
      0.925873,
      1.082591,
      1.713760,
      NULL,
      3.977269,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0.584453,
      NULL,
      6,
      5,
      1,
      NULL,
      NULL,
      111,
      134,
      0.745111,
      0.633549,
      4,
      '13430',
      '24243',
      NULL,
      1.353967,
      '',
      '',
      '',
      0.917272,
      '',
      '',
      '');
commit;
end;
/


