set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8314540';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.239598,
      1,
      2.086593,
      NULL,
      1,
      0,
      NULL,
      0,
      '440',
      '41310010',
      79.060684,
      NULL,
      '3302310',
      0,
      1.197939,
      2,
      2,
      '3430',
      2,
      0.732072,
      NULL,
      NULL,
      NULL,
      114,
      165.183189,
      NULL,
      2,
      1,
      '11-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      1.879356,
      ' 1- 4-1989',
      ' 4- 0-1988',
      ' 2-29-2002',
      1,
      3.113078,
      1,
      NULL,
      1.607730,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      11.690911,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      0,
      0,
      1.306857,
      NULL,
      1.997773,
      0,
      NULL,
      0.227820,
      1,
      0,
      0,
      3.142043,
      1.511803,
      NULL,
      NULL,
      NULL,
      1.354687,
      1.834296,
      1,
      1.744627,
      0.495646,
      2.306262,
      1.532546,
      0,
      1,
      1.517902,
      1.043376,
      5,
      1.123571,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.356685,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3,
      1,
      NULL,
      3,
      0.078160,
      0,
      NULL,
      2.983146,
      1,
      1,
      0,
      1,
      0,
      3,
      1.869146,
      3,
      0.881283,
      0.472668,
      0.119542,
      2.290746,
      1,
      5,
      3.459110,
      0.365933,
      NULL,
      NULL,
      0.087438,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      2.160218,
      NULL,
      1,
      0,
      NULL,
      5.215089,
      0,
      6.685905,
      1,
      0,
      NULL,
      NULL,
      1,
      1.660155,
      1.863228,
      NULL,
      NULL,
      NULL,
      1.686574,
      0.328071,
      1,
      1.389063,
      NULL,
      1,
      NULL,
      0,
      0.352020,
      0.203172,
      0,
      1.899767,
      NULL,
      9.437543,
      8.863130,
      0.927265,
      2.025662,
      NULL,
      4.885676,
      2,
      5.545161,
      5,
      4,
      NULL,
      3,
      3.976141,
      NULL,
      414.364511,
      ' 6- 1-2001',
      28,
      3.889268,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.993188,
      4.030681,
      1,
      9,
      2.189728,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.008596,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.654224,
      1.048015,
      3.684693,
      3,
      4.376947,
      1.221131,
      NULL,
      NULL,
      1.790715,
      9.228256,
      NULL,
      3,
      NULL,
      0.509380,
      1,
      7.371443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.191604,
      0,
      1.814081,
      0.450599,
      1.587875,
      0,
      NULL,
      NULL,
      16.133513,
      1.578612,
      1.175851,
      NULL,
      NULL,
      NULL,
      0.941342,
      0.094337,
      3.468811,
      1.545412,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.288383,
      NULL,
      2,
      2,
      2,
      0.472006,
      0.151407,
      1.987063,
      0,
      NULL,
      0.257957,
      0,
      0,
      NULL,
      1.917768,
      NULL,
      NULL,
      NULL,
      1.769569,
      0.354615,
      2,
      0.314074,
      11.858597,
      9.726517,
      0.276989,
      NULL,
      0.383596,
      NULL,
      4.062065,
      2.025651,
      4.824793,
      NULL,
      1.676050,
      1,
      NULL,
      3,
      NULL,
      51,
      NULL,
      60,
      NULL,
      2.986068,
      2,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.941091,
      NULL,
      '',
      '',
      1.061055,
      8.798115,
      42.199792,
      9.792623,
      NULL,
      4.186843,
      0.501874,
      3,
      0.214478,
      2,
      2.942190,
      2.016507,
      1,
      NULL,
      NULL,
      1.491976,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.389837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.901662,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2,
      4.587925,
      0.843051,
      0,
      NULL,
      NULL,
      NULL,
      2.334727,
      0,
      0,
      NULL,
      1,
      3,
      3,
      0.056708,
      NULL,
      NULL,
      3.329707,
      1,
      0.061881,
      1.448386,
      NULL,
      1,
      2.355060,
      0,
      NULL,
      NULL,
      3.903543,
      1.415379,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.156958,
      NULL,
      NULL,
      6.256302,
      NULL,
      2,
      0.804426,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.370737,
      1,
      0.144979,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152966,
      NULL,
      NULL,
      0.372607,
      NULL,
      NULL,
      0.129952,
      NULL,
      NULL,
      0,
      1.114015,
      1,
      1.978212,
      NULL,
      NULL,
      NULL,
      1.965355,
      1.042332,
      0.555845,
      NULL,
      NULL,
      0.519284,
      NULL,
      NULL,
      1.148245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603896,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.467747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.622384,
      3.708630,
      1,
      6,
      0.390033,
      0.636631,
      2,
      2.612498,
      0.338278,
      2,
      0.298508,
      2,
      0.533380,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3.799958,
      NULL,
      1.055332,
      2,
      NULL,
      0.748145,
      NULL,
      0.763441,
      3.484800,
      2.423440,
      1,
      2.310244,
      1.114735,
      4.780886,
      3.525538,
      8.716180,
      1.891080,
      NULL,
      NULL,
      3.952427,
      6.506645,
      0.717938,
      0,
      0.291271,
      NULL,
      0,
      0.593681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.434961,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.229448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.467218,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      3,
      1.319541,
      1,
      NULL,
      4.475883,
      5,
      0.005238,
      NULL,
      NULL,
      2.933836,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.416285,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075181,
      NULL,
      1,
      NULL,
      2,
      1.856260,
      NULL,
      NULL,
      0,
      0.157299,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.143885,
      NULL,
      0.305000,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.795690,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813745,
      NULL,
      1.377583,
      NULL,
      1.663939,
      2.335811,
      3.936437,
      NULL,
      2.455726,
      1.173321,
      NULL,
      0,
      3,
      2,
      0,
      3,
      2.607449,
      5.830645,
      6,
      1,
      NULL,
      NULL,
      0.344933,
      0,
      1,
      0.705243,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1.220359,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.900022,
      1,
      NULL,
      0,
      1.065988,
      1.133783,
      1,
      0,
      0,
      1.433815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.219467,
      NULL,
      1.820091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.105137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987427,
      1.301772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278853,
      0.952171,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.065072,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.243927,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550427,
      0.240021,
      0.359725,
      0.334618,
      4.622598,
      5,
      1.429771,
      1.124356,
      16,
      2,
      1.957944,
      3.647613,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      2,
      1,
      0.841417,
      0,
      1.972401,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      3,
      0.652132,
      1.384401,
      1.300157,
      1.817695,
      2,
      0.225613,
      1.850258,
      1,
      3,
      1.593459,
      0.340856,
      0,
      2.527162,
      NULL,
      1,
      1.990826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713639,
      1.150214,
      1,
      1.838469,
      0.859635,
      0.633534,
      1,
      13.552787,
      NULL,
      NULL,
      0.905926,
      3.903517,
      NULL,
      67.610330,
      4.144290,
      5,
      2,
      '00403',
      '',
      NULL,
      1.374776,
      '',
      '',
      '',
      1,
      '0131',
      NULL,
      '');
commit;
end;
/


