set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7730763';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '0322200',
      1,
      1.909451,
      NULL,
      NULL,
      '2030',
      3,
      1,
      NULL,
      NULL,
      ' 2-18-2003',
      105,
      NULL,
      NULL,
      2,
      1.676708,
      ' 3-25-1976',
      123,
      NULL,
      18.717025,
      18,
      0.247607,
      NULL,
      NULL,
      ' 3-28-1993',
      3.806352,
      2.413275,
      0,
      NULL,
      NULL,
      0,
      1.637490,
      1.718611,
      0,
      NULL,
      NULL,
      11.909892,
      3.095947,
      119.895467,
      103,
      14.181613,
      6.420058,
      15,
      1.286627,
      11.962051,
      1.008787,
      0,
      NULL,
      1.440096,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      159.546946,
      0,
      7,
      7.880409,
      3.724374,
      3.573643,
      0,
      1.244641,
      NULL,
      1,
      3,
      1.970388,
      1,
      0.909728,
      NULL,
      1.751837,
      0,
      2,
      0.358406,
      NULL,
      3.192166,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690290,
      NULL,
      1,
      3.310370,
      1.152337,
      NULL,
      0,
      3.322729,
      1,
      1.551332,
      1.328162,
      NULL,
      0,
      0.782325,
      1,
      0.333864,
      1.012653,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.102450,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      1.250329,
      1,
      0.887570,
      1.466025,
      1.718671,
      0.257910,
      1.938985,
      1.735631,
      NULL,
      1.591563,
      0.876790,
      1,
      0,
      NULL,
      1.513530,
      2,
      1.300276,
      NULL,
      2.275311,
      NULL,
      1,
      1.138851,
      3.106967,
      3,
      NULL,
      5,
      NULL,
      9,
      2.708381,
      5,
      11,
      6,
      4.494055,
      6,
      10.906852,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0.846821,
      3.398321,
      '10-12-1986',
      1380,
      '11-26-1995',
      NULL,
      2.903437,
      0,
      0,
      1.355240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.496393,
      3.469148,
      1.322312,
      1,
      3,
      NULL,
      6,
      5,
      0,
      2,
      3,
      0.396608,
      1,
      0.615797,
      0,
      1,
      NULL,
      7,
      8.976857,
      NULL,
      0.042104,
      NULL,
      NULL,
      3.652849,
      2,
      0.958530,
      0.145807,
      NULL,
      0.725970,
      5.875770,
      ' 9- 9-1979',
      0.357587,
      ' 0- 0-1993',
      5,
      1.469907,
      0,
      0,
      0,
      NULL,
      1.694946,
      0,
      1.968888,
      1.798888,
      0.685497,
      1,
      6567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801683,
      1.393002,
      0,
      2,
      3.268834,
      0,
      0.575006,
      1,
      1.421939,
      0.285641,
      2.317544,
      2,
      1,
      NULL,
      NULL,
      10,
      NULL,
      55.019075,
      186.537698,
      NULL,
      1.444727,
      168.102895,
      0,
      0.031834,
      1.849689,
      1.945056,
      1.255358,
      1.884715,
      0.594424,
      12,
      0,
      1.943970,
      3,
      1.119977,
      3,
      0.779119,
      3,
      3,
      2.972547,
      0.760274,
      1,
      1.317246,
      0.118865,
      0.951005,
      2,
      3,
      1,
      NULL,
      18,
      7.117044,
      1,
      NULL,
      1.592183,
      0,
      NULL,
      '21400',
      '',
      0.940337,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      3,
      36.032526,
      433.287520,
      0.378111,
      2,
      32.699471,
      NULL,
      612.257239,
      3,
      15.825874,
      NULL,
      NULL,
      18.154452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      11.735669,
      NULL,
      NULL,
      5.812559,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      8.591879,
      NULL,
      NULL,
      12.355545,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      13.098013,
      NULL,
      NULL,
      1.954765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.481136,
      NULL,
      NULL,
      16.027189,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      1.192716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.217288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      19.767631,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186446,
      NULL,
      NULL,
      3.920827,
      NULL,
      2,
      1.550558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.402314,
      5.464483,
      9.545123,
      NULL,
      0.570390,
      5,
      1.446613,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.033028,
      2.347746,
      NULL,
      NULL,
      5,
      1,
      0.183343,
      3,
      2.414044,
      3.674381,
      3.207281,
      1.112122,
      0,
      0,
      NULL,
      3.390330,
      1.514494,
      3.726053,
      3,
      6,
      NULL,
      2,
      7,
      1,
      4,
      0,
      1.211766,
      1.737197,
      1.092946,
      0.078674,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.507832,
      NULL,
      NULL,
      7.280756,
      NULL,
      NULL,
      13.192322,
      NULL,
      NULL,
      14.656414,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.265688,
      0.182186,
      3.874880,
      0.653818,
      0,
      NULL,
      NULL,
      NULL,
      2.378302,
      NULL,
      NULL,
      NULL,
      0.985910,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.573831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.896142,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.046379,
      NULL,
      0.880874,
      NULL,
      0.300745,
      NULL,
      1,
      NULL,
      0.085454,
      NULL,
      1.515482,
      NULL,
      1,
      NULL,
      1.173280,
      NULL,
      1,
      NULL,
      1.721387,
      NULL,
      NULL,
      NULL,
      31.346924,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      789.901118,
      247,
      3.427921,
      1848.884431,
      40.089687,
      1.898975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756873,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4,
      3,
      3364.754051,
      1.993540,
      NULL,
      0,
      1.540666,
      0,
      1,
      0.694854,
      1,
      1,
      1.392882,
      0.340223,
      1,
      1,
      1.650464,
      0,
      NULL,
      0.879802,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.009863,
      NULL,
      3.627668,
      5,
      4.464517,
      0.705990,
      4,
      NULL,
      0,
      0.816655,
      NULL,
      NULL,
      NULL,
      NULL,
      11.936968,
      NULL,
      18.878497,
      6.563093,
      NULL,
      NULL,
      2.000095,
      NULL,
      1.931103,
      3,
      NULL,
      18.312602,
      0,
      NULL,
      1,
      2,
      NULL,
      3.124697,
      0.618093,
      NULL,
      13,
      5,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.244100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.798219,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.112901,
      NULL,
      14.761041,
      NULL,
      3.009382,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.248938,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      40,
      3.605669,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.623732,
      NULL,
      7.306986,
      NULL,
      7,
      1,
      NULL,
      2,
      NULL,
      20,
      0,
      1,
      1.120050,
      '23421',
      '11120',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


