set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      '1302',
      0,
      NULL,
      NULL,
      NULL,
      ' 0- 5-1984',
      4,
      NULL,
      5.405726,
      0.230387,
      NULL,
      ' 3-26-1998',
      66,
      2.856294,
      118,
      3,
      5.815186,
      NULL,
      NULL,
      ' 3-13-1993',
      NULL,
      0.960413,
      1.242016,
      1,
      NULL,
      NULL,
      9.948232,
      0.088605,
      0.772616,
      77,
      11,
      10.625120,
      5,
      16.145124,
      19,
      2.576133,
      23.856730,
      7,
      NULL,
      2.064279,
      NULL,
      2.090517,
      NULL,
      NULL,
      0,
      0.216105,
      1.279207,
      NULL,
      0,
      0.369542,
      NULL,
      NULL,
      2.875152,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.781087,
      3.901323,
      0.053253,
      0.504388,
      0.605402,
      NULL,
      0.865873,
      4,
      0.633696,
      1,
      1.377495,
      1,
      0.190052,
      NULL,
      NULL,
      1.685798,
      NULL,
      NULL,
      0,
      1.440221,
      1.067300,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.350546,
      0.647087,
      3.477391,
      0.810821,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.286513,
      4.364823,
      0,
      1.275306,
      2,
      2.351394,
      4.624006,
      1,
      1,
      NULL,
      NULL,
      3.606780,
      1.939081,
      6,
      1.762912,
      1.760842,
      0.597891,
      0.674584,
      0,
      NULL,
      0,
      NULL,
      6.739347,
      7.040301,
      NULL,
      2.217043,
      4,
      4.518806,
      1,
      1.713782,
      5,
      1,
      NULL,
      2.642564,
      3.271710,
      NULL,
      7.986549,
      4,
      2.493468,
      5.550504,
      NULL,
      NULL,
      NULL,
      4.782014,
      1.322553,
      1,
      0,
      0.568294,
      ' 5- 6-1996',
      581,
      ' 4-21-1977',
      221,
      3,
      NULL,
      0.715074,
      3.089646,
      1.580460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385753,
      3,
      1.802487,
      4.407668,
      1,
      2.059912,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      0.801238,
      0.973468,
      2.651683,
      2.912584,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.449172,
      0,
      1.857399,
      2.393977,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.109891,
      1.578551,
      1,
      NULL,
      0.001684,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.587478,
      3.734582,
      0,
      1.339624,
      1,
      1,
      2,
      NULL,
      1,
      1,
      1.451320,
      2,
      3,
      0.259650,
      2,
      2,
      NULL,
      1.032213,
      3.817902,
      0,
      0,
      NULL,
      1.169603,
      0.456392,
      0,
      0,
      1.859078,
      1.062652,
      1.341055,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795354,
      45.918271,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7,
      '32222',
      NULL,
      '02243',
      1,
      '',
      '',
      '',
      1.378260,
      '',
      NULL,
      '',
      2.750958,
      42.372543,
      243,
      30.338759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894162,
      0,
      3.800372,
      0,
      NULL,
      NULL,
      0.617350,
      NULL,
      NULL,
      3.270380,
      2.974669,
      1.106657,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.005850,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.391306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186132,
      5,
      1,
      0,
      NULL,
      NULL,
      0.540016,
      NULL,
      NULL,
      0,
      1.324506,
      NULL,
      NULL,
      1.151024,
      1,
      1.358787,
      NULL,
      1,
      NULL,
      1,
      1.697119,
      NULL,
      NULL,
      0.370410,
      0.325359,
      1.015894,
      0.610514,
      1.521244,
      0.307549,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.368483,
      0,
      0.930803,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.969580,
      NULL,
      12.516665,
      3,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.322066,
      3,
      9,
      4.461636,
      6.061994,
      5.535975,
      NULL,
      0,
      NULL,
      NULL,
      1.817539,
      NULL,
      NULL,
      1.061102,
      NULL,
      NULL,
      1.991395,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.161374,
      NULL,
      NULL,
      0,
      0.935578,
      1,
      4.044932,
      2.018145,
      5.762119,
      2.113105,
      1.657472,
      0,
      0.014198,
      2.532639,
      2.062048,
      0,
      19.196120,
      2,
      2,
      1,
      3,
      0,
      0,
      0.593978,
      NULL,
      1.617412,
      7,
      1.468340,
      NULL,
      NULL,
      0,
      NULL,
      0.638716,
      NULL,
      2.560268,
      NULL,
      1,
      0.273362,
      0.836480,
      3,
      3,
      2,
      0,
      1,
      3.406902,
      3.062252,
      4,
      4.542232,
      1,
      0.111362,
      NULL,
      0,
      1.819571,
      1,
      NULL,
      NULL,
      1.241978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.791925,
      NULL,
      NULL,
      0.404224,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0.020284,
      0.129429,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.722196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.985241,
      NULL,
      NULL,
      NULL,
      1.289128,
      NULL,
      NULL,
      NULL,
      2.898307,
      NULL,
      NULL,
      NULL,
      0.279656,
      NULL,
      NULL,
      NULL,
      0.424669,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.539444,
      NULL,
      NULL,
      NULL,
      1.447540,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.749084,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      57.101115,
      NULL,
      1.536448,
      2,
      NULL,
      NULL,
      0,
      2.672365,
      0,
      0.690600,
      1,
      1,
      0.524056,
      1.681415,
      0,
      NULL,
      NULL,
      1,
      1.377328,
      NULL,
      NULL,
      0.178477,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.118115,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      55.113133,
      47,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.743749,
      NULL,
      3.791706,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.400063,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.072521,
      NULL,
      1,
      0.912399,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005509,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.943701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.075091,
      NULL,
      0.932233,
      NULL,
      1.297945,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      5.195293,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.602849,
      0,
      0.376505,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1.223532,
      1,
      NULL,
      1.183618,
      1.903339,
      NULL,
      0.296935,
      1,
      NULL,
      0.845207,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0.758841,
      1,
      NULL,
      2.990171,
      1.856155,
      3.783331,
      1,
      NULL,
      1.176421,
      NULL,
      0,
      NULL,
      3.018224,
      NULL,
      NULL,
      NULL,
      1.488944,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.917960,
      NULL,
      NULL,
      NULL,
      0.698308,
      NULL,
      2.566491,
      NULL,
      1,
      NULL,
      NULL,
      1.055365,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.996602,
      NULL,
      2.914670,
      NULL,
      1.001708,
      NULL,
      1.025481,
      NULL,
      0.837096,
      NULL,
      1.258549,
      NULL,
      1,
      NULL,
      3.658939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      143.540676,
      NULL,
      NULL,
      1,
      NULL,
      0.440992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.115285,
      74.041240,
      28.235528,
      5,
      1,
      7,
      '23342',
      '12304',
      '44441',
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


