set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223859';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3211343',
      NULL,
      1,
      3,
      0,
      '1133',
      3,
      2,
      0,
      8.341507,
      NULL,
      51,
      NULL,
      4.104705,
      2,
      0,
      ' 5-11-1982',
      63,
      NULL,
      217,
      41.682939,
      2.530614,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      2,
      0,
      NULL,
      1.025877,
      442.070846,
      4,
      12.175396,
      2,
      1,
      21,
      3.839436,
      24,
      NULL,
      1,
      11,
      1,
      1,
      0.606989,
      NULL,
      NULL,
      0,
      NULL,
      1.755623,
      1,
      NULL,
      173,
      5,
      3,
      0,
      2,
      6,
      0,
      4.390129,
      NULL,
      0,
      6,
      5,
      1.594995,
      NULL,
      3,
      1.488571,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      0.203914,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660456,
      3,
      0.830042,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.769129,
      4,
      0,
      0.295105,
      1.204978,
      7,
      1,
      3.332714,
      NULL,
      2.952816,
      1.385821,
      NULL,
      0,
      9.078380,
      0,
      2,
      1,
      0,
      1,
      NULL,
      0.508821,
      4,
      2,
      1.410620,
      8,
      0.262009,
      5.675301,
      NULL,
      0.630242,
      4,
      8.591765,
      6,
      6.885220,
      3.419868,
      2.419243,
      4,
      6,
      3,
      NULL,
      NULL,
      NULL,
      8.230618,
      0,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      815,
      ' 9- 1-2002',
      998.015352,
      3,
      0.252670,
      0,
      7,
      1.624419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.270167,
      0.026041,
      1,
      1.115422,
      1.971156,
      0.594727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454293,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.082377,
      NULL,
      NULL,
      6.080815,
      0.258304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800006,
      1.842600,
      NULL,
      1,
      1.492328,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.635627,
      4.033634,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.436305,
      1.366499,
      0.771114,
      1,
      0,
      NULL,
      NULL,
      0,
      278,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.472351,
      0.168865,
      NULL,
      0,
      NULL,
      3.873302,
      3,
      NULL,
      2,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      0.764282,
      NULL,
      1,
      0.429546,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.981770,
      4,
      0.716543,
      1.165708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.412267,
      NULL,
      NULL,
      NULL,
      4.548228,
      NULL,
      0,
      '41244',
      NULL,
      '',
      0.402294,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.701928,
      42.390362,
      325.868248,
      30,
      0,
      NULL,
      41,
      32,
      11.463959,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      9.751059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      1,
      2,
      2.702232,
      2.426122,
      NULL,
      1.278129,
      5,
      NULL,
      NULL,
      1.900578,
      NULL,
      3.170204,
      0,
      5.527864,
      8.920267,
      0,
      9.290129,
      0,
      5.544039,
      0.322132,
      1,
      NULL,
      0.502771,
      NULL,
      NULL,
      NULL,
      0.417776,
      NULL,
      NULL,
      NULL,
      2,
      3.967360,
      1.376644,
      6,
      NULL,
      NULL,
      1.980982,
      NULL,
      NULL,
      3,
      NULL,
      2.827225,
      3,
      2.186529,
      3,
      NULL,
      3.921040,
      0,
      3.363127,
      1.425063,
      0,
      0,
      1,
      1,
      1.827278,
      2.906943,
      0.242057,
      14,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.989942,
      10,
      0.875019,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.607156,
      NULL,
      3.464140,
      0,
      1.929618,
      NULL,
      NULL,
      2.328470,
      NULL,
      17.023319,
      NULL,
      NULL,
      0.172707,
      3.205189,
      NULL,
      1,
      2.844683,
      1,
      3,
      0,
      1.670615,
      NULL,
      6,
      1.952878,
      1.630193,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.089021,
      0.010441,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      2.984560,
      2,
      1.824953,
      1.728258,
      1,
      0.029694,
      NULL,
      NULL,
      7.640147,
      3,
      3.380532,
      9,
      2,
      NULL,
      0.187927,
      3.055976,
      1.552566,
      3,
      1.700170,
      0.610836,
      2.003196,
      NULL,
      NULL,
      NULL,
      10.747653,
      3,
      0.295802,
      3,
      3.599659,
      0.543831,
      0,
      3.869816,
      3,
      NULL,
      0.181916,
      0,
      0.664044,
      3,
      NULL,
      2,
      0,
      2.067556,
      NULL,
      8,
      0.856491,
      2,
      9,
      0.565466,
      0,
      NULL,
      1.677758,
      1,
      3,
      NULL,
      NULL,
      3.605384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801990,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.357962,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.868667,
      1.576287,
      2.453112,
      NULL,
      NULL,
      NULL,
      1.387213,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.338729,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      7.774489,
      NULL,
      NULL,
      NULL,
      15.715076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.519793,
      NULL,
      NULL,
      0,
      1.956803,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.555056,
      0.729435,
      NULL,
      NULL,
      2.667139,
      0.951710,
      NULL,
      NULL,
      0.090471,
      NULL,
      NULL,
      NULL,
      3.150041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758434,
      191,
      NULL,
      1,
      NULL,
      NULL,
      0.412482,
      NULL,
      NULL,
      0.920021,
      18.946197,
      12.531076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.952058,
      14206.833195,
      17,
      1.378499,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.225775,
      0.726957,
      1,
      NULL,
      0.360003,
      0.233386,
      0.561675,
      2.122802,
      0,
      2.300888,
      NULL,
      1,
      NULL,
      1.905616,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.264244,
      NULL,
      1.550470,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      55,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL,
      1.603414,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.498045,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.701772,
      NULL,
      NULL,
      NULL,
      3.548681,
      NULL,
      0.952906,
      1,
      1.923444,
      2.541539,
      NULL,
      0.206521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.761398,
      NULL,
      0,
      NULL,
      1,
      1,
      1.178395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964530,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.100001,
      0,
      1.047117,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.544502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1799,
      NULL,
      97.739199,
      0.828447,
      0.849976,
      NULL,
      2,
      NULL,
      0.399918,
      NULL,
      273,
      NULL,
      NULL,
      NULL,
      1.586800,
      NULL,
      1.110953,
      1.596557,
      2,
      6.524053,
      17.810263,
      0,
      1,
      3.425895,
      2.282575,
      1.704707,
      0.296903,
      3.507972,
      1.151739,
      NULL,
      0,
      4.105057,
      NULL,
      2,
      2.391861,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0.828466,
      NULL,
      1.521436,
      0.447358,
      NULL,
      1.745793,
      0.937053,
      NULL,
      NULL,
      1.531863,
      NULL,
      0.109598,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.619214,
      1.337279,
      NULL,
      1,
      3.732584,
      NULL,
      1,
      0.140506,
      NULL,
      2,
      0.172499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654527,
      NULL,
      1.821463,
      NULL,
      3.027213,
      10,
      NULL,
      0.431085,
      NULL,
      0,
      NULL,
      59.837444,
      2,
      NULL,
      NULL,
      '01141',
      '33004',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0.983996,
      '',
      '',
      NULL);
commit;
end;
/


