set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223859';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '0323144',
      1,
      NULL,
      3,
      1,
      '1410',
      1,
      NULL,
      3.916691,
      22.147822,
      ' 1- 3-1976',
      0.317188,
      NULL,
      2.481548,
      0,
      0,
      ' 9- 4-1977',
      16.215179,
      1.776290,
      203.998424,
      2,
      NULL,
      ' 4- 8-1992',
      NULL,
      ' 3-20-1980',
      1.783620,
      1.677837,
      1.454439,
      1.708265,
      NULL,
      3.076532,
      NULL,
      1.137622,
      0,
      NULL,
      5.453361,
      13.251610,
      1,
      67,
      5.278272,
      3,
      8,
      6.509987,
      1.571978,
      NULL,
      1.884913,
      NULL,
      1,
      NULL,
      0.397843,
      0.280689,
      0,
      0,
      0.194084,
      1.839546,
      181.982954,
      14.055370,
      6,
      NULL,
      0,
      NULL,
      1.350408,
      1.763728,
      NULL,
      7,
      5.144892,
      NULL,
      1,
      3.002534,
      1.356325,
      NULL,
      2.507315,
      5.334116,
      0.394258,
      3,
      3,
      3,
      0,
      NULL,
      NULL,
      1.089529,
      NULL,
      NULL,
      9.763332,
      1,
      NULL,
      NULL,
      0.153724,
      0.441818,
      0,
      NULL,
      1,
      0,
      0.946674,
      0,
      1.150902,
      0.643128,
      1.303769,
      0,
      1.992115,
      0,
      0.078289,
      NULL,
      1.017558,
      0.045444,
      7.259353,
      1,
      3,
      0.888555,
      0.296269,
      NULL,
      NULL,
      1.565802,
      NULL,
      NULL,
      9,
      10,
      1.462820,
      4.544238,
      9,
      4,
      4.459328,
      2,
      5,
      0,
      1.982492,
      0.505872,
      2.975867,
      2,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.449447,
      1.444059,
      3.509995,
      1.243924,
      1,
      1,
      1,
      4.601008,
      NULL,
      0,
      NULL,
      6.902567,
      9,
      0,
      NULL,
      NULL,
      6.034026,
      NULL,
      0,
      10.790713,
      8.156959,
      9,
      NULL,
      4.726403,
      0.104465,
      NULL,
      600.685516,
      ' 9-21-1982',
      NULL,
      1.593436,
      1.222696,
      1.587284,
      NULL,
      1.782193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.598013,
      1.698564,
      1.171884,
      2.374982,
      1,
      1.464214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0.781082,
      5,
      NULL,
      0,
      1,
      0.929295,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.970569,
      1.885877,
      2.075501,
      0.324836,
      1,
      0.353241,
      NULL,
      19,
      1.643834,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.583982,
      2,
      1,
      1.914841,
      0.980893,
      0,
      2,
      1.899607,
      0.043725,
      2,
      NULL,
      NULL,
      3.968074,
      4.959090,
      NULL,
      NULL,
      77,
      NULL,
      182.627243,
      143.130246,
      171,
      0.447051,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.228644,
      NULL,
      1.429088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      7.780613,
      2,
      1,
      2.517597,
      '33303',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.497727,
      NULL,
      '',
      '',
      3,
      7,
      NULL,
      18,
      0.325712,
      NULL,
      17,
      264,
      5.406461,
      2.617857,
      NULL,
      1.284091,
      0.221594,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.644004,
      NULL,
      0,
      3,
      0.967087,
      0.231986,
      0.282472,
      0.112093,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.498940,
      NULL,
      NULL,
      2.609604,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.566516,
      4.166136,
      4.796357,
      2.551148,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461038,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      15.631089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.307422,
      0.001064,
      NULL,
      0,
      1,
      0,
      0.137465,
      0.495170,
      0.229677,
      NULL,
      1,
      NULL,
      0.293540,
      1,
      0.539370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.555436,
      3,
      11.417917,
      5,
      6,
      2.974066,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.164100,
      1.977790,
      0.714609,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.002536,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.175509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.783473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.135541,
      0.197634,
      0,
      1.798696,
      NULL,
      NULL,
      0,
      0.949118,
      NULL,
      5,
      7,
      6.072756,
      9,
      0,
      1.305788,
      3.889070,
      3,
      0.778023,
      3.734137,
      NULL,
      3.588544,
      NULL,
      NULL,
      NULL,
      4,
      9,
      6,
      0,
      NULL,
      1,
      NULL,
      1.013572,
      NULL,
      2,
      0,
      2.193525,
      1.150901,
      3,
      NULL,
      9.402720,
      4.253836,
      0,
      4,
      3,
      3,
      NULL,
      NULL,
      3.897126,
      0.322784,
      1.534829,
      1,
      NULL,
      0.101715,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891438,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.385605,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.519330,
      NULL,
      NULL,
      1.255648,
      NULL,
      NULL,
      3.429461,
      NULL,
      NULL,
      0.170172,
      1.763507,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1.978634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.781306,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127378,
      NULL,
      NULL,
      NULL,
      2.753427,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.143505,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.538798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221753,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.858149,
      NULL,
      NULL,
      NULL,
      1,
      96.483335,
      88,
      0,
      NULL,
      NULL,
      1.882270,
      NULL,
      NULL,
      3,
      546.235238,
      1170.519302,
      1.009445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941887,
      NULL,
      NULL,
      NULL,
      33,
      0,
      1.942647,
      1.847736,
      0.136546,
      1.398362,
      3,
      1.505318,
      0.001320,
      1,
      1,
      1.767933,
      1.654869,
      NULL,
      1,
      0,
      0.122562,
      NULL,
      1.061914,
      NULL,
      1.992565,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      18.775449,
      0.445925,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.440588,
      NULL,
      1.335969,
      NULL,
      NULL,
      NULL,
      1.678156,
      NULL,
      3.589975,
      NULL,
      1.817059,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.954900,
      NULL,
      NULL,
      NULL,
      NULL,
      3.301588,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003129,
      NULL,
      1,
      NULL,
      1.834191,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.962965,
      NULL,
      1.510623,
      NULL,
      1.623805,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.143838,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293438,
      1.632249,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.538250,
      0.833803,
      2.155189,
      NULL,
      NULL,
      NULL,
      0.844434,
      NULL,
      66.203420,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.424122,
      1.037194,
      5.357174,
      6,
      1.057100,
      NULL,
      NULL,
      NULL,
      1.330680,
      1,
      2.815017,
      NULL,
      NULL,
      1,
      0.843618,
      0.530839,
      NULL,
      NULL,
      1,
      NULL,
      0.244809,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.768385,
      1.388698,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.656224,
      NULL,
      1.627947,
      0,
      NULL,
      0.054088,
      1,
      NULL,
      1.320959,
      0.696997,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645674,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485842,
      NULL,
      1,
      NULL,
      1.115420,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0,
      3,
      4.458811,
      18.716716,
      NULL,
      1.022225,
      NULL,
      '43314',
      '31040',
      '30144',
      NULL,
      '',
      '',
      '',
      0.917520,
      NULL,
      '',
      '');
commit;
end;
/


