set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678994';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.517358,
      2.309266,
      1.280618,
      NULL,
      2.397468,
      1,
      2.987249,
      0,
      '430',
      '14333430',
      28,
      63,
      '1122244',
      1.218652,
      1.287838,
      0,
      2,
      '4014',
      6,
      1.655440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643787,
      2,
      '11-23-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-25-1989',
      ' 9-27-1983',
      ' 4- 7-1992',
      1,
      0.448034,
      0,
      0,
      1,
      1,
      1,
      1.098272,
      NULL,
      10,
      3.875902,
      17.657401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.528444,
      NULL,
      NULL,
      1.416621,
      1,
      0.737204,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      3,
      1,
      3,
      1.233915,
      5.928426,
      1.975783,
      1,
      0.664350,
      1.043244,
      5.638911,
      9,
      0.361938,
      1,
      1.301115,
      0.784530,
      1.268272,
      7.642802,
      0.604795,
      NULL,
      0.758164,
      1.035110,
      1,
      NULL,
      NULL,
      0.782619,
      NULL,
      NULL,
      1,
      NULL,
      9,
      3,
      0.428084,
      0,
      3,
      0.221069,
      NULL,
      2.423174,
      1.157829,
      0,
      1,
      NULL,
      0,
      2.061479,
      0,
      0.522583,
      0.997130,
      1,
      0.140987,
      0,
      10,
      0.606789,
      0.815459,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      6,
      1.309916,
      4.371954,
      1,
      4.844036,
      0,
      NULL,
      NULL,
      NULL,
      3.642507,
      NULL,
      0.076076,
      1,
      0.396724,
      NULL,
      1.218898,
      1,
      0,
      1.118956,
      NULL,
      8.415460,
      0,
      2,
      4,
      1.233298,
      3.370591,
      6,
      7.112452,
      2,
      NULL,
      NULL,
      4,
      6.265048,
      NULL,
      NULL,
      7.591432,
      7,
      2.722943,
      5,
      NULL,
      2,
      1,
      2.042303,
      0,
      NULL,
      2.902174,
      '10-15-2002',
      9.459446,
      2.961486,
      0.796088,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.417480,
      3,
      1,
      NULL,
      6.613932,
      2,
      1.279330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.455856,
      7.117271,
      1.071729,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.332630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.155524,
      0,
      1,
      0,
      0,
      3.932208,
      NULL,
      2.935770,
      1,
      NULL,
      NULL,
      NULL,
      0.544195,
      0,
      0.419755,
      1,
      NULL,
      0,
      0,
      1,
      5.701798,
      5,
      3,
      NULL,
      NULL,
      5,
      NULL,
      0.946074,
      0.968295,
      0,
      1.168010,
      1,
      NULL,
      0,
      0,
      0.835067,
      0.608493,
      0.735410,
      1,
      0.655797,
      0.302546,
      2.790443,
      0.594548,
      0.995152,
      3,
      3,
      4.824393,
      5,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.774490,
      3.587029,
      1,
      NULL,
      1.617565,
      33.976111,
      NULL,
      63.156180,
      NULL,
      5.834891,
      1.267880,
      1.413117,
      '31232',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '2310',
      '',
      NULL,
      3,
      NULL,
      19.826179,
      24.632942,
      1.528230,
      6.663670,
      4,
      0,
      NULL,
      3,
      1,
      0.490303,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.137276,
      0.319238,
      1,
      NULL,
      NULL,
      NULL,
      2.595348,
      NULL,
      0.553870,
      1.714606,
      0,
      1.459888,
      0.986211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.336948,
      NULL,
      NULL,
      6.189496,
      3.533572,
      0.099259,
      1,
      1.387283,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.720358,
      NULL,
      1.204246,
      1,
      1.451910,
      0,
      0,
      NULL,
      1,
      NULL,
      0.881181,
      0,
      1.277046,
      1,
      1,
      0,
      3.128353,
      1,
      1.976496,
      1,
      0.693160,
      1.037085,
      NULL,
      NULL,
      0.430893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793004,
      NULL,
      NULL,
      4.153387,
      0.508450,
      1.602824,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.092661,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.537309,
      NULL,
      1.997427,
      1.397294,
      NULL,
      NULL,
      2,
      0.974267,
      3,
      NULL,
      1.162423,
      3,
      1.679854,
      NULL,
      NULL,
      4,
      6.508917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.402868,
      NULL,
      NULL,
      1.131582,
      NULL,
      NULL,
      1.234857,
      NULL,
      NULL,
      3,
      2,
      1.830717,
      NULL,
      NULL,
      NULL,
      2.490421,
      5,
      2,
      4.180650,
      3,
      1,
      5.273678,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755978,
      2,
      2,
      3.017664,
      0.845671,
      0,
      4.784047,
      1,
      3.318412,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.260817,
      2,
      3,
      2.332100,
      0.063655,
      0.717420,
      7,
      NULL,
      5.711711,
      NULL,
      1.260866,
      1,
      3,
      1.780075,
      2.470260,
      2,
      2,
      2,
      NULL,
      NULL,
      1.542037,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.377571,
      NULL,
      NULL,
      0.245683,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.985909,
      3.745794,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.684620,
      NULL,
      NULL,
      2.926446,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1.063880,
      NULL,
      NULL,
      0,
      1.516509,
      2.536659,
      1.828448,
      3.597401,
      NULL,
      5.475424,
      NULL,
      1,
      NULL,
      13,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.184839,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.463215,
      3.570822,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.060931,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.108582,
      0,
      NULL,
      NULL,
      0.057827,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      3,
      NULL,
      1,
      3.968528,
      2.919813,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.317608,
      3.254203,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.605085,
      NULL,
      2,
      NULL,
      1,
      1.344239,
      15.368414,
      NULL,
      6,
      4,
      2,
      NULL,
      1.270402,
      NULL,
      5.936016,
      0.774785,
      0.274230,
      8,
      16,
      0,
      0.116692,
      2.312589,
      0.233199,
      NULL,
      NULL,
      1.092488,
      NULL,
      NULL,
      2.853068,
      0.276814,
      0.417624,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      705.225829,
      10,
      NULL,
      1,
      1,
      1,
      1,
      0.894651,
      1,
      0,
      0.174990,
      0,
      0.068388,
      1.343807,
      0,
      NULL,
      1.665444,
      0,
      1.391316,
      0.651435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.456106,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952506,
      1.890912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.882667,
      NULL,
      0.950513,
      NULL,
      0,
      NULL,
      0.881947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688266,
      1.539251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571961,
      1.257798,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507940,
      NULL,
      0.703421,
      0.977510,
      0.853785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.053723,
      NULL,
      4.517744,
      3,
      3.994545,
      3.856698,
      0,
      7.618318,
      0,
      0,
      0,
      1.941367,
      0,
      1,
      1,
      0,
      3.610155,
      NULL,
      1,
      1.212210,
      0,
      0,
      0,
      1,
      1.275168,
      NULL,
      0,
      1.040498,
      NULL,
      NULL,
      3,
      0.516630,
      NULL,
      0,
      0,
      1.105481,
      0.102139,
      2,
      0.216361,
      0.930734,
      3,
      NULL,
      1,
      2.206111,
      2.804849,
      3.957386,
      1.853247,
      0,
      NULL,
      0,
      3.203841,
      NULL,
      3.964741,
      NULL,
      2,
      1.181104,
      0,
      0,
      0,
      0,
      1,
      0,
      3.803222,
      NULL,
      NULL,
      NULL,
      3,
      0.565454,
      NULL,
      NULL,
      1.301122,
      0,
      1,
      33,
      0.497397,
      0,
      1.538794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.008278,
      0.378736,
      NULL,
      1,
      NULL,
      7.577392,
      0,
      NULL,
      NULL,
      1.966349,
      23,
      110,
      4,
      NULL,
      0.427119,
      '22020',
      '',
      '',
      1.489956,
      '',
      NULL,
      '',
      0,
      '2314',
      '',
      '');
commit;
end;
/


