set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204518';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '2442111',
      NULL,
      1,
      3,
      NULL,
      '1204',
      0.659628,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      5,
      0,
      1,
      ' 9-16-2003',
      54,
      0.656703,
      153.248419,
      8.172253,
      3.556266,
      ' 5-14-1980',
      ' 8-15-1983',
      ' 4-22-1978',
      NULL,
      3,
      3.254361,
      2,
      NULL,
      1.638680,
      1.015188,
      1.099922,
      0.948932,
      140,
      5.857328,
      14,
      NULL,
      NULL,
      6,
      4,
      25.274118,
      1,
      NULL,
      7.510084,
      3.275616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      NULL,
      NULL,
      NULL,
      2.923868,
      NULL,
      1,
      2,
      NULL,
      2,
      3,
      3.916658,
      3.452202,
      0.529255,
      5.530256,
      0.331245,
      3.246424,
      0.958161,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.737200,
      1.281006,
      NULL,
      NULL,
      0,
      3.107549,
      2.109609,
      NULL,
      2.285282,
      2.747093,
      NULL,
      2,
      3,
      1,
      1.211912,
      0,
      NULL,
      0,
      0,
      0.335700,
      0,
      1,
      1,
      3,
      1.020566,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.460368,
      3.820757,
      NULL,
      0,
      6,
      NULL,
      2,
      NULL,
      3.879278,
      9,
      0,
      1,
      7,
      1.511166,
      NULL,
      1,
      NULL,
      1.169173,
      NULL,
      1.095867,
      1,
      3,
      3,
      3,
      0.069349,
      8.721726,
      1.869382,
      0,
      1.599988,
      0.710285,
      NULL,
      1,
      NULL,
      3,
      5.435556,
      8,
      1.412480,
      5.423635,
      5,
      0.096702,
      2,
      4,
      7,
      5,
      2,
      7,
      0.917690,
      ' 8- 5-2003',
      1167.383978,
      ' 7- 8-2000',
      1949,
      0,
      1.336303,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.055985,
      1.850258,
      1,
      1,
      5,
      4,
      0.193117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.347554,
      0.111485,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.699930,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6.303661,
      NULL,
      4.740284,
      NULL,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.745545,
      0.210444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599887,
      NULL,
      NULL,
      1.482394,
      0.488047,
      0,
      0,
      0,
      NULL,
      NULL,
      0.847442,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.495812,
      0,
      0.081668,
      0,
      1,
      0.859049,
      0.375653,
      0.463530,
      0.854339,
      1.530351,
      NULL,
      2,
      2,
      NULL,
      1.149987,
      0.250792,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524646,
      NULL,
      0,
      0,
      1,
      5.512764,
      1.539652,
      1,
      NULL,
      3,
      1.441061,
      6,
      1.931583,
      2.197200,
      2.881458,
      6,
      2.030271,
      2.250634,
      3,
      14,
      2.791670,
      1.366777,
      NULL,
      53,
      NULL,
      NULL,
      3.463845,
      3.732921,
      0,
      '42320',
      '',
      '',
      1.935992,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      14,
      410,
      4,
      NULL,
      26,
      NULL,
      73.182271,
      3.154286,
      1,
      0,
      0.451089,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      0.805031,
      NULL,
      0.984414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.711003,
      1,
      1.141061,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      8.208755,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.124365,
      2,
      0,
      3.166813,
      1,
      3,
      1,
      1,
      2,
      3,
      1.293202,
      0.971742,
      3,
      2,
      1,
      0,
      NULL,
      3.347266,
      2.293402,
      2.150337,
      NULL,
      0.741333,
      2.989198,
      0,
      2,
      1.796990,
      1,
      2,
      1.480499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565477,
      NULL,
      NULL,
      8,
      0.500447,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.746382,
      2.900155,
      1.373116,
      1.648423,
      1,
      NULL,
      3,
      2.790286,
      1.490106,
      2,
      2.553603,
      NULL,
      NULL,
      NULL,
      1,
      2.395387,
      NULL,
      1,
      3,
      2.065168,
      2,
      1,
      3.605282,
      3.093435,
      4.451895,
      5,
      1.917237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      3.503255,
      4.097751,
      NULL,
      5,
      NULL,
      NULL,
      6,
      1,
      0,
      2,
      1.171311,
      1.548117,
      2,
      NULL,
      1,
      1,
      0.240456,
      0.166015,
      NULL,
      6.307587,
      7.771637,
      1,
      0,
      NULL,
      NULL,
      0.963836,
      3.511637,
      3.257286,
      NULL,
      NULL,
      1,
      0.253191,
      3,
      0.491614,
      NULL,
      6,
      4,
      NULL,
      2,
      3,
      1,
      6.025209,
      1.330972,
      1,
      NULL,
      0.937126,
      NULL,
      2.078583,
      NULL,
      NULL,
      0.769282,
      NULL,
      NULL,
      3.681686,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.990976,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.410855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341661,
      NULL,
      NULL,
      1.303741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.935553,
      2,
      NULL,
      2,
      NULL,
      2.935836,
      8,
      4.967751,
      1,
      6.883812,
      2,
      2.155872,
      3.125192,
      2.973589,
      0,
      2,
      1.371159,
      0.428138,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.724056,
      3,
      0.969723,
      NULL,
      3.208932,
      NULL,
      0,
      2,
      NULL,
      2.526019,
      1.601503,
      0.099613,
      2,
      1,
      2.622673,
      0,
      1,
      1.677340,
      0.709659,
      NULL,
      NULL,
      0.538284,
      0,
      NULL,
      NULL,
      1,
      3.587948,
      0,
      3.910651,
      NULL,
      2.969603,
      1,
      NULL,
      2.433134,
      0.875740,
      3.459177,
      2,
      1.034293,
      0.826372,
      2,
      0.199664,
      3,
      0,
      2,
      1.493398,
      1,
      0.339002,
      4,
      NULL,
      11.963135,
      11,
      3,
      2,
      NULL,
      2,
      5,
      9,
      1,
      80,
      NULL,
      NULL,
      33,
      NULL,
      1,
      NULL,
      NULL,
      0.160509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.139150,
      352,
      33,
      1.487362,
      NULL,
      1,
      1.757581,
      0,
      1.120708,
      1,
      0.695026,
      1.108797,
      1,
      0,
      1,
      1.567690,
      0,
      0,
      1,
      1.003777,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441526,
      0.611100,
      1.010917,
      3,
      1,
      0.988804,
      NULL,
      1,
      2.157436,
      0.121579,
      2,
      3,
      0,
      1.380439,
      1.016756,
      1,
      NULL,
      3,
      0,
      1.260324,
      3,
      0.838258,
      2.521162,
      NULL,
      1.079996,
      0.596304,
      0.715763,
      NULL,
      1,
      2.704670,
      0,
      1,
      0,
      1.423554,
      0.550657,
      1.922614,
      0,
      0.537633,
      2.786082,
      1.631801,
      3,
      1,
      1.924445,
      0.753909,
      2,
      3.140830,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555172,
      3.865006,
      0.343524,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      2,
      1.655772,
      NULL,
      NULL,
      2,
      0.348767,
      0,
      3.552230,
      2.364041,
      NULL,
      2.517685,
      NULL,
      1,
      0.988181,
      0,
      1.038200,
      2.285220,
      2,
      8.239056,
      0.201552,
      4,
      0,
      1.995347,
      1.898295,
      0,
      NULL,
      1.152416,
      6.767922,
      10.320120,
      9,
      0.427455,
      0,
      3.757006,
      18,
      42.265731,
      NULL,
      NULL,
      2,
      '32303',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


