set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912406';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '3310242',
      NULL,
      1,
      3,
      0,
      '3413',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.859948,
      NULL,
      NULL,
      3.766977,
      0,
      NULL,
      10.086381,
      5.299312,
      124.267909,
      120.111327,
      0.680040,
      '11-16-1991',
      '10-24-1989',
      ' 2-19-1994',
      NULL,
      0.888202,
      3,
      0.103539,
      0,
      0.726618,
      NULL,
      1,
      1,
      10,
      9.130998,
      NULL,
      2.919210,
      NULL,
      9,
      6,
      NULL,
      3,
      7.770596,
      NULL,
      0.793689,
      0,
      NULL,
      NULL,
      0,
      0.739567,
      1,
      NULL,
      1.805289,
      0.263634,
      0.319211,
      0,
      NULL,
      0.841455,
      2,
      6.732873,
      1,
      NULL,
      NULL,
      1,
      0.825359,
      NULL,
      0,
      NULL,
      NULL,
      0.691477,
      NULL,
      8.495024,
      0.629465,
      4,
      5.643384,
      0.104466,
      1,
      NULL,
      NULL,
      1.387957,
      NULL,
      NULL,
      NULL,
      NULL,
      5.509036,
      3.664371,
      0,
      1.967133,
      3.980701,
      1.301509,
      2.470205,
      1,
      3,
      3.319959,
      1.150549,
      2.308358,
      1,
      3.134148,
      1,
      1.281707,
      0,
      1,
      4,
      NULL,
      6,
      2,
      NULL,
      0,
      0.737978,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.863210,
      1.654152,
      4,
      1.967320,
      5,
      1,
      1,
      1.241541,
      0,
      0,
      0.790787,
      0.403204,
      0.778183,
      1.685526,
      1,
      NULL,
      NULL,
      0.586773,
      0,
      NULL,
      1.094401,
      9.951626,
      1.926781,
      0.930164,
      NULL,
      1,
      3,
      5.494525,
      NULL,
      NULL,
      3,
      3,
      5.810122,
      NULL,
      0,
      0.936080,
      5.703272,
      NULL,
      10,
      7,
      0.199623,
      7.383355,
      9,
      NULL,
      0,
      1,
      7.845854,
      3.244158,
      ' 1-21-1984',
      81,
      ' 5-28-2003',
      8,
      2,
      3.128451,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.213753,
      0.939003,
      1.517089,
      1.892802,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.497445,
      NULL,
      NULL,
      NULL,
      NULL,
      5.145948,
      NULL,
      NULL,
      NULL,
      3,
      1557.889065,
      2.153883,
      0,
      1.085986,
      3,
      2,
      NULL,
      7,
      8,
      NULL,
      0.608095,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.932021,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.608827,
      NULL,
      0,
      2,
      0.980391,
      0.346179,
      1.692068,
      188,
      1.293836,
      1.532830,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      3,
      0,
      2,
      0,
      3.170460,
      1,
      1.703565,
      NULL,
      NULL,
      2,
      3.283447,
      1.385555,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.174572,
      1.689542,
      0,
      1,
      NULL,
      0,
      0.252861,
      0.060000,
      NULL,
      2.403047,
      1.254094,
      8,
      0.516799,
      NULL,
      9.796930,
      6,
      NULL,
      1.369955,
      0.131532,
      1,
      1.412596,
      NULL,
      1.464755,
      57,
      NULL,
      1,
      NULL,
      11,
      49,
      43.422727,
      2.928562,
      NULL,
      5,
      '31232',
      '42144',
      '',
      0.041966,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1.934289,
      20,
      23,
      10.511943,
      0.001852,
      20,
      3,
      0,
      5,
      0,
      1.217765,
      1.707412,
      1.048309,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.036926,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.093344,
      NULL,
      0,
      NULL,
      1.715984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.973257,
      3,
      0.794351,
      0,
      0.775235,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.610654,
      NULL,
      0.138141,
      1.190150,
      0.733471,
      1.838321,
      1.237585,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      0.344557,
      1.265464,
      NULL,
      NULL,
      NULL,
      3,
      0.050320,
      1,
      NULL,
      NULL,
      NULL,
      4,
      5,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.461753,
      NULL,
      1,
      10,
      0.761860,
      1,
      NULL,
      NULL,
      2.584498,
      1.143193,
      1.328696,
      0.743883,
      NULL,
      NULL,
      2.818678,
      6,
      0.528543,
      0.366631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512037,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.485256,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.255565,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.611718,
      NULL,
      1.997177,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      7,
      0.717590,
      0,
      NULL,
      NULL,
      3.493265,
      3,
      0.893428,
      3,
      2.361692,
      0,
      0.264848,
      0,
      1.757321,
      8,
      1,
      8,
      2,
      2,
      1.357814,
      NULL,
      3.781080,
      NULL,
      2,
      2.225896,
      0.729944,
      0,
      0.129896,
      0,
      0.322594,
      4,
      2,
      5.317413,
      2.011008,
      2,
      3,
      2.049972,
      6.387387,
      NULL,
      1,
      0,
      0.183331,
      1.088535,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.081521,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.208317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.892615,
      1.674742,
      0.661864,
      2,
      NULL,
      4.228725,
      NULL,
      1,
      NULL,
      5.517121,
      NULL,
      NULL,
      NULL,
      2.215704,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.395881,
      NULL,
      0,
      NULL,
      1.018729,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236837,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.308126,
      NULL,
      NULL,
      NULL,
      2.234522,
      NULL,
      0.502427,
      NULL,
      1.348149,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.698543,
      NULL,
      0.152110,
      NULL,
      1.789198,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.393459,
      NULL,
      9.744371,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133171,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.515723,
      0,
      17.488612,
      1.031328,
      0.813598,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.909582,
      0.271853,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      51.874696,
      NULL,
      NULL,
      NULL,
      0.148634,
      1.702480,
      1,
      NULL,
      0.791475,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1.475849,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046123,
      2,
      NULL,
      0.119903,
      1,
      NULL,
      1,
      1.721390,
      6,
      3.123949,
      NULL,
      2,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.486391,
      0,
      0,
      1,
      0.423095,
      0.533857,
      NULL,
      1.893768,
      0,
      0.238907,
      0.105820,
      1,
      1.658025,
      NULL,
      1,
      1,
      0.496313,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.539170,
      NULL,
      0,
      1.775738,
      3,
      0.123247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.451666,
      1,
      0.074423,
      NULL,
      NULL,
      NULL,
      NULL,
      3.829632,
      0.580866,
      NULL,
      NULL,
      19,
      115,
      4,
      NULL,
      7.787580,
      '23444',
      NULL,
      '42043',
      NULL,
      '',
      NULL,
      '',
      1.775445,
      '',
      '',
      '');
commit;
end;
/


