set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5309016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      3,
      1.577454,
      0,
      3,
      NULL,
      NULL,
      0.154346,
      NULL,
      NULL,
      ' 9-29-1995',
      NULL,
      NULL,
      NULL,
      0,
      1.948391,
      ' 3-13-1978',
      NULL,
      2.894869,
      136.768845,
      42.790169,
      1.717882,
      ' 5-24-1994',
      ' 8-17-2003',
      ' 7-14-1996',
      1,
      1.246903,
      2,
      NULL,
      NULL,
      0,
      4,
      1.445938,
      0,
      422,
      1,
      5,
      2,
      4.219356,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      4,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.552679,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      3.626610,
      2.003205,
      1,
      NULL,
      2.870928,
      1,
      0,
      8.510174,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      5.672520,
      2.596373,
      3,
      2,
      3.840151,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0.951409,
      NULL,
      0.179265,
      0,
      2.365709,
      3.030152,
      0,
      NULL,
      2.480532,
      3.566192,
      1.300918,
      0.361693,
      0.268651,
      3,
      1.622771,
      3.776926,
      6,
      1.373385,
      2,
      3,
      3,
      3,
      NULL,
      0.090433,
      NULL,
      NULL,
      9.756754,
      5.499967,
      2.729442,
      2,
      6,
      3.436274,
      4.820809,
      6,
      6,
      0,
      0,
      1.851183,
      1.905395,
      8,
      1.364522,
      1.589338,
      NULL,
      1,
      2,
      NULL,
      1.339812,
      1,
      0,
      6.581680,
      1,
      1.311085,
      1,
      NULL,
      NULL,
      0,
      3.213772,
      0,
      1.331736,
      NULL,
      9.831210,
      9,
      10.185586,
      0.779049,
      5.685817,
      5,
      NULL,
      5,
      4.513617,
      NULL,
      0.453625,
      1,
      NULL,
      3.241268,
      ' 1-29-1998',
      1125.023050,
      '11-16-1998',
      580,
      2.624979,
      0,
      0.728089,
      7.313708,
      6.845528,
      NULL,
      24.769928,
      0,
      NULL,
      0.110868,
      8,
      7.446562,
      NULL,
      10.213211,
      1.095154,
      1.268964,
      2,
      0.383669,
      1.977481,
      8.852716,
      3,
      ' 5- 0-1995',
      23,
      ' 9-24-1984',
      16,
      NULL,
      NULL,
      0.896895,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.978742,
      1,
      1.766335,
      0,
      NULL,
      1.069218,
      0,
      NULL,
      1,
      2.868824,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289742,
      1,
      1.633834,
      1.341548,
      1,
      0,
      2.946287,
      83,
      0.280742,
      0.593570,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.294017,
      NULL,
      3,
      NULL,
      3.416048,
      1.321655,
      NULL,
      0.364791,
      NULL,
      0.693619,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      5,
      1.332493,
      NULL,
      0.040418,
      1.289932,
      1.702694,
      1.800611,
      0,
      1.823251,
      NULL,
      0,
      0,
      NULL,
      5,
      7,
      4.824350,
      NULL,
      8.555531,
      2,
      NULL,
      2,
      2.168592,
      0,
      2,
      3.929344,
      12,
      1.340370,
      2.918778,
      NULL,
      32,
      2.799348,
      52,
      3.270278,
      1.033660,
      1.818749,
      '21021',
      '',
      NULL,
      1.356326,
      '',
      '',
      NULL,
      1.436251,
      '',
      '',
      '',
      2,
      NULL,
      399.143370,
      4,
      0.689276,
      13.492854,
      NULL,
      24.737441,
      4,
      1.251374,
      NULL,
      1.478742,
      NULL,
      NULL,
      NULL,
      2.556045,
      1.840871,
      0.141644,
      0.661963,
      1.304073,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      1.713679,
      NULL,
      3.888840,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.111997,
      6,
      1.291228,
      1,
      2,
      2,
      1.134144,
      0.544384,
      0,
      NULL,
      NULL,
      NULL,
      0.082439,
      0.598570,
      2.500773,
      1.811314,
      NULL,
      NULL,
      0.978307,
      NULL,
      NULL,
      0.452972,
      1.233706,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.589439,
      1,
      0.881090,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.142878,
      NULL,
      NULL,
      1.771229,
      NULL,
      NULL,
      5,
      9.254311,
      5,
      1,
      2,
      2,
      0.636798,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.275214,
      2,
      2.395455,
      1,
      1,
      0,
      NULL,
      NULL,
      9.434962,
      4.622019,
      NULL,
      2,
      NULL,
      0,
      1.528306,
      3.781010,
      0,
      NULL,
      3,
      NULL,
      0.469519,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590584,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      5,
      2,
      0,
      7,
      2,
      0.606747,
      2,
      5,
      4.713630,
      3,
      2,
      NULL,
      2,
      NULL,
      3,
      1.528353,
      NULL,
      NULL,
      4.775688,
      NULL,
      1.697251,
      2,
      NULL,
      0.601684,
      2.252926,
      3.241147,
      1,
      2,
      0.733198,
      2.762286,
      0.139478,
      1.938361,
      0,
      NULL,
      5.528501,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      8,
      1.046261,
      3.375683,
      NULL,
      2.689377,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      NULL,
      41.597064,
      1.715310,
      NULL,
      0,
      3,
      NULL,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      2.286041,
      2,
      NULL,
      0.647747,
      1,
      NULL,
      2.350255,
      1,
      NULL,
      0,
      1.212086,
      NULL,
      3.693228,
      2,
      NULL,
      3,
      3.684611,
      NULL,
      2.953792,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.182688,
      1.339295,
      0.349142,
      1.151759,
      0,
      0.334696,
      0.441487,
      NULL,
      NULL,
      4.188328,
      NULL,
      NULL,
      NULL,
      0.168093,
      NULL,
      NULL,
      NULL,
      2.794264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166513,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.256683,
      NULL,
      NULL,
      NULL,
      1.200267,
      NULL,
      NULL,
      NULL,
      0.662858,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.294922,
      NULL,
      NULL,
      NULL,
      1.746409,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942111,
      NULL,
      NULL,
      NULL,
      1.608205,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.704878,
      NULL,
      NULL,
      NULL,
      3,
      85.246026,
      61.623783,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.754477,
      NULL,
      0.536298,
      1.413832,
      1.259469,
      0.288420,
      82,
      4,
      2,
      693,
      1,
      156,
      NULL,
      NULL,
      0,
      0.803570,
      1,
      NULL,
      1,
      0.559854,
      NULL,
      1.803211,
      NULL,
      1,
      1.256304,
      0,
      1.451975,
      NULL,
      0.118238,
      0.445337,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123499,
      1,
      1.886513,
      1,
      2.680406,
      NULL,
      4.215143,
      2,
      3.937384,
      2.569605,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      3.527016,
      NULL,
      0.830483,
      1,
      NULL,
      1.323234,
      1.321763,
      NULL,
      1.902202,
      NULL,
      0.951848,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1.344463,
      1,
      1,
      0,
      2.287151,
      1,
      1,
      0.603864,
      0,
      1.952059,
      3.464587,
      0,
      2,
      1,
      0,
      2,
      NULL,
      0.873419,
      NULL,
      2.492234,
      NULL,
      2.853452,
      NULL,
      1,
      NULL,
      1.536962,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.213823,
      NULL,
      1.565404,
      NULL,
      0.111561,
      NULL,
      0.503049,
      NULL,
      1.216978,
      25.259038,
      1,
      9.372948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236807,
      NULL,
      1.285699,
      1,
      0.189273,
      0,
      NULL,
      12,
      3,
      2.953643,
      2.460768,
      0,
      8.271525,
      NULL,
      NULL,
      0,
      NULL,
      '12403',
      '23100',
      '43203',
      0,
      '',
      '',
      '',
      0.095045,
      '',
      '',
      '');
commit;
end;
/


