set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5309016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      '42',
      NULL,
      NULL,
      '4204110',
      3.973049,
      1,
      NULL,
      3,
      '2102',
      2,
      0.354658,
      NULL,
      NULL,
      ' 9-25-1986',
      66,
      NULL,
      NULL,
      2.365734,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.299709,
      NULL,
      NULL,
      '11- 6-2000',
      NULL,
      3.243116,
      3,
      0.293252,
      NULL,
      0,
      1,
      1,
      1.664056,
      101.927922,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.924340,
      1.206852,
      1,
      0,
      0.705006,
      NULL,
      5,
      3,
      3.853373,
      1.068137,
      0,
      NULL,
      1,
      1.387903,
      9,
      0.561303,
      2.659743,
      1.862404,
      0,
      0.925863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.370716,
      0,
      1.409840,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322797,
      0,
      1.573205,
      4,
      0,
      0,
      0,
      0,
      0.950415,
      NULL,
      0,
      1,
      0,
      0.137590,
      1,
      1.492566,
      1,
      3,
      NULL,
      NULL,
      1,
      1.628478,
      NULL,
      1.027796,
      0.514838,
      0.011938,
      0.226511,
      0,
      5,
      1.210674,
      1,
      NULL,
      5,
      1.878711,
      4.386859,
      7,
      NULL,
      0.520248,
      0.339116,
      4,
      1.480925,
      7.020591,
      2,
      NULL,
      5,
      NULL,
      3,
      ' 5-29-1985',
      NULL,
      ' 1-13-1998',
      NULL,
      0,
      NULL,
      0,
      2.058762,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.903212,
      NULL,
      0,
      0,
      2.893368,
      NULL,
      1,
      NULL,
      0.775331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907090,
      NULL,
      2.693448,
      1.044066,
      0.764356,
      0.300844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.787398,
      0.777908,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.371310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651334,
      0,
      NULL,
      1.907611,
      0,
      1.914439,
      1.991547,
      0.309614,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      286.209566,
      3.145444,
      0,
      3.572134,
      3,
      3,
      1,
      1,
      3,
      1.145453,
      2,
      0,
      3.137509,
      2,
      3,
      1.685134,
      1,
      3,
      NULL,
      0.762617,
      NULL,
      0,
      NULL,
      0.281396,
      NULL,
      0.453660,
      NULL,
      1.523107,
      1.430159,
      2,
      1,
      NULL,
      NULL,
      7.197464,
      4,
      4.871575,
      1,
      5,
      7.488290,
      1.113322,
      2,
      5.445322,
      2.601551,
      2.907347,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      '33341',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      7,
      376.463498,
      29.018566,
      0,
      43.399231,
      NULL,
      27.529601,
      2,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1.298342,
      1.942309,
      NULL,
      1,
      0,
      0.002816,
      0.281914,
      1,
      NULL,
      NULL,
      1,
      1.029792,
      2,
      0.517579,
      NULL,
      NULL,
      0.145121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285289,
      NULL,
      NULL,
      10.699728,
      7.120638,
      7.926687,
      1.165064,
      1,
      NULL,
      0.301416,
      1.266622,
      0,
      NULL,
      NULL,
      NULL,
      3.414600,
      1,
      1.166212,
      0.794874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727977,
      3,
      1,
      NULL,
      NULL,
      1.863201,
      0.642293,
      0.211208,
      3.905333,
      NULL,
      1.761090,
      3,
      0,
      1.627674,
      1,
      NULL,
      NULL,
      1.760828,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.774670,
      2.936411,
      0.355991,
      0.738277,
      2.063658,
      2.298994,
      0.575735,
      2,
      0.155000,
      NULL,
      NULL,
      NULL,
      3.032704,
      1.616078,
      1.110456,
      2,
      1.805652,
      NULL,
      3.942448,
      0.903603,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      11,
      NULL,
      1,
      1,
      0.941554,
      1.945562,
      1,
      NULL,
      8,
      1,
      3,
      1,
      NULL,
      NULL,
      1.866602,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119771,
      1,
      0,
      1,
      0.525989,
      2.341013,
      NULL,
      0,
      0.380638,
      0,
      NULL,
      NULL,
      5,
      3.951264,
      3,
      5.139238,
      0.699743,
      5.002606,
      7.141819,
      NULL,
      NULL,
      NULL,
      3,
      1.519417,
      0.844634,
      1.590891,
      2,
      NULL,
      NULL,
      NULL,
      6.126065,
      NULL,
      0.724517,
      2.358008,
      0.073637,
      3,
      2,
      3.217051,
      2,
      2,
      2.588112,
      3.904127,
      0.647151,
      3,
      NULL,
      7.748954,
      3,
      4,
      0,
      NULL,
      NULL,
      3.849152,
      NULL,
      NULL,
      3,
      0,
      2.049043,
      NULL,
      0,
      1.057326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.469966,
      NULL,
      NULL,
      3.661827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.218704,
      NULL,
      NULL,
      0.303905,
      NULL,
      NULL,
      0.481832,
      NULL,
      NULL,
      10.536874,
      NULL,
      NULL,
      0,
      1.555559,
      1,
      0.274993,
      1.330030,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.382887,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353046,
      NULL,
      0,
      1,
      363,
      NULL,
      1.477188,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532669,
      0,
      0.776158,
      1,
      0,
      56.465135,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1.374799,
      0,
      1,
      1,
      0.754039,
      NULL,
      1.749365,
      0,
      0,
      1.962919,
      NULL,
      NULL,
      0,
      1.528091,
      0.568321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989159,
      NULL,
      0,
      1.532434,
      0,
      NULL,
      NULL,
      2.440204,
      1,
      2.025218,
      0,
      3.096607,
      1,
      NULL,
      NULL,
      1.206260,
      NULL,
      2.632782,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0.989855,
      0,
      NULL,
      NULL,
      0.153073,
      0,
      NULL,
      NULL,
      0.802023,
      3.285969,
      1,
      NULL,
      2.850581,
      0,
      1,
      2.013347,
      1,
      0.739712,
      3.455771,
      1.944975,
      3,
      0.738701,
      1,
      0,
      0,
      NULL,
      1,
      2.304015,
      0.033110,
      2,
      NULL,
      1,
      NULL,
      1,
      0.529308,
      0.190995,
      1.298159,
      2,
      0.445724,
      1.879274,
      NULL,
      3,
      0.113758,
      NULL,
      NULL,
      0,
      1.690553,
      NULL,
      9.899466,
      0.866401,
      9,
      0.410135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.846210,
      NULL,
      7,
      9.335554,
      10,
      0,
      1,
      2,
      56,
      1.262721,
      3.279105,
      2.924731,
      2,
      '44232',
      NULL,
      '',
      0.213957,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


