set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9741228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      2.489908,
      NULL,
      0.000039,
      NULL,
      1,
      3,
      2.903387,
      NULL,
      '04',
      32,
      NULL,
      '4221433',
      NULL,
      0.741762,
      3,
      NULL,
      '4420',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.212408,
      NULL,
      ' 3-18-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '10-13-1979',
      ' 8-23-1976',
      ' 4- 8-1991',
      2.278140,
      NULL,
      2.162369,
      1.978584,
      0.144746,
      1.436928,
      7,
      1,
      0,
      54.665700,
      0.062543,
      0.049087,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.307440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      NULL,
      0.147764,
      1,
      2.712611,
      1,
      0.800071,
      1,
      1.744344,
      0,
      1.963013,
      0.785160,
      1,
      1.866242,
      1,
      3.177749,
      0.041601,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.473787,
      NULL,
      0.258151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.231253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821676,
      0,
      1,
      0,
      4.696590,
      2.561031,
      NULL,
      NULL,
      1,
      1,
      0.544457,
      NULL,
      1.088440,
      0,
      1.058902,
      1.389398,
      1.195308,
      NULL,
      1.474709,
      NULL,
      0.863890,
      0,
      NULL,
      0.528260,
      0.048868,
      0.122046,
      0.775329,
      3,
      1.337654,
      1.682060,
      2,
      0,
      2.823697,
      2,
      1,
      1,
      1,
      4.423976,
      2.446518,
      3,
      5,
      3,
      1,
      4,
      2,
      4.076109,
      6,
      1,
      ' 5- 3-1986',
      931.131136,
      NULL,
      31,
      1.289279,
      1.772375,
      0,
      1,
      1.438890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531744,
      1,
      1.464624,
      0.677266,
      1.083778,
      5.683331,
      1.981326,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.910932,
      0,
      1.758366,
      1.845731,
      0.947722,
      NULL,
      NULL,
      NULL,
      1.960457,
      1,
      1.092620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.012505,
      0,
      0.143379,
      2,
      27,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      0,
      2,
      2,
      NULL,
      NULL,
      2.869900,
      NULL,
      3,
      2.579889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954127,
      1.843033,
      0,
      1,
      0,
      NULL,
      0.946708,
      NULL,
      NULL,
      1,
      10,
      6,
      0.555431,
      0.218122,
      2.101017,
      NULL,
      5,
      0.346822,
      3.863088,
      2.198067,
      NULL,
      0.698973,
      NULL,
      1.752499,
      0,
      NULL,
      NULL,
      28.111482,
      NULL,
      2.327310,
      3.771093,
      2,
      '22330',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      22,
      91.598383,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.320556,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.794401,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.948268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963621,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.151144,
      NULL,
      NULL,
      4,
      0,
      0.979439,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424432,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461288,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.686574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862274,
      NULL,
      NULL,
      0.735462,
      NULL,
      NULL,
      0.627332,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.106637,
      0.922755,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      5.946642,
      1.737126,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.319747,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.536725,
      NULL,
      NULL,
      0.910011,
      2.172257,
      0.433172,
      NULL,
      2.434315,
      1,
      6.836142,
      0.152012,
      0,
      0.111833,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      0,
      3,
      0,
      1.386394,
      4,
      1,
      1,
      1.945663,
      1.491433,
      0.434975,
      0,
      0.593801,
      1,
      1.043966,
      0.251172,
      1,
      2,
      1.432056,
      1.549387,
      1.707340,
      1,
      0,
      1.283247,
      1.849134,
      1.748504,
      3,
      0.151174,
      7,
      NULL,
      2.081707,
      0.460687,
      1.410362,
      1,
      0.882892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545483,
      NULL,
      NULL,
      1.564392,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.344429,
      NULL,
      NULL,
      0.821492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319523,
      NULL,
      NULL,
      0.430967,
      NULL,
      1,
      0.529229,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714449,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.127207,
      NULL,
      NULL,
      0,
      0.426165,
      NULL,
      NULL,
      0,
      1.316963,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.511595,
      0.682947,
      NULL,
      NULL,
      1.629117,
      NULL,
      NULL,
      NULL,
      1,
      0.243702,
      4,
      1.365735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.331680,
      45,
      4.038548,
      0.722061,
      NULL,
      NULL,
      1,
      NULL,
      0,
      6,
      NULL,
      NULL,
      0.965899,
      1.453697,
      0,
      0.692380,
      1,
      1,
      0.054218,
      1,
      NULL,
      0,
      0.002270,
      0.495854,
      0.511885,
      1.105149,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107421,
      0.238442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.035052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681915,
      0.186395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700112,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435190,
      1.078260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.055878,
      NULL,
      0.488199,
      NULL,
      1.607153,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.812456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102535,
      0.340865,
      0.990423,
      NULL,
      3,
      0,
      4.544627,
      0.842280,
      8.401466,
      3,
      1,
      0,
      1,
      NULL,
      0.488300,
      1,
      NULL,
      1.557670,
      1.973639,
      0.912543,
      NULL,
      0,
      1,
      1.294624,
      0.871962,
      0.062299,
      1.303931,
      0,
      3.356519,
      NULL,
      0,
      1.048444,
      3,
      1.694036,
      0,
      2,
      1,
      NULL,
      NULL,
      0.782255,
      3.165377,
      0,
      1,
      NULL,
      3,
      NULL,
      3.482163,
      0.863591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.962428,
      NULL,
      8.456206,
      10.882009,
      8.151683,
      0,
      1.741289,
      2,
      18.887238,
      37,
      NULL,
      NULL,
      3.943273,
      '21302',
      '',
      '',
      1.243640,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


