set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648302';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '24',
      5.644930,
      26,
      '1411321',
      0.450198,
      1,
      0,
      3,
      '4011',
      1.145483,
      0,
      NULL,
      NULL,
      '11- 9-1998',
      174,
      4,
      NULL,
      NULL,
      NULL,
      ' 6-23-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      3.798969,
      NULL,
      NULL,
      ' 2- 4-1992',
      2.265228,
      0.067818,
      3,
      NULL,
      1,
      1.917697,
      9,
      1,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.286849,
      1.390776,
      0.951264,
      1.606606,
      1,
      1,
      0,
      NULL,
      1,
      1.353180,
      0,
      5,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      5,
      0.546380,
      1.512231,
      10,
      NULL,
      0,
      1.259551,
      1,
      1,
      8.352974,
      NULL,
      NULL,
      NULL,
      0.911071,
      0.439337,
      NULL,
      NULL,
      1.975300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002812,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.969611,
      0,
      5,
      0.739268,
      1,
      0.493234,
      1,
      2,
      1.507432,
      1,
      0,
      NULL,
      0,
      NULL,
      0.535938,
      0.335170,
      0,
      NULL,
      0,
      0.658023,
      1,
      NULL,
      1.112543,
      1.199146,
      2.039277,
      1.279770,
      1.425417,
      0.556331,
      0.887962,
      0,
      0.135393,
      3,
      0,
      1,
      0.115202,
      6,
      NULL,
      3.181292,
      NULL,
      6,
      6.106707,
      NULL,
      0.566423,
      1.272061,
      1.647747,
      1,
      '11- 1-1996',
      NULL,
      NULL,
      375,
      0,
      1,
      0.784773,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576110,
      0.964735,
      1,
      1,
      0,
      0.311399,
      3,
      0.624793,
      NULL,
      0.432353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      NULL,
      1.390871,
      0.209191,
      1.535350,
      0,
      2,
      NULL,
      3.693342,
      1,
      0,
      1,
      NULL,
      2.797041,
      NULL,
      0.766169,
      2,
      1,
      0,
      0.316271,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289464,
      3,
      0.627952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.766445,
      0,
      1.355544,
      1.130564,
      1,
      0,
      0.637462,
      NULL,
      2.362885,
      1.672844,
      NULL,
      NULL,
      NULL,
      1,
      1.804290,
      1,
      NULL,
      3,
      1,
      2.336481,
      3.856198,
      2.292269,
      0,
      3.377302,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      NULL,
      0,
      5.118047,
      0,
      0,
      0,
      0.652268,
      1,
      3.479805,
      NULL,
      NULL,
      NULL,
      0.922510,
      3,
      1,
      NULL,
      10,
      2,
      6.860457,
      0.662501,
      4,
      5,
      2,
      2.636911,
      0,
      1.476943,
      1,
      24,
      3.378129,
      1.691056,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257104,
      1,
      1,
      '32411',
      '',
      '',
      1.941470,
      '',
      NULL,
      '',
      1.482662,
      '',
      '',
      '',
      NULL,
      NULL,
      338.366711,
      71,
      1.948020,
      45,
      2.967594,
      1.661993,
      0.681491,
      3.135964,
      1,
      0.057340,
      0.705684,
      NULL,
      NULL,
      0.862025,
      NULL,
      NULL,
      1,
      1.056576,
      0,
      NULL,
      NULL,
      NULL,
      0.517343,
      NULL,
      NULL,
      0.447276,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.760873,
      0.877235,
      1,
      0,
      NULL,
      NULL,
      1.542770,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11,
      0,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.777045,
      1,
      0,
      3.802561,
      1,
      0.047651,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      1,
      0,
      NULL,
      2,
      0.641430,
      0.937455,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.264561,
      NULL,
      NULL,
      1.394584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154400,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.400349,
      NULL,
      NULL,
      2.535162,
      0.583442,
      0.793445,
      1.531183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.679742,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.819130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.902591,
      NULL,
      NULL,
      1.096650,
      NULL,
      NULL,
      1.872496,
      NULL,
      NULL,
      NULL,
      0.673634,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.987621,
      NULL,
      1.771835,
      0,
      0.889093,
      0.364662,
      1.450651,
      0,
      9,
      NULL,
      5.459279,
      0,
      1.092645,
      NULL,
      1,
      NULL,
      NULL,
      2.066047,
      3,
      0,
      0.972209,
      0,
      1.089175,
      7,
      5.649876,
      7.561792,
      NULL,
      1,
      0,
      1.526371,
      NULL,
      NULL,
      1.923236,
      0.658485,
      1,
      NULL,
      1,
      1.268135,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516155,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.844974,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.904300,
      NULL,
      NULL,
      1.049542,
      NULL,
      NULL,
      0.795327,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.090827,
      2,
      1.406030,
      0,
      1,
      3.963385,
      1.041466,
      NULL,
      NULL,
      0.095117,
      NULL,
      NULL,
      292.063373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095592,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744433,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088273,
      NULL,
      NULL,
      0.705285,
      0.319704,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.712123,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.388618,
      0.183487,
      NULL,
      NULL,
      8,
      6,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      1.129607,
      NULL,
      NULL,
      0,
      NULL,
      184.531269,
      0.346344,
      NULL,
      NULL,
      2.623763,
      NULL,
      249.701527,
      1.839214,
      NULL,
      NULL,
      0.693658,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1447.895080,
      0.925324,
      NULL,
      0.395157,
      1,
      1.714627,
      NULL,
      1,
      1.055388,
      1,
      NULL,
      0,
      0.626152,
      0.658583,
      1.348796,
      1,
      0.923748,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.144501,
      1,
      5,
      0,
      5,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.888371,
      NULL,
      NULL,
      NULL,
      NULL,
      3.532602,
      0,
      NULL,
      0,
      2.874876,
      NULL,
      3,
      0.704128,
      NULL,
      1,
      NULL,
      NULL,
      3.449059,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.203234,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.914079,
      NULL,
      1.442334,
      NULL,
      3.938567,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.462175,
      NULL,
      0.757507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.442364,
      NULL,
      3.370511,
      NULL,
      1,
      NULL,
      6.588703,
      NULL,
      0,
      NULL,
      1,
      0.824796,
      22,
      NULL,
      6.160096,
      0.194787,
      1,
      NULL,
      '4020',
      '',
      1.906703,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


