set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2.454257,
      3,
      3.703891,
      NULL,
      2,
      5.837661,
      NULL,
      '23424002',
      17.554981,
      NULL,
      NULL,
      1,
      0.615585,
      3,
      3,
      '1443',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.777496,
      27,
      NULL,
      0.743851,
      NULL,
      ' 0-22-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      3.352432,
      NULL,
      NULL,
      ' 0- 3-1982',
      2.986977,
      NULL,
      2.901317,
      2.605476,
      1.479759,
      NULL,
      2,
      3.584388,
      NULL,
      NULL,
      NULL,
      10,
      6.142775,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      NULL,
      0.406138,
      1,
      1,
      1.987515,
      0,
      0.575005,
      1.110382,
      4,
      0.938497,
      0,
      1.155158,
      2,
      5,
      3.764653,
      1,
      5,
      1.143078,
      1,
      1.724496,
      0,
      1.018824,
      NULL,
      1,
      1.134145,
      NULL,
      2.190272,
      1,
      NULL,
      1.592895,
      5,
      1.060701,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      0.090928,
      NULL,
      0.377999,
      0,
      0.458670,
      NULL,
      2.788943,
      2,
      2,
      NULL,
      1.344352,
      NULL,
      3,
      0,
      0,
      3.193550,
      1,
      0.191467,
      1.081379,
      NULL,
      5,
      2,
      NULL,
      5,
      0.988439,
      0.296319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808261,
      2.026755,
      1,
      NULL,
      1,
      0,
      1.866379,
      NULL,
      0,
      0.205318,
      0.177156,
      0.962093,
      0,
      1.454121,
      NULL,
      0,
      1,
      0.228448,
      1.632183,
      NULL,
      0,
      1,
      1.061418,
      NULL,
      0.274195,
      1,
      4.772573,
      NULL,
      2,
      5.415205,
      2,
      NULL,
      1,
      NULL,
      1.446852,
      0,
      3,
      4.417995,
      3.488870,
      NULL,
      0.488693,
      1,
      NULL,
      5.194125,
      1.720320,
      NULL,
      3.865133,
      NULL,
      NULL,
      NULL,
      ' 8-26-1988',
      NULL,
      NULL,
      NULL,
      0.863040,
      NULL,
      1.415898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446878,
      1,
      3,
      0,
      0.792743,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584746,
      NULL,
      0.395324,
      NULL,
      3,
      1.981924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      0,
      1,
      NULL,
      2.672966,
      1.822131,
      NULL,
      NULL,
      0,
      4.286702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727563,
      NULL,
      0,
      0,
      0.708804,
      0.219836,
      NULL,
      1.610796,
      NULL,
      NULL,
      1.851089,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      3.375066,
      0,
      1,
      1.915236,
      NULL,
      3,
      NULL,
      3,
      2.129023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095106,
      0.369705,
      1.154974,
      1.321014,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.754373,
      3,
      1.208296,
      2.575231,
      1.112051,
      1,
      0.702773,
      3,
      1.011997,
      1.102802,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.899311,
      4,
      NULL,
      '2443',
      '',
      0.398144,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.315580,
      NULL,
      7.235321,
      21.969669,
      0.216786,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.714957,
      1,
      NULL,
      NULL,
      1.025647,
      NULL,
      NULL,
      0.828029,
      NULL,
      NULL,
      1.814946,
      NULL,
      NULL,
      0.241270,
      NULL,
      NULL,
      1.316515,
      0.093411,
      NULL,
      1.536823,
      NULL,
      NULL,
      0.667867,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.878712,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.525456,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.444497,
      1,
      2.321566,
      3,
      NULL,
      NULL,
      0,
      3.533770,
      1.984936,
      3,
      2,
      NULL,
      1.262561,
      3,
      0.747412,
      0.218771,
      2,
      0,
      0,
      1.850894,
      NULL,
      1,
      0.031464,
      NULL,
      NULL,
      0.503886,
      1,
      0.329435,
      1.599243,
      7.964768,
      NULL,
      0.501847,
      0,
      NULL,
      NULL,
      NULL,
      1.634616,
      NULL,
      NULL,
      NULL,
      0.845963,
      NULL,
      NULL,
      0,
      2,
      2.926329,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.279288,
      3.046059,
      1.619954,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.560040,
      NULL,
      NULL,
      1.224550,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      4,
      2,
      4.025144,
      7,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.499559,
      5,
      NULL,
      3.437188,
      1.964570,
      NULL,
      0.653200,
      NULL,
      NULL,
      0.080372,
      NULL,
      NULL,
      1.033533,
      3,
      1,
      NULL,
      7.321724,
      NULL,
      4.384986,
      5,
      0.400728,
      1,
      1,
      4,
      0.412450,
      0.038298,
      1,
      NULL,
      0,
      0.199519,
      NULL,
      NULL,
      1.393620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.708046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.071554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.437281,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.757210,
      0.274904,
      1,
      0.435475,
      1.419567,
      0.602834,
      0.094959,
      NULL,
      NULL,
      5.537982,
      NULL,
      NULL,
      NULL,
      9.035289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.301582,
      NULL,
      NULL,
      NULL,
      1.783781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.398739,
      NULL,
      NULL,
      NULL,
      1.645036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684097,
      NULL,
      NULL,
      NULL,
      2.274039,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.106702,
      NULL,
      NULL,
      NULL,
      0.717809,
      NULL,
      NULL,
      NULL,
      1.335036,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.406776,
      NULL,
      2.224764,
      1,
      3,
      4,
      1.884116,
      0.131786,
      NULL,
      NULL,
      0.209271,
      NULL,
      NULL,
      1.326757,
      NULL,
      NULL,
      1.123332,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.831284,
      2,
      NULL,
      1.432351,
      1.475797,
      1.388030,
      0,
      0,
      1.729721,
      NULL,
      1.390419,
      0,
      NULL,
      1,
      NULL,
      1.537376,
      1.332679,
      1,
      NULL,
      0.016007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      4.444758,
      4,
      NULL,
      NULL,
      0,
      13,
      1.456311,
      1.075177,
      1,
      3.615878,
      2,
      NULL,
      2,
      1.086446,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.047283,
      0.564758,
      NULL,
      0,
      2.988497,
      NULL,
      NULL,
      0,
      NULL,
      1.584898,
      0,
      NULL,
      1,
      0,
      NULL,
      2.948898,
      0.141755,
      NULL,
      3.906015,
      3.139170,
      NULL,
      NULL,
      1.220819,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810304,
      NULL,
      0.891073,
      NULL,
      0,
      NULL,
      NULL,
      8.279439,
      1,
      1,
      NULL,
      NULL,
      38,
      60,
      3.095108,
      0.817358,
      5,
      NULL,
      '2121',
      '2310',
      1.915889,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


