set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9767042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2,
      2.230738,
      3.156770,
      3,
      NULL,
      NULL,
      NULL,
      '01',
      '31314031',
      NULL,
      NULL,
      NULL,
      3.549951,
      1.213499,
      3,
      3,
      '1210',
      NULL,
      0.588073,
      NULL,
      NULL,
      ' 1-23-1995',
      52.720528,
      182.713932,
      NULL,
      3.221940,
      4,
      ' 5-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10-10-1981',
      ' 5-21-1986',
      ' 6-26-1992',
      NULL,
      2.255664,
      2,
      2.602509,
      NULL,
      0,
      2.089613,
      NULL,
      0,
      11.816812,
      6,
      0.950295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.117365,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918578,
      0,
      1.933993,
      0.015764,
      NULL,
      0,
      1.740838,
      1,
      1.230130,
      3,
      2,
      1,
      5.388218,
      0,
      1.871567,
      7,
      3,
      1.686495,
      5,
      0.257447,
      NULL,
      1.762351,
      1.471362,
      0.564732,
      7,
      NULL,
      2,
      NULL,
      0.232850,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      2.911230,
      3,
      NULL,
      3.103282,
      1.199844,
      NULL,
      1,
      0,
      0.997500,
      0.919552,
      NULL,
      2,
      1.370056,
      0.004469,
      3.230094,
      1,
      2,
      NULL,
      0,
      NULL,
      3.655409,
      6.911391,
      NULL,
      5,
      NULL,
      3,
      NULL,
      1,
      1.336969,
      NULL,
      NULL,
      2,
      1.820026,
      0,
      0.660281,
      3.906371,
      NULL,
      1,
      0,
      0.156339,
      1.540757,
      NULL,
      3,
      0.191171,
      5.775651,
      0,
      0.671619,
      NULL,
      0.954075,
      1,
      NULL,
      1.743015,
      0,
      3,
      2.129679,
      NULL,
      3.301755,
      9.970113,
      4.258468,
      3,
      0.968146,
      2,
      0.126741,
      NULL,
      5,
      7,
      8.138269,
      5,
      5,
      NULL,
      NULL,
      7,
      3.745057,
      8,
      0,
      0,
      6.212282,
      1,
      2,
      ' 7-18-1989',
      15,
      ' 5-11-1976',
      35,
      3.941110,
      1.440723,
      NULL,
      7.317886,
      0,
      NULL,
      13.115349,
      1,
      0.709516,
      0,
      5.425030,
      3,
      NULL,
      2.307556,
      2.634442,
      2.322653,
      NULL,
      2.741988,
      3,
      4,
      NULL,
      ' 7-21-1991',
      51.428084,
      ' 3- 7-1979',
      10,
      0.422941,
      0,
      1.158166,
      1.752243,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654095,
      NULL,
      0,
      NULL,
      1.971068,
      11.389780,
      3.385118,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4,
      1.399872,
      NULL,
      NULL,
      NULL,
      0,
      6.704036,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      1.730478,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887580,
      NULL,
      5.578272,
      2,
      5,
      3.519663,
      2,
      NULL,
      0,
      2,
      5,
      1,
      2,
      NULL,
      1.846396,
      0.520217,
      1,
      1,
      1.243847,
      1.770114,
      NULL,
      0,
      0.647792,
      0.830774,
      1.839813,
      1.441760,
      2.069217,
      NULL,
      3.300679,
      1,
      0.487031,
      6.135860,
      NULL,
      5.444348,
      0.828999,
      6.624324,
      4.582502,
      1,
      1,
      NULL,
      NULL,
      3,
      33,
      NULL,
      2,
      37,
      NULL,
      NULL,
      NULL,
      5.179236,
      4,
      0,
      '0201',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.493929,
      25,
      11.428579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.807816,
      NULL,
      1.839025,
      NULL,
      NULL,
      0.183811,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.891806,
      3.330510,
      1.988231,
      0.468818,
      NULL,
      NULL,
      1,
      NULL,
      0,
      331.012026,
      5.239570,
      1,
      0,
      0.688578,
      NULL,
      0,
      1,
      0.688083,
      0,
      1.208163,
      0,
      1.264181,
      1.256541,
      0.377855,
      0.502825,
      1.854840,
      1,
      1,
      1.256710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013386,
      0.880479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822333,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061768,
      1.914915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338019,
      NULL,
      0.079710,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0.257484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450934,
      0,
      1,
      NULL,
      0.528737,
      NULL,
      0.496434,
      NULL,
      0,
      1.228990,
      1.364590,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.837775,
      NULL,
      0.933857,
      0.311058,
      NULL,
      0.029752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804436,
      0,
      NULL,
      2.571120,
      0,
      NULL,
      3.181179,
      NULL,
      3.569222,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.339449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807334,
      NULL,
      1.329149,
      NULL,
      0,
      NULL,
      0,
      NULL,
      53,
      2.823164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487542,
      NULL,
      0.066092,
      NULL,
      2,
      3.037025,
      3.017623,
      1,
      NULL,
      NULL,
      NULL,
      35.113411,
      1.651255,
      4.625790,
      1,
      '2341',
      '',
      '',
      1.762978,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


