set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000069';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '4341203',
      3.088385,
      1,
      0,
      3,
      '1023',
      NULL,
      0,
      1,
      0,
      '10-24-2000',
      62.131286,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-13-1986',
      23,
      4,
      265.192105,
      85,
      NULL,
      NULL,
      NULL,
      ' 5-24-1982',
      2,
      0,
      1,
      0,
      0.210257,
      NULL,
      1.950330,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5.400863,
      5,
      NULL,
      2,
      7,
      1.838135,
      NULL,
      4,
      1,
      1,
      1.503833,
      0,
      0,
      NULL,
      1,
      1.899591,
      5,
      0,
      NULL,
      2,
      0.446381,
      NULL,
      2,
      1,
      1,
      0,
      0,
      1,
      1.144461,
      0,
      1.840860,
      NULL,
      0.968039,
      1.106418,
      1.367203,
      0.607755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757461,
      0.302365,
      0.105995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.368008,
      0.938653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487625,
      NULL,
      NULL,
      0.919752,
      0.511859,
      1.774172,
      1,
      0.806185,
      1,
      1.207749,
      0.236484,
      0,
      0,
      1.528068,
      1.691844,
      NULL,
      0,
      0,
      0.268100,
      0,
      0,
      1.965914,
      0,
      0,
      0.997613,
      NULL,
      1,
      1.861862,
      1.000216,
      0,
      0,
      0,
      NULL,
      1,
      1.643775,
      1.612247,
      0.622326,
      1,
      NULL,
      NULL,
      0.485097,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.936107,
      1.274248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.997564,
      NULL,
      1.200588,
      2.726745,
      NULL,
      1.542100,
      0,
      0.398760,
      NULL,
      0.567516,
      2.382693,
      1,
      1,
      1,
      NULL,
      3,
      0.372608,
      3.200279,
      1,
      5,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.129278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.064411,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043850,
      2,
      NULL,
      1,
      0.483207,
      3.936814,
      0.027257,
      1,
      0,
      3.299240,
      2,
      NULL,
      2.261879,
      1,
      2.010907,
      1,
      1,
      0,
      9.646019,
      0,
      1,
      NULL,
      1,
      0.346909,
      2.129428,
      1.986872,
      0.243757,
      1.266953,
      0,
      3,
      NULL,
      NULL,
      5.752756,
      2,
      2,
      2,
      7,
      0.534764,
      1,
      7,
      3,
      0,
      2,
      1.910061,
      NULL,
      1,
      47,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.661152,
      NULL,
      '',
      '',
      0.093805,
      '',
      '',
      '',
      1.067786,
      '',
      NULL,
      '',
      NULL,
      33.200834,
      13.926031,
      59,
      NULL,
      7,
      1,
      0,
      2.407566,
      0,
      NULL,
      NULL,
      1.910867,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519641,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.242372,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.448941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.263975,
      NULL,
      NULL,
      1.777691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610706,
      NULL,
      NULL,
      1.446074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537273,
      NULL,
      NULL,
      1.613186,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.982905,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.060941,
      NULL,
      NULL,
      1.358651,
      NULL,
      NULL,
      0.905523,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.029055,
      NULL,
      NULL,
      0.127185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.106648,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.701587,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.892940,
      NULL,
      NULL,
      1.960934,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.354733,
      NULL,
      0.690630,
      1,
      0.987014,
      0.482539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.045562,
      0.305262,
      3,
      NULL,
      0,
      0.860132,
      2.005619,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095453,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.717178,
      NULL,
      NULL,
      NULL,
      0.759463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543060,
      NULL,
      NULL,
      NULL,
      0.074521,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.580064,
      NULL,
      NULL,
      NULL,
      0.656286,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3.194440,
      NULL,
      0,
      2,
      NULL,
      1.108026,
      0.976687,
      NULL,
      NULL,
      0.335508,
      NULL,
      NULL,
      0.712452,
      NULL,
      NULL,
      0.760512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247337,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3255,
      1370,
      0,
      NULL,
      0,
      0,
      1.898604,
      1.364770,
      1,
      NULL,
      1.243093,
      NULL,
      1.776674,
      NULL,
      1,
      1,
      0.716718,
      1,
      0,
      1.724655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      0,
      NULL,
      1,
      0,
      7.956132,
      2.769970,
      NULL,
      0.725452,
      1,
      NULL,
      NULL,
      NULL,
      1.383516,
      1.034179,
      0,
      0.239586,
      1.875210,
      1,
      1,
      0.792112,
      1.221944,
      1.679569,
      NULL,
      1.780759,
      0.992850,
      1,
      0,
      NULL,
      0.570307,
      0,
      1,
      1.200942,
      1.680276,
      0.327181,
      1.089007,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.612104,
      3,
      1.598395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.583956,
      0,
      0,
      NULL,
      0,
      NULL,
      1.809777,
      NULL,
      18.278006,
      NULL,
      1.375440,
      NULL,
      1.383377,
      NULL,
      1,
      NULL,
      1.341324,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0.617276,
      NULL,
      0.418540,
      1.242987,
      0,
      0.847879,
      NULL,
      0,
      1,
      4,
      3.574264,
      0.599654,
      NULL,
      NULL,
      65,
      101.436574,
      0.073400,
      1,
      1,
      '43443',
      '',
      '',
      1,
      '',
      '',
      '',
      0.463750,
      '',
      '',
      '');
commit;
end;
/


