set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6703672';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '34',
      36,
      22.437813,
      '3124222',
      NULL,
      0.216700,
      3,
      1,
      '4214',
      3,
      NULL,
      NULL,
      NULL,
      ' 1- 7-2003',
      163.555102,
      6,
      NULL,
      3.622983,
      NULL,
      ' 6- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      2.829813,
      ' 6-11-1992',
      ' 1-26-1991',
      ' 7-20-1986',
      3,
      0,
      1.516537,
      0,
      0,
      2,
      0,
      0.897521,
      1,
      65.373630,
      6.048884,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      1.490875,
      0,
      1,
      0,
      1,
      0.503849,
      1.465397,
      1,
      44,
      NULL,
      NULL,
      7.293515,
      NULL,
      0,
      0,
      2,
      1,
      1.374930,
      0,
      0,
      NULL,
      0.610024,
      1.546912,
      1.260495,
      1.143281,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457072,
      NULL,
      0.713351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368712,
      NULL,
      1,
      3.832785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.275694,
      0.738490,
      1,
      1.999171,
      0,
      0,
      1,
      0.686843,
      1.444645,
      1,
      0.878114,
      NULL,
      1,
      3.067091,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.167104,
      0,
      1.278935,
      1,
      1,
      0.865387,
      0,
      0,
      0,
      3,
      0.598619,
      0,
      1.258805,
      1,
      1,
      0.304445,
      0.287746,
      1.507606,
      0.153601,
      1,
      3.561644,
      3,
      1,
      1,
      NULL,
      NULL,
      1.146213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.102339,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.594923,
      2,
      0,
      NULL,
      NULL,
      2.587367,
      1,
      0.311898,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.812609,
      1,
      0.378414,
      NULL,
      1.760069,
      3.981046,
      465,
      0,
      2,
      16.949930,
      46.701447,
      NULL,
      1,
      0,
      2.827769,
      2,
      2,
      2,
      NULL,
      2.270295,
      3,
      3,
      2.376263,
      1,
      1.335168,
      NULL,
      NULL,
      2.331116,
      1.284919,
      NULL,
      0.251869,
      1.130806,
      1,
      1,
      2.234676,
      NULL,
      1.053017,
      1.657980,
      1,
      0.269763,
      1.818320,
      1.633350,
      NULL,
      0.591704,
      10.757152,
      6,
      NULL,
      3,
      1,
      3,
      0,
      3.440543,
      7,
      0,
      1.428112,
      3,
      NULL,
      3.614233,
      1,
      30.242320,
      NULL,
      NULL,
      19,
      5,
      4.034818,
      2,
      '03121',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      0.536342,
      NULL,
      '31100',
      '14110',
      3,
      18,
      733.322229,
      32.267996,
      NULL,
      NULL,
      7.714416,
      NULL,
      NULL,
      NULL,
      1.647324,
      2,
      0.981504,
      1.496810,
      1.869873,
      3.804348,
      0.531152,
      1.271020,
      2.593798,
      0.130952,
      NULL,
      3.357252,
      3,
      NULL,
      NULL,
      NULL,
      0.258918,
      3.788111,
      1,
      1.128868,
      3,
      2.692096,
      1.444228,
      3,
      1.877945,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.479781,
      NULL,
      NULL,
      7,
      6.944253,
      7,
      NULL,
      0.528642,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500340,
      0.836231,
      3.173448,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.234125,
      NULL,
      1,
      3,
      2,
      3.363679,
      0.746595,
      NULL,
      1,
      NULL,
      1.861789,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.465745,
      0.561140,
      2.362834,
      NULL,
      0.871692,
      7,
      0.102227,
      1.147730,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.868057,
      1,
      3,
      NULL,
      0,
      1.401659,
      0.581486,
      0.143415,
      NULL,
      0,
      NULL,
      NULL,
      11.539581,
      1.907628,
      NULL,
      0.207717,
      NULL,
      3.027222,
      1.103193,
      1,
      NULL,
      7,
      2.177570,
      NULL,
      3,
      1,
      0,
      1,
      0,
      3.922797,
      0.299632,
      NULL,
      NULL,
      0.172141,
      NULL,
      NULL,
      3,
      1,
      1.834098,
      3.048982,
      1,
      4,
      0,
      0.438445,
      0.568229,
      NULL,
      1,
      NULL,
      4.080563,
      0.597136,
      NULL,
      9,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3.195239,
      0,
      2,
      NULL,
      0,
      2.160671,
      0,
      1,
      0.474279,
      2.515207,
      2,
      5,
      1,
      0.563294,
      0.684585,
      3,
      NULL,
      2.664890,
      2.142949,
      0,
      3.277733,
      0.552521,
      2.920162,
      NULL,
      NULL,
      NULL,
      NULL,
      6.384549,
      0,
      0.118755,
      1,
      0.613042,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1.979160,
      NULL,
      NULL,
      0.427638,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      2.400215,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0,
      0,
      1.867297,
      NULL,
      0.942231,
      2.020759,
      2.074717,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.241012,
      NULL,
      NULL,
      0.606443,
      1,
      NULL,
      NULL,
      1.214156,
      3.317137,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684558,
      0.328675,
      NULL,
      NULL,
      2,
      2.600099,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.144221,
      NULL,
      NULL,
      1,
      1.500088,
      NULL,
      NULL,
      1.120035,
      NULL,
      NULL,
      NULL,
      6.465112,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.866727,
      195,
      119.304209,
      3.029115,
      3.578139,
      1.986641,
      1.339070,
      NULL,
      NULL,
      1,
      69.364882,
      14.630155,
      0.637031,
      24,
      13.230705,
      2,
      9.267135,
      5,
      1,
      3,
      1.719827,
      137,
      NULL,
      0.235397,
      0,
      1,
      1.777330,
      0.597696,
      1,
      0,
      1,
      1.653727,
      0,
      1.047610,
      1.885863,
      0,
      1.166944,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.612670,
      3,
      5.253746,
      1,
      1,
      9,
      1,
      1,
      1,
      1,
      NULL,
      1.949574,
      NULL,
      NULL,
      NULL,
      0,
      2.495475,
      1.306417,
      1.557685,
      0,
      1.188566,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.248370,
      0.393094,
      1.206039,
      NULL,
      1.175851,
      NULL,
      NULL,
      0,
      NULL,
      0.674925,
      0.870857,
      0.524808,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.781202,
      1.837138,
      NULL,
      7.355235,
      0.285152,
      0,
      NULL,
      NULL,
      9,
      55.138716,
      5,
      1.195700,
      2,
      '00143',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '22320',
      '',
      '');
commit;
end;
/


