set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204365';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '0340311',
      2.650218,
      1.158243,
      2,
      3,
      '1340',
      NULL,
      1,
      NULL,
      NULL,
      ' 7-28-1979',
      NULL,
      NULL,
      NULL,
      2.696428,
      0.084366,
      ' 2-10-1984',
      NULL,
      2.490469,
      168.972464,
      74.075264,
      3,
      '11-10-2002',
      ' 3-18-1983',
      ' 9-11-1998',
      1.296378,
      2.914191,
      2,
      0.598358,
      0,
      NULL,
      1,
      3.456731,
      NULL,
      NULL,
      NULL,
      4.786034,
      10.796530,
      16,
      NULL,
      3,
      10.704511,
      NULL,
      2,
      4,
      0.037527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      3,
      NULL,
      1,
      0,
      0,
      6.739841,
      1.247404,
      0.657589,
      1,
      1,
      1.851313,
      0,
      4,
      1.530309,
      NULL,
      NULL,
      0.381704,
      0.396430,
      NULL,
      NULL,
      1.842778,
      NULL,
      NULL,
      0.254212,
      NULL,
      1.647310,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.530358,
      0.286534,
      1,
      1.689754,
      0.374840,
      0.070864,
      0.291258,
      1,
      NULL,
      NULL,
      1.717424,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      5,
      4,
      NULL,
      1.443988,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0.678291,
      0.788837,
      0.067984,
      NULL,
      0,
      NULL,
      3.477959,
      0,
      0,
      NULL,
      4,
      NULL,
      1,
      1.619252,
      1.225910,
      0.361613,
      1.042287,
      1,
      0.882283,
      1,
      0.447477,
      0,
      1,
      5.686377,
      1.198237,
      1.942213,
      4.279308,
      1,
      0.858381,
      1.382549,
      1,
      2,
      NULL,
      NULL,
      ' 1- 1-1978',
      362,
      NULL,
      NULL,
      1,
      2.437064,
      1.673186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.068041,
      1.931419,
      0.890741,
      NULL,
      0.751366,
      0.950775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.711644,
      0.079046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616275,
      1.809771,
      NULL,
      1,
      NULL,
      2,
      0.052622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.958239,
      1.745340,
      NULL,
      NULL,
      NULL,
      0,
      0,
      51.136409,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.955568,
      3.843598,
      0,
      NULL,
      2.675505,
      2,
      1.231157,
      0.873138,
      1.825169,
      1.671691,
      0,
      1,
      1,
      0.303277,
      2,
      3,
      1.545808,
      1.547654,
      7,
      0,
      1,
      NULL,
      NULL,
      0,
      3.292825,
      0,
      1,
      0,
      1,
      1,
      0.694781,
      4,
      10,
      5,
      0,
      6,
      1.695090,
      4.885513,
      3,
      1,
      2,
      0.455666,
      0,
      52,
      2.540168,
      NULL,
      NULL,
      NULL,
      NULL,
      6.702750,
      0.497580,
      NULL,
      1.855298,
      '1044',
      NULL,
      '',
      NULL,
      '3044',
      '',
      '',
      2.937620,
      '0103',
      '',
      NULL,
      2,
      8.726200,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.073245,
      2.528340,
      NULL,
      NULL,
      NULL,
      0.698609,
      NULL,
      NULL,
      1.288877,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318377,
      4.318837,
      NULL,
      0,
      0.622708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.670794,
      3,
      2.608367,
      1,
      NULL,
      NULL,
      0.145319,
      NULL,
      NULL,
      3,
      0,
      1,
      1.202033,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.825517,
      NULL,
      NULL,
      0.617144,
      NULL,
      NULL,
      1.040834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.859834,
      1.101393,
      0,
      0.257453,
      NULL,
      NULL,
      0,
      2.889267,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.781662,
      NULL,
      NULL,
      1.924878,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.894095,
      NULL,
      NULL,
      0,
      0,
      1.667383,
      5,
      1.041692,
      1.549446,
      3.235541,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.505238,
      1,
      3.707707,
      3.302152,
      NULL,
      1,
      3.408523,
      1,
      3,
      NULL,
      NULL,
      2.365047,
      3.142327,
      0.556279,
      0.082008,
      6.412713,
      4.535318,
      NULL,
      5.762619,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.519639,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.931573,
      1.575119,
      1.645967,
      1.067378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292341,
      NULL,
      NULL,
      NULL,
      1.662909,
      NULL,
      2,
      0.590865,
      4.492681,
      0.446222,
      1.659875,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.104452,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      27,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1.860908,
      0,
      0.031221,
      NULL,
      1.483472,
      0,
      1,
      NULL,
      1.320167,
      0.519822,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962767,
      0.128171,
      NULL,
      5,
      1,
      3.929551,
      2.278398,
      NULL,
      8,
      3,
      2,
      0,
      1.712673,
      1,
      NULL,
      1,
      1,
      NULL,
      0.221773,
      NULL,
      NULL,
      1.527558,
      NULL,
      NULL,
      0.956837,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.013962,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1.525937,
      NULL,
      0.102343,
      1,
      NULL,
      1,
      1.203924,
      1.148569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711879,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.318266,
      NULL,
      1.129174,
      NULL,
      NULL,
      55.145443,
      59.256960,
      5.877932,
      2.640717,
      1,
      '4201',
      '',
      '',
      2.908408,
      NULL,
      '',
      '',
      3.880968,
      '1033',
      '3141',
      NULL);
commit;
end;
/


