set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      4.821596,
      1,
      0,
      0,
      0.243047,
      3,
      2.764735,
      '014',
      NULL,
      59,
      45.175363,
      '0042412',
      3,
      NULL,
      NULL,
      1,
      '3201',
      2.613330,
      NULL,
      NULL,
      NULL,
      ' 6-17-1982',
      62,
      NULL,
      NULL,
      1.189579,
      1,
      ' 1-18-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      3.732042,
      NULL,
      NULL,
      ' 9- 5-2003',
      2,
      1,
      1,
      3,
      NULL,
      0.417938,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.808129,
      6,
      NULL,
      NULL,
      1.796647,
      1,
      1.883151,
      1.864645,
      0.957253,
      1,
      1,
      1.005385,
      5.260424,
      1,
      1,
      2,
      0.608067,
      1.628791,
      NULL,
      0,
      4,
      3,
      3,
      NULL,
      1.479840,
      1.890178,
      0,
      4,
      3,
      1.571189,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.495608,
      1,
      3,
      1.593971,
      NULL,
      1.434708,
      3,
      1.026588,
      0,
      2.232569,
      1.485075,
      1,
      2,
      1,
      1.197093,
      1,
      2.069073,
      2.541529,
      1,
      1,
      4,
      6,
      3,
      NULL,
      0.682543,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.383693,
      NULL,
      4,
      NULL,
      0.842307,
      0,
      0,
      0.766607,
      0.400845,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0.221638,
      0,
      NULL,
      1.822844,
      NULL,
      NULL,
      0,
      1.558185,
      0,
      1,
      1,
      1.495200,
      4,
      4.778450,
      1.617325,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806619,
      3,
      2.365786,
      1.999857,
      NULL,
      2,
      5.640434,
      0.500199,
      NULL,
      0.834032,
      NULL,
      ' 4- 2-1993',
      166.833595,
      ' 2-22-1985',
      3.895461,
      NULL,
      1.019523,
      1,
      1,
      0.573509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339101,
      0.725643,
      1.542389,
      0,
      0,
      0,
      0.505102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.320239,
      3.440816,
      2,
      NULL,
      2.942049,
      1.321349,
      1.300009,
      1.047415,
      2.900680,
      6.928393,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7,
      1.088897,
      2.046445,
      NULL,
      8.488785,
      0,
      NULL,
      NULL,
      NULL,
      5.309786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567821,
      3.226850,
      1.799007,
      NULL,
      0.657554,
      0.789977,
      0.311328,
      1.689992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      0.674327,
      3,
      2,
      1,
      NULL,
      0.369522,
      2.942704,
      NULL,
      3.988722,
      NULL,
      2,
      0,
      0.943447,
      0.861314,
      0,
      NULL,
      NULL,
      NULL,
      0.155259,
      NULL,
      NULL,
      0,
      0,
      1.133702,
      0,
      2.014454,
      NULL,
      0.994033,
      3,
      3,
      0,
      5.360206,
      4,
      0.787159,
      1,
      1,
      NULL,
      1.695608,
      0,
      0,
      54.715990,
      0,
      1.008613,
      37,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.714451,
      '24403',
      '1330',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.733247,
      13,
      NULL,
      20.968557,
      1.878424,
      6,
      1.706911,
      2,
      0.029650,
      1,
      NULL,
      0,
      1.211428,
      NULL,
      NULL,
      3.633194,
      1.593309,
      1.452953,
      1,
      NULL,
      NULL,
      1.383394,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.330780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.675943,
      NULL,
      NULL,
      2.709350,
      0,
      5.431423,
      NULL,
      1.014256,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      3,
      3,
      0,
      1.245858,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.660635,
      1,
      1,
      1.664745,
      0.142576,
      NULL,
      NULL,
      2,
      1,
      1.459051,
      0,
      1.863820,
      1,
      0.634044,
      1,
      NULL,
      1.127479,
      0.816145,
      1.590353,
      0,
      NULL,
      NULL,
      0.478101,
      1,
      2.956054,
      4,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      3.832942,
      1.778482,
      0.698623,
      NULL,
      NULL,
      0.231967,
      3.407441,
      3,
      NULL,
      2,
      5,
      1.587039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479095,
      NULL,
      NULL,
      0.752511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.771508,
      NULL,
      NULL,
      4.432762,
      6,
      3.232474,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      1.763393,
      NULL,
      0,
      5.759939,
      6.464621,
      1,
      2,
      2,
      3,
      2,
      NULL,
      1,
      3.057929,
      3.246659,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.901906,
      1,
      7,
      NULL,
      NULL,
      1.246155,
      NULL,
      NULL,
      1.658926,
      NULL,
      NULL,
      1.250232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487867,
      NULL,
      NULL,
      1.224564,
      NULL,
      NULL,
      0.085412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383235,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.192965,
      1,
      0,
      0,
      2.493673,
      2.936122,
      1.033798,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.636718,
      25,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.767280,
      2.261385,
      NULL,
      NULL,
      1,
      2.456098,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.435562,
      NULL,
      NULL,
      NULL,
      3.399949,
      2,
      NULL,
      NULL,
      3.842538,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.497692,
      NULL,
      NULL,
      NULL,
      1.825634,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737519,
      NULL,
      NULL,
      2.791806,
      2.595311,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.857102,
      0.613153,
      18.062549,
      4,
      2.759199,
      21.453846,
      6.080615,
      0,
      NULL,
      NULL,
      0.630866,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.995278,
      1,
      1,
      1,
      3,
      1.408708,
      0,
      NULL,
      0.914741,
      0,
      0,
      0,
      1,
      1,
      0.884329,
      0,
      0,
      0,
      NULL,
      0.472639,
      0.004410,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.287039,
      NULL,
      2.698039,
      NULL,
      1.177328,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      0.952138,
      0.202374,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.593646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500094,
      NULL,
      1.486866,
      NULL,
      1.147512,
      NULL,
      0.296977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.324739,
      NULL,
      2.998035,
      NULL,
      19,
      NULL,
      0.160370,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.130356,
      NULL,
      1.294635,
      0.221149,
      1,
      NULL,
      3,
      NULL,
      22,
      NULL,
      2.104299,
      NULL,
      1.195708,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.491480,
      5,
      2,
      NULL,
      0.641101,
      NULL,
      2.973249,
      2,
      9,
      2.681601,
      3,
      1,
      1.348642,
      0,
      NULL,
      1,
      1.455917,
      NULL,
      0,
      0.602389,
      NULL,
      0.121679,
      NULL,
      NULL,
      3.615262,
      0.170818,
      NULL,
      1.617026,
      1.603830,
      NULL,
      0.953338,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.657049,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      1.131025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.254317,
      NULL,
      NULL,
      0.778288,
      NULL,
      0.520900,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.181116,
      NULL,
      NULL,
      NULL,
      0.819060,
      NULL,
      NULL,
      NULL,
      0.149766,
      NULL,
      1.515098,
      NULL,
      0.506121,
      NULL,
      NULL,
      0.073617,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4.055720,
      5.534293,
      0,
      1,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0.583869,
      NULL,
      '43014',
      '4321',
      '21340',
      NULL,
      '',
      '',
      NULL,
      0.426087,
      '',
      '',
      '');
commit;
end;
/


