set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107980';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      3.332545,
      0,
      1,
      2,
      '2241',
      1,
      NULL,
      5.765009,
      41.961632,
      ' 0-18-1995',
      98,
      NULL,
      4.430851,
      1.291127,
      NULL,
      ' 5- 9-1985',
      57.319528,
      2,
      263,
      108,
      NULL,
      NULL,
      NULL,
      '11- 8-1978',
      2.970395,
      NULL,
      0,
      0.490616,
      1.030308,
      2.563179,
      3,
      0,
      0,
      289,
      8,
      12.355535,
      7,
      9.471040,
      9.431558,
      4.358052,
      11,
      2,
      2.386451,
      6.059140,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      7,
      7,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      3,
      0,
      1,
      3.184678,
      4,
      0.922164,
      3,
      1.385853,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      6.986199,
      1.425998,
      1,
      0.071253,
      0,
      2,
      2.381829,
      0,
      NULL,
      0,
      3.795420,
      NULL,
      3.181932,
      2,
      0.189872,
      3,
      1,
      1.688422,
      0,
      1,
      1,
      3,
      3.900306,
      1,
      0.962654,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2.391030,
      0,
      1,
      NULL,
      5.635016,
      0.022129,
      NULL,
      0,
      1,
      0,
      1,
      5.726619,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.517290,
      0,
      2.393017,
      2,
      5.170107,
      0.980199,
      NULL,
      8.251231,
      5.572209,
      0,
      1.237927,
      0,
      1.287493,
      5.719938,
      NULL,
      3,
      NULL,
      NULL,
      6.281128,
      7,
      8,
      NULL,
      NULL,
      NULL,
      6,
      6,
      2.518011,
      0.150254,
      ' 0-11-1990',
      NULL,
      NULL,
      1304,
      1,
      0.909604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000409,
      1,
      0,
      0,
      1.238963,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661403,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.013725,
      0.961241,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      3.855279,
      2.971164,
      5.375072,
      0.956441,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336520,
      0.327240,
      0,
      0.886193,
      0.984100,
      NULL,
      0.055596,
      NULL,
      1538,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590168,
      NULL,
      0,
      0,
      3,
      NULL,
      0,
      3,
      3.650439,
      0,
      3.327470,
      0.160557,
      NULL,
      2.709050,
      0.845485,
      NULL,
      0.921024,
      1.286672,
      1,
      1,
      1,
      1,
      1.826485,
      0.444198,
      NULL,
      1,
      0.384885,
      NULL,
      0.260692,
      1,
      1,
      0,
      2,
      NULL,
      2.746603,
      7,
      0.276175,
      5.791095,
      NULL,
      5.212851,
      2,
      2,
      3,
      34,
      3,
      0.398122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299587,
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '30304',
      '',
      NULL,
      2,
      NULL,
      186,
      0.764051,
      2,
      27.570804,
      10.655183,
      209.669153,
      8.420171,
      2,
      NULL,
      5,
      0.770467,
      NULL,
      NULL,
      3.310669,
      11,
      7.522003,
      2.294354,
      16,
      2.632000,
      1,
      19.289103,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294480,
      0,
      2.847122,
      1,
      12,
      17,
      3,
      0,
      2.337629,
      NULL,
      NULL,
      NULL,
      3.154791,
      0,
      NULL,
      13.348665,
      NULL,
      NULL,
      2,
      1.592229,
      5.762597,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      9,
      NULL,
      NULL,
      0.481859,
      17,
      9.290725,
      2.375350,
      0.370339,
      1.910841,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.767608,
      3.710870,
      2,
      NULL,
      19,
      NULL,
      NULL,
      1.414565,
      NULL,
      NULL,
      3.357866,
      12,
      NULL,
      0.569826,
      7.000053,
      1.015889,
      NULL,
      0.093873,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.599965,
      NULL,
      NULL,
      2.033894,
      NULL,
      NULL,
      3,
      0.677175,
      NULL,
      1,
      NULL,
      NULL,
      5.768775,
      1,
      NULL,
      2,
      0.931989,
      0.279390,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.503229,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.438464,
      NULL,
      NULL,
      0.485627,
      NULL,
      NULL,
      2,
      0.680041,
      2,
      3,
      6.510591,
      3.408829,
      NULL,
      NULL,
      NULL,
      7,
      3,
      6.628053,
      6.123697,
      1,
      NULL,
      1.636615,
      1,
      0.412196,
      3.649020,
      NULL,
      2.573594,
      3.417338,
      3,
      3,
      1,
      0,
      3.513395,
      NULL,
      NULL,
      1.151718,
      3,
      16.272494,
      3,
      1.168252,
      5.493099,
      3,
      3,
      19,
      NULL,
      7,
      0,
      3,
      NULL,
      1.833335,
      2,
      0.359102,
      NULL,
      5.170398,
      1.500328,
      1,
      0.054373,
      1.663302,
      1,
      1.388784,
      NULL,
      NULL,
      1.271071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821110,
      NULL,
      NULL,
      3.991899,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      10.572382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.620660,
      NULL,
      NULL,
      6.625094,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1,
      1.906352,
      0,
      NULL,
      1.149135,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652209,
      NULL,
      NULL,
      NULL,
      2.351134,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.307777,
      NULL,
      NULL,
      NULL,
      1.527019,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.956296,
      NULL,
      NULL,
      NULL,
      1.499683,
      NULL,
      NULL,
      NULL,
      3.144425,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      3.688095,
      3,
      5,
      5.359731,
      NULL,
      336,
      550.828796,
      1.928429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      0.949853,
      NULL,
      NULL,
      1.691655,
      NULL,
      0.240795,
      405.561710,
      0,
      1,
      NULL,
      0.564087,
      0.319790,
      1.083296,
      NULL,
      0,
      1,
      NULL,
      0.696624,
      0.613710,
      0.763638,
      1.640497,
      1.698592,
      NULL,
      0,
      0.833841,
      1,
      NULL,
      1.388651,
      NULL,
      1,
      NULL,
      1.941631,
      NULL,
      1.186852,
      NULL,
      1.618673,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.618686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763397,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.193929,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304132,
      1.769273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.906648,
      NULL,
      3.928472,
      NULL,
      155,
      NULL,
      0.366183,
      NULL,
      3.763761,
      NULL,
      NULL,
      0,
      0.493256,
      5,
      27.628352,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.879027,
      0,
      0.706368,
      5.216224,
      NULL,
      4,
      NULL,
      8.010989,
      3.949263,
      3,
      0.357812,
      1.611491,
      1.379322,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034651,
      NULL,
      NULL,
      1,
      1.936727,
      NULL,
      0.200090,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.523912,
      0.501066,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.733790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056210,
      1.242447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823123,
      NULL,
      0,
      NULL,
      0.281700,
      NULL,
      2,
      5,
      NULL,
      0.096071,
      0,
      0,
      36.349461,
      38,
      5.418431,
      NULL,
      7,
      '33142',
      '00320',
      '41400',
      NULL,
      '',
      '',
      '',
      2.385079,
      '20411',
      '0032',
      '');
commit;
end;
/


