set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7825293';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      '04',
      NULL,
      34,
      '0400111',
      0,
      1,
      2,
      1,
      '4112',
      2.625961,
      NULL,
      NULL,
      NULL,
      ' 1-27-2003',
      72.084639,
      55.194326,
      NULL,
      0,
      1,
      ' 2- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      3.474117,
      ' 0- 0-1999',
      ' 5-27-1981',
      ' 6-16-1980',
      2.555055,
      2,
      NULL,
      0.854574,
      1,
      0.963284,
      1,
      1,
      NULL,
      NULL,
      5,
      9,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2,
      NULL,
      NULL,
      1.121430,
      NULL,
      0.718589,
      0.592983,
      NULL,
      NULL,
      0,
      1.897298,
      NULL,
      73.562259,
      10,
      6,
      0,
      1.642042,
      0.773122,
      0,
      1.978848,
      1,
      1,
      1,
      0.898297,
      0,
      1.526344,
      0,
      0.674604,
      1.306305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744893,
      1,
      1.193854,
      0.397577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727665,
      1.125789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443724,
      0.140072,
      0,
      1,
      1.460161,
      0,
      1,
      0,
      0.603807,
      1,
      1.973485,
      1,
      0,
      NULL,
      0.150782,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.838660,
      NULL,
      1.427832,
      0,
      NULL,
      0.261478,
      NULL,
      5,
      1.324098,
      1,
      0.276175,
      0.155048,
      0.874766,
      NULL,
      NULL,
      2,
      0,
      1.317950,
      5,
      3,
      1.631226,
      4.999191,
      1,
      3,
      1.514292,
      0.296948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.306731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.795908,
      NULL,
      1.789520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981014,
      NULL,
      1.650183,
      NULL,
      NULL,
      0.881507,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.318874,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.429850,
      1,
      1.038791,
      2.821646,
      1.961463,
      0.444329,
      3,
      39.770911,
      0.373497,
      NULL,
      NULL,
      NULL,
      NULL,
      2.049086,
      NULL,
      2,
      1,
      0.558022,
      1.448613,
      1,
      0,
      3.642769,
      NULL,
      NULL,
      2.889204,
      1.849470,
      2.678559,
      1.866603,
      NULL,
      5,
      1,
      0.985026,
      1,
      1,
      1,
      NULL,
      1.607808,
      NULL,
      0,
      1.588204,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.608543,
      1,
      NULL,
      0,
      3.685296,
      1,
      4.495990,
      0.512876,
      2,
      0.583602,
      11.771208,
      1,
      2,
      58,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      '32401',
      '',
      '',
      0.517188,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.273751,
      6,
      49,
      34.474622,
      1.505079,
      5,
      15.037599,
      148,
      NULL,
      2,
      NULL,
      2,
      0.000720,
      NULL,
      NULL,
      NULL,
      3.216514,
      2,
      3.644388,
      1.280003,
      2.310376,
      3.661807,
      0.457551,
      0.814664,
      1.432960,
      NULL,
      NULL,
      NULL,
      1.102469,
      1,
      NULL,
      NULL,
      NULL,
      0.250722,
      NULL,
      NULL,
      0.836892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2.479034,
      0.325091,
      1,
      0.254997,
      2,
      1.522159,
      1,
      0,
      0.074498,
      2.579880,
      NULL,
      1.973439,
      NULL,
      NULL,
      1.262427,
      NULL,
      NULL,
      NULL,
      3,
      1.138426,
      2,
      3.604369,
      NULL,
      3,
      3.732172,
      0.682686,
      2.685458,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.729133,
      2,
      0,
      0.174569,
      NULL,
      NULL,
      NULL,
      2,
      0.813829,
      1,
      9.986332,
      5.460328,
      1,
      1,
      3.278081,
      2.138830,
      1,
      NULL,
      0.710316,
      2.830239,
      0.343513,
      3.296106,
      NULL,
      2.767314,
      0.258441,
      3,
      1,
      3,
      1.742798,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.010910,
      8,
      5.465868,
      0.622493,
      2.569251,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4.816500,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.995307,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.205805,
      NULL,
      NULL,
      NULL,
      3.420436,
      2.812298,
      0.244763,
      1,
      0.799174,
      NULL,
      NULL,
      2.500154,
      7.604809,
      1,
      2,
      NULL,
      3,
      0,
      2,
      3.859404,
      1,
      NULL,
      3,
      1.084187,
      3.521155,
      0.400834,
      0,
      2,
      7.254366,
      4.171192,
      1,
      0.246806,
      0,
      NULL,
      1,
      1,
      2.408609,
      NULL,
      1.883461,
      NULL,
      1.385635,
      NULL,
      6.714273,
      0,
      0.513917,
      1,
      5,
      0,
      1,
      6.613151,
      0.292168,
      2.719293,
      2,
      0.999731,
      NULL,
      2,
      0.617254,
      NULL,
      8,
      NULL,
      NULL,
      120.838184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      0.618351,
      1.297201,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      NULL,
      15.945048,
      5,
      NULL,
      15,
      3,
      2,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      7,
      0.110417,
      NULL,
      NULL,
      0,
      NULL,
      7.451911,
      NULL,
      1.255596,
      NULL,
      1.413175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.151629,
      NULL,
      2,
      NULL,
      NULL,
      1.406547,
      NULL,
      NULL,
      3.395449,
      0,
      0.806673,
      NULL,
      1.943204,
      0,
      0.243242,
      NULL,
      NULL,
      3.800860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.294250,
      NULL,
      2.163707,
      1,
      2.402897,
      NULL,
      3.182934,
      3,
      2.450545,
      NULL,
      NULL,
      NULL,
      0.662195,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.378747,
      1,
      NULL,
      9,
      8.681708,
      9,
      NULL,
      NULL,
      0.155278,
      3.244724,
      6.828147,
      3.563437,
      3,
      214.911626,
      131,
      NULL,
      124.161134,
      24.324902,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.520720,
      243,
      80.488930,
      0.777254,
      NULL,
      NULL,
      3.343432,
      24.471507,
      1.152769,
      471,
      19,
      1.603437,
      1,
      NULL,
      0.822834,
      1,
      1.334748,
      0,
      NULL,
      0.416516,
      1.088340,
      NULL,
      0,
      NULL,
      3.328616,
      NULL,
      1.577259,
      1.016565,
      NULL,
      NULL,
      1.593529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      16.473809,
      NULL,
      1.837268,
      9.737972,
      8,
      3,
      1.593626,
      NULL,
      NULL,
      0.246996,
      NULL,
      0.379853,
      NULL,
      0.307935,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.487772,
      NULL,
      1.336624,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.383641,
      NULL,
      1.657731,
      1.907138,
      NULL,
      1,
      NULL,
      1.471487,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.464631,
      NULL,
      1,
      NULL,
      0.851754,
      0.037144,
      0.586309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575441,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293598,
      NULL,
      NULL,
      0.068010,
      NULL,
      1.878931,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.084741,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671006,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657726,
      NULL,
      NULL,
      1.391264,
      NULL,
      0.974868,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.092898,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691064,
      NULL,
      5,
      4,
      2.835511,
      1,
      NULL,
      3,
      1,
      1,
      2,
      0.016035,
      1,
      0.193839,
      0.009209,
      1,
      0,
      1.669382,
      3,
      1,
      0,
      NULL,
      1.275877,
      1.548731,
      0.179677,
      1.973278,
      0.170534,
      0.951219,
      1,
      NULL,
      0.708609,
      NULL,
      0,
      1,
      1.013032,
      1,
      2,
      0,
      1,
      3,
      1,
      0,
      0,
      NULL,
      0,
      0.283278,
      0.531192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.279564,
      1.679276,
      0.038285,
      1,
      0.761206,
      5,
      8.829448,
      5.571880,
      3,
      0,
      2.577213,
      68,
      111.522386,
      NULL,
      0.273173,
      0,
      '31201',
      '41314',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


