set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206296';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '2422133',
      2.053651,
      1.844983,
      0,
      NULL,
      '3443',
      3.945663,
      0.840434,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      1,
      1,
      0.683976,
      NULL,
      NULL,
      NULL,
      225,
      78.256634,
      NULL,
      ' 1-22-2000',
      ' 9-20-1995',
      NULL,
      0,
      0.411778,
      2,
      0,
      1.825754,
      1,
      NULL,
      1,
      0.983736,
      15.913241,
      11,
      NULL,
      NULL,
      6,
      7.434856,
      0.371029,
      33,
      6,
      2,
      NULL,
      0,
      1,
      1.180909,
      NULL,
      NULL,
      0.108732,
      NULL,
      NULL,
      3,
      1,
      0.972224,
      3.405114,
      3.387014,
      5,
      NULL,
      0.769771,
      0.264311,
      2.080277,
      NULL,
      2.501472,
      1,
      2.144351,
      0,
      1.809769,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.211411,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059003,
      5.940979,
      2,
      3.023861,
      3.283190,
      NULL,
      3,
      1.423727,
      1.789969,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.997720,
      NULL,
      0.645658,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      3.160351,
      3.013886,
      1.125622,
      NULL,
      0.682959,
      NULL,
      6.080618,
      2.662936,
      1.533161,
      NULL,
      3,
      NULL,
      3,
      NULL,
      8.421982,
      0.844015,
      0,
      4,
      6.221792,
      4,
      4,
      NULL,
      8.538002,
      0.562051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531083,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.780375,
      1,
      1,
      1.722544,
      0,
      1.064225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.830991,
      NULL,
      25,
      NULL,
      0,
      0.091043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.554310,
      NULL,
      1,
      0,
      0.100179,
      NULL,
      NULL,
      0,
      NULL,
      1.377451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.787675,
      NULL,
      0,
      0,
      1.785030,
      1.637013,
      30,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.455406,
      NULL,
      3.896837,
      3,
      2.839431,
      3.753698,
      NULL,
      3,
      2,
      3,
      3,
      2.512625,
      NULL,
      0.220144,
      4,
      NULL,
      1.637647,
      NULL,
      2,
      1,
      1,
      NULL,
      1.856242,
      0,
      0,
      0.446744,
      1.906714,
      0,
      1.083430,
      0.957987,
      NULL,
      4,
      0.038840,
      NULL,
      7,
      0,
      3.412113,
      0,
      4.417017,
      1.175695,
      3.326725,
      3.676243,
      NULL,
      3,
      0.499851,
      NULL,
      90,
      NULL,
      41,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      3,
      '31304',
      '',
      '',
      1.521530,
      '',
      '',
      NULL,
      3.895999,
      39.275654,
      44,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.199344,
      0.372509,
      NULL,
      NULL,
      NULL,
      2,
      3.592638,
      1.085276,
      1,
      NULL,
      NULL,
      1.773976,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.399506,
      NULL,
      NULL,
      0.760354,
      NULL,
      NULL,
      6,
      0,
      1.194982,
      1.087239,
      1,
      NULL,
      NULL,
      NULL,
      1.145244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614010,
      NULL,
      NULL,
      0.060545,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.524309,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.652744,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.921697,
      0.417629,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104895,
      NULL,
      NULL,
      0.089583,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.043411,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.225071,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420015,
      2.410275,
      0.012744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.557758,
      3,
      2,
      NULL,
      NULL,
      2,
      7.412206,
      1,
      4.795647,
      3.773295,
      3.997277,
      0.983710,
      1,
      NULL,
      NULL,
      1.948020,
      NULL,
      NULL,
      3,
      1.589071,
      2.018349,
      0,
      1,
      2.700865,
      4,
      NULL,
      0,
      NULL,
      NULL,
      5.411611,
      0,
      1,
      NULL,
      1,
      1.471892,
      1,
      NULL,
      NULL,
      1.897743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.713605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.355371,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.624290,
      1.780439,
      1.847885,
      1,
      0.847402,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.866800,
      NULL,
      NULL,
      4.867020,
      NULL,
      NULL,
      NULL,
      2,
      2.796875,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.235254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201330,
      1.899802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923561,
      0.538411,
      NULL,
      NULL,
      1.536549,
      1,
      NULL,
      NULL,
      0,
      0.638073,
      NULL,
      NULL,
      0.860488,
      0.639834,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.026649,
      1.187176,
      NULL,
      NULL,
      0.394867,
      0.069006,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.328900,
      16.283599,
      NULL,
      0.275848,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.792323,
      NULL,
      NULL,
      1.008959,
      NULL,
      1,
      NULL,
      2,
      0.995711,
      1,
      1.245917,
      NULL,
      0,
      1.027545,
      1,
      0.029697,
      1,
      1.028533,
      NULL,
      0,
      1.816201,
      1,
      1.149386,
      1.892120,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.572854,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932465,
      0.527847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570329,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933686,
      3.956877,
      NULL,
      1.520260,
      NULL,
      0.179525,
      NULL,
      NULL,
      NULL,
      0.848626,
      NULL,
      1.196422,
      NULL,
      NULL,
      0.483032,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.069739,
      0.954619,
      2.356415,
      3.488856,
      0.311226,
      1,
      3.219087,
      3,
      1.049515,
      3,
      1,
      NULL,
      NULL,
      0,
      3.952623,
      0,
      0,
      2.268118,
      1,
      1.170062,
      1.628675,
      1,
      1,
      2,
      1.366048,
      1,
      0,
      0,
      3.488595,
      3,
      1,
      3.866153,
      2,
      3,
      1.091335,
      1.455232,
      0.046054,
      3.903644,
      1.939424,
      1.363579,
      1.508401,
      1,
      0.532416,
      NULL,
      3,
      0.523781,
      0.665315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.125423,
      1,
      0,
      NULL,
      0.826143,
      NULL,
      0.675681,
      NULL,
      3.408673,
      NULL,
      0.986341,
      NULL,
      0,
      NULL,
      1.321639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.826343,
      NULL,
      0.110799,
      NULL,
      0.933009,
      1,
      1.213689,
      NULL,
      1,
      NULL,
      0,
      1.513460,
      NULL,
      NULL,
      7.414597,
      3.492128,
      NULL,
      3,
      1.035453,
      2,
      NULL,
      126.934947,
      0.528933,
      1.308434,
      1.670874,
      '',
      '',
      '',
      0,
      '32300',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


