set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      '3303',
      2,
      0.685175,
      NULL,
      NULL,
      ' 8-17-1997',
      41,
      NULL,
      5.266585,
      NULL,
      1,
      ' 6- 1-1988',
      61,
      3.697465,
      279,
      NULL,
      0.489387,
      ' 9-11-1995',
      NULL,
      ' 2-12-1994',
      3,
      NULL,
      NULL,
      2.170262,
      0.019341,
      2,
      2,
      0.515567,
      1,
      44.391978,
      5,
      8.330567,
      2.099193,
      17.020211,
      11.164712,
      2.126054,
      17.741776,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0.980582,
      0.885582,
      NULL,
      5.976001,
      NULL,
      NULL,
      1.088056,
      NULL,
      NULL,
      1.107108,
      1,
      1.100745,
      2.364283,
      NULL,
      2.012994,
      0.795111,
      NULL,
      0.121849,
      3,
      4,
      0.777877,
      0.347922,
      3.033859,
      1.289154,
      0.438246,
      NULL,
      NULL,
      0.598922,
      NULL,
      NULL,
      8,
      3,
      3,
      3,
      0.952156,
      1.576241,
      1.071353,
      3.011916,
      1.215457,
      3,
      2,
      2.504477,
      2,
      NULL,
      NULL,
      1.135681,
      0,
      3.109243,
      1,
      1,
      1,
      0,
      1.387841,
      1,
      NULL,
      3.343159,
      0.722186,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0,
      4,
      6,
      0,
      8,
      3,
      2,
      0.043668,
      4,
      NULL,
      1,
      1.633705,
      0,
      0.862707,
      1.343405,
      0.874915,
      NULL,
      0,
      6,
      1,
      NULL,
      3,
      0,
      3.456912,
      NULL,
      5.335650,
      0,
      6,
      4,
      NULL,
      9.207427,
      6.640422,
      6,
      3,
      NULL,
      5.837825,
      4.645907,
      7,
      1,
      8,
      1.957312,
      3.531440,
      10,
      9.467205,
      0.382092,
      ' 9-17-1975',
      718,
      '11-29-1999',
      8,
      3,
      0.280141,
      1.967517,
      3.499153,
      1.596942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.501884,
      1.563229,
      0,
      0.003713,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867415,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.524993,
      9.812971,
      0.346181,
      NULL,
      NULL,
      NULL,
      1.695262,
      5,
      1.374700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.289060,
      0.884918,
      1.255983,
      NULL,
      1.995150,
      NULL,
      NULL,
      1.126419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.418789,
      1.167724,
      2,
      3.231197,
      1,
      3.339061,
      3.056721,
      NULL,
      3.735924,
      1,
      1,
      3.949645,
      0.944671,
      1.900223,
      3,
      0.560659,
      NULL,
      NULL,
      1.410221,
      0,
      1,
      1.989152,
      0,
      NULL,
      1.644140,
      1.706922,
      1,
      NULL,
      2.260824,
      0,
      1,
      3.222064,
      NULL,
      3.992879,
      4,
      NULL,
      2.048282,
      0,
      5.093062,
      1,
      0.172360,
      3,
      NULL,
      1,
      3.928275,
      NULL,
      22,
      15.947846,
      25,
      1,
      1.655305,
      3.659560,
      '41401',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      17,
      290.660986,
      27,
      3.948710,
      18,
      0.209081,
      85.861064,
      1,
      1,
      NULL,
      1,
      0.560152,
      NULL,
      NULL,
      0.954898,
      NULL,
      NULL,
      1.527579,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.643347,
      0,
      0,
      NULL,
      NULL,
      2.320653,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      8.830462,
      NULL,
      NULL,
      0.020633,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.711211,
      NULL,
      1.805358,
      3.865327,
      2,
      0.192033,
      NULL,
      1,
      2,
      0,
      3.855230,
      2,
      1.511474,
      0.851286,
      0,
      0,
      3,
      2,
      3,
      NULL,
      0.077588,
      3,
      NULL,
      3.666799,
      NULL,
      0.697361,
      NULL,
      NULL,
      1.437786,
      NULL,
      NULL,
      0.162701,
      NULL,
      NULL,
      5.880898,
      8.778786,
      NULL,
      1.731495,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281939,
      NULL,
      NULL,
      NULL,
      0,
      0.965190,
      0,
      1,
      1.467653,
      3.460781,
      NULL,
      0,
      1,
      1.127930,
      NULL,
      NULL,
      1,
      3,
      6.209843,
      1.182299,
      3,
      3.522254,
      0,
      NULL,
      NULL,
      NULL,
      3.233988,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.832409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.275495,
      1,
      NULL,
      2.940537,
      6.652052,
      NULL,
      4,
      0,
      7.265817,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.870390,
      2.912923,
      2.843182,
      NULL,
      3,
      NULL,
      2.411870,
      4,
      1.394407,
      7.791039,
      0,
      NULL,
      1.336414,
      0.890878,
      0.472947,
      3,
      NULL,
      3.017755,
      3.777767,
      1.137434,
      2,
      1,
      NULL,
      5,
      6.648445,
      8.979626,
      7,
      1,
      3,
      7,
      0.180423,
      0,
      1,
      NULL,
      0,
      NULL,
      2.888620,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582983,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.681453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.567956,
      NULL,
      NULL,
      1.918702,
      NULL,
      NULL,
      0,
      1,
      1.414217,
      1,
      NULL,
      0.998529,
      1,
      NULL,
      NULL,
      0.520162,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.176603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720804,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.519826,
      1,
      NULL,
      NULL,
      1.380631,
      1.051812,
      NULL,
      NULL,
      3,
      3.473282,
      NULL,
      NULL,
      0.186231,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457665,
      354.971942,
      NULL,
      NULL,
      37.838178,
      1.663612,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      155.108757,
      9.409817,
      1.203093,
      NULL,
      NULL,
      1.151349,
      8,
      1,
      15.877141,
      NULL,
      0.006646,
      1.058420,
      0.602398,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.940649,
      1,
      0.949983,
      1,
      NULL,
      1.770173,
      1,
      0.273198,
      1.952145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.907187,
      1.940592,
      1,
      2.433172,
      0.340040,
      NULL,
      NULL,
      1.821496,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.859480,
      NULL,
      0,
      3.921328,
      NULL,
      0,
      2,
      2,
      NULL,
      2.306636,
      1.228256,
      1.852358,
      1.489543,
      0.481928,
      2,
      1.189178,
      3.389853,
      1,
      NULL,
      1.307426,
      1.721499,
      1,
      2.029746,
      3.552492,
      NULL,
      1,
      3.837574,
      0,
      3,
      2.723262,
      0.007663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997539,
      NULL,
      0,
      NULL,
      1.340307,
      6.658763,
      13.235504,
      3,
      3.311723,
      0,
      0,
      8,
      0.867673,
      1,
      1.975696,
      0.719365,
      '23320',
      NULL,
      '14123',
      1.527541,
      '',
      NULL,
      '',
      3.038619,
      NULL,
      '',
      '');
commit;
end;
/


