set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '1011424',
      1.622299,
      0,
      2,
      1,
      '1402',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-13-1998',
      3,
      NULL,
      NULL,
      2,
      NULL,
      ' 5- 2-1996',
      34,
      NULL,
      229,
      NULL,
      NULL,
      ' 0-23-1997',
      ' 6-18-1997',
      ' 4- 4-2002',
      1,
      NULL,
      3.060996,
      0,
      0.902849,
      0,
      0,
      NULL,
      0.850743,
      13.481355,
      NULL,
      1.276305,
      1,
      15.739508,
      7.943456,
      9.778186,
      1,
      4.036217,
      2,
      3.929824,
      0.541491,
      NULL,
      0,
      0.494514,
      0,
      1,
      1.438500,
      13,
      1,
      0.375544,
      1,
      1,
      5,
      2.820498,
      0.017160,
      NULL,
      1,
      4.964880,
      NULL,
      1,
      5.215307,
      0.443628,
      3,
      NULL,
      NULL,
      0,
      1.398760,
      NULL,
      NULL,
      NULL,
      0.244417,
      NULL,
      1.557019,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      10,
      1.242328,
      0,
      3,
      1.891712,
      2,
      0.051142,
      1.190808,
      1,
      NULL,
      NULL,
      3,
      1.955478,
      0,
      1.201894,
      1.746795,
      0.898383,
      1,
      NULL,
      0.092164,
      0.667733,
      6.575663,
      NULL,
      5.105117,
      0,
      0.396811,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.516320,
      6,
      2,
      4,
      NULL,
      9,
      1,
      4,
      0,
      NULL,
      NULL,
      0,
      1.031945,
      5,
      2.080560,
      0.034451,
      3.068054,
      5.572117,
      1,
      NULL,
      NULL,
      4.655962,
      0.627228,
      0,
      NULL,
      1,
      7.218246,
      5,
      5.143066,
      1.604267,
      3.736451,
      1,
      7.808551,
      1,
      0,
      NULL,
      8.918752,
      3,
      9.692509,
      9,
      5,
      NULL,
      2.763369,
      1.080819,
      1.874184,
      7.371388,
      1.900260,
      ' 7-18-2000',
      384,
      ' 7-23-1990',
      64.819005,
      3.119421,
      3.861830,
      NULL,
      4.807075,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237287,
      NULL,
      2,
      1,
      0,
      4.676330,
      2,
      2.289059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.129707,
      NULL,
      399.110356,
      1.681586,
      3,
      0.550160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.494668,
      2,
      0.987326,
      0.889527,
      3.269557,
      1,
      7,
      0.744098,
      3.690590,
      5.899341,
      0,
      NULL,
      NULL,
      NULL,
      1.619588,
      4.459863,
      1.064700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983105,
      NULL,
      NULL,
      NULL,
      1.663609,
      NULL,
      0.628300,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761308,
      3.448005,
      0,
      1.351962,
      0.894844,
      3.578937,
      2,
      2.375059,
      NULL,
      0,
      2.301979,
      3.615369,
      3,
      2,
      0,
      NULL,
      3,
      9,
      0,
      1.190020,
      0.913279,
      1,
      1.113730,
      0.333509,
      0,
      0.607866,
      0.624410,
      2,
      0.898600,
      1.669604,
      3,
      8,
      4,
      8,
      6.204264,
      0.874234,
      1.022075,
      NULL,
      1.839086,
      2.581644,
      1,
      1.660607,
      35.490653,
      2,
      3.068141,
      NULL,
      21.288243,
      27.955634,
      67,
      2,
      0.407186,
      0.952522,
      '13022',
      NULL,
      '',
      1.521480,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      18.881758,
      55,
      37.434391,
      0.063883,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.553940,
      3.430817,
      0.607800,
      NULL,
      NULL,
      NULL,
      0,
      1.371785,
      1,
      NULL,
      NULL,
      2.023829,
      NULL,
      NULL,
      3,
      1.405497,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.540745,
      NULL,
      NULL,
      2.336696,
      0.778226,
      1.438613,
      2.475418,
      3,
      0.201053,
      0.043955,
      1.985503,
      1,
      5,
      0,
      2.643560,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656934,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.019353,
      NULL,
      NULL,
      0,
      1.916987,
      NULL,
      1,
      2.506489,
      1,
      NULL,
      2,
      1,
      1.285397,
      1,
      0.662898,
      0.860458,
      NULL,
      1,
      2.102133,
      0.746629,
      0.155784,
      0,
      1,
      1.728421,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354429,
      0.596293,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.383544,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0,
      0.597393,
      2.488691,
      9.871125,
      1.736484,
      0,
      2,
      1,
      4,
      1.766773,
      3.024512,
      0.352159,
      NULL,
      NULL,
      0.166799,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.388585,
      1.321091,
      1,
      2,
      1.984721,
      1,
      7,
      2,
      0.918305,
      2,
      NULL,
      NULL,
      3.675488,
      1,
      1,
      0.615277,
      3,
      3,
      NULL,
      0,
      0,
      3.207290,
      4,
      1.887515,
      2,
      NULL,
      2,
      2,
      0.989758,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191424,
      NULL,
      0,
      7.555653,
      5,
      3,
      3.687304,
      2.506551,
      2.656304,
      1,
      3.447458,
      3.301603,
      0.299105,
      0,
      1,
      1,
      1,
      3.241645,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.307142,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523096,
      NULL,
      NULL,
      1.401588,
      1.325925,
      NULL,
      1,
      1,
      2.987402,
      0.604554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.074430,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.547563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.874316,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670826,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5.990094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      0.277425,
      0,
      0,
      0.246841,
      NULL,
      NULL,
      0.303025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693108,
      NULL,
      NULL,
      1,
      NULL,
      0.671736,
      5037.835740,
      1.342944,
      1,
      0,
      NULL,
      NULL,
      0.116736,
      NULL,
      1.647564,
      1,
      NULL,
      0,
      1.386009,
      1.629324,
      0,
      1.583087,
      1,
      0.333914,
      1,
      0.463038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286778,
      NULL,
      NULL,
      3.984653,
      NULL,
      3.707072,
      2,
      NULL,
      6,
      3.290725,
      3,
      1.560859,
      1,
      0.684294,
      NULL,
      1.485728,
      NULL,
      NULL,
      2.164467,
      2,
      NULL,
      1.590059,
      0.735925,
      NULL,
      3.217107,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.592218,
      0.418477,
      NULL,
      1,
      NULL,
      NULL,
      3.356170,
      0.636450,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.617194,
      1.629327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024892,
      NULL,
      0,
      NULL,
      0.667563,
      NULL,
      2.318781,
      NULL,
      9.424429,
      0.019840,
      NULL,
      NULL,
      3.549710,
      NULL,
      7.486431,
      0.121193,
      NULL,
      '24232',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


