set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '43',
      23,
      32.758622,
      '3421212',
      NULL,
      1,
      6,
      1,
      '2302',
      2,
      0.397850,
      NULL,
      NULL,
      ' 7- 6-2000',
      NULL,
      NULL,
      NULL,
      3.313621,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 8- 6-2003',
      ' 3-11-1999',
      ' 4- 2-1978',
      3,
      0.876601,
      0.102847,
      2.883653,
      NULL,
      1.467739,
      6.733639,
      1.799963,
      0.386592,
      9,
      8,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1,
      4.334192,
      0.449127,
      1,
      NULL,
      1.999598,
      NULL,
      1.274045,
      2.279010,
      0,
      1.870877,
      1.984987,
      5.772440,
      5.923281,
      2,
      4,
      0,
      0,
      0,
      NULL,
      5,
      3,
      0,
      NULL,
      NULL,
      3,
      3,
      4.303189,
      1.641389,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      10.339635,
      11.020808,
      1.696382,
      NULL,
      1.495759,
      1.597791,
      1.136264,
      3,
      NULL,
      NULL,
      0,
      1,
      0.142520,
      1,
      2.669930,
      0,
      1.033612,
      1.789002,
      0.761847,
      NULL,
      1,
      NULL,
      NULL,
      4.260823,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519305,
      NULL,
      0.093147,
      1,
      NULL,
      0,
      NULL,
      1.555658,
      NULL,
      0,
      0.772422,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673001,
      1,
      0.774964,
      NULL,
      0.192825,
      NULL,
      0.201954,
      1.448486,
      0,
      1,
      5,
      5,
      NULL,
      5,
      NULL,
      1.627405,
      1.393358,
      NULL,
      7,
      2.519065,
      NULL,
      NULL,
      0.559895,
      NULL,
      2,
      2.553895,
      7.113771,
      1.101270,
      5.820031,
      4.605086,
      0.027175,
      3,
      NULL,
      30,
      ' 1- 7-2001',
      NULL,
      1.615083,
      0.991006,
      1.535628,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.669948,
      NULL,
      1.587830,
      0.800001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406804,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.263257,
      3,
      0.997463,
      1.907231,
      1,
      0.973497,
      1.094323,
      2,
      3.724146,
      3,
      2.641966,
      0.180820,
      NULL,
      NULL,
      NULL,
      0,
      5.111112,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.080483,
      1,
      1,
      0,
      0,
      1,
      0.203083,
      0,
      32.331338,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414499,
      0,
      1,
      0,
      2,
      1.293132,
      3.502876,
      NULL,
      NULL,
      NULL,
      3,
      1.091308,
      0.526588,
      0.507250,
      1,
      0.425491,
      NULL,
      NULL,
      NULL,
      2,
      0.920213,
      0,
      NULL,
      NULL,
      0.158612,
      0,
      0,
      0.199414,
      2,
      NULL,
      NULL,
      1.293310,
      2,
      7,
      0,
      NULL,
      NULL,
      6.353884,
      3,
      0,
      NULL,
      NULL,
      0.699465,
      2.272241,
      29.488803,
      2,
      3,
      61,
      NULL,
      48,
      21,
      0,
      5,
      1.106728,
      NULL,
      '41110',
      '',
      0,
      '',
      '',
      NULL,
      0.410064,
      NULL,
      NULL,
      '',
      3,
      9,
      6,
      42,
      NULL,
      48.290117,
      3.008601,
      NULL,
      NULL,
      0.886497,
      NULL,
      3,
      1.276576,
      NULL,
      NULL,
      0.228111,
      NULL,
      NULL,
      NULL,
      1.838529,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      2,
      0.828900,
      3.745675,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.686064,
      2,
      5.704342,
      0.560281,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763832,
      NULL,
      NULL,
      NULL,
      1.230828,
      2,
      2,
      1.004837,
      NULL,
      NULL,
      1,
      2.871746,
      0.255404,
      NULL,
      3,
      0,
      3.815379,
      2.375310,
      NULL,
      1.407084,
      0.732093,
      NULL,
      2.620602,
      NULL,
      1,
      1,
      NULL,
      0,
      1.404447,
      0.117585,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.301329,
      1,
      1,
      NULL,
      9.761819,
      9.082580,
      0.718729,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.059351,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.839847,
      5.700306,
      0.840635,
      NULL,
      NULL,
      0.153301,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.248681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.431036,
      2.188289,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.030950,
      NULL,
      1,
      2,
      NULL,
      1,
      7.921200,
      0.802423,
      NULL,
      NULL,
      0,
      1.779818,
      2,
      NULL,
      3,
      0.916023,
      5.638259,
      6.237922,
      NULL,
      0.914211,
      3.354037,
      0.581486,
      0.499924,
      NULL,
      2,
      0,
      1.324480,
      3.722192,
      2.811907,
      0,
      NULL,
      NULL,
      8.927383,
      1.812886,
      3.191695,
      2.723638,
      NULL,
      3,
      0,
      3.283256,
      1,
      NULL,
      0.307358,
      1.862783,
      NULL,
      1.004279,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463358,
      NULL,
      NULL,
      0.887022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.846567,
      NULL,
      NULL,
      1.363778,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.471190,
      1.479049,
      0.553029,
      1.129695,
      0.496425,
      2.917115,
      1.452204,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.171477,
      NULL,
      NULL,
      NULL,
      1.087574,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.854338,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.187055,
      NULL,
      NULL,
      NULL,
      2.174455,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      13.269750,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.220082,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.856390,
      0,
      NULL,
      1,
      0,
      0.381854,
      1.308670,
      NULL,
      0.377245,
      0.534747,
      1.127328,
      1.872135,
      0,
      1.857952,
      1,
      NULL,
      0,
      1.232189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646385,
      NULL,
      1.759395,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.056667,
      0.399507,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639397,
      3.708944,
      NULL,
      3,
      NULL,
      1.178038,
      NULL,
      282,
      NULL,
      0,
      NULL,
      2.797699,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.841366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.535257,
      NULL,
      1,
      NULL,
      0.166168,
      NULL,
      1.437588,
      1.650120,
      2,
      NULL,
      NULL,
      NULL,
      1.074922,
      NULL,
      4.413147,
      NULL,
      2.768104,
      NULL,
      1.572900,
      NULL,
      0.548164,
      0.609210,
      2.076639,
      2.080865,
      47.086826,
      0,
      NULL,
      NULL,
      NULL,
      1.586282,
      1,
      0.773253,
      NULL,
      1.350418,
      1,
      3,
      1.632186,
      5.851800,
      0.565019,
      NULL,
      1.341140,
      NULL,
      1.906556,
      NULL,
      1.977892,
      1.299692,
      NULL,
      0.614156,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1.408610,
      NULL,
      NULL,
      1.944341,
      NULL,
      NULL,
      1.349927,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.573992,
      NULL,
      0,
      0,
      NULL,
      1.205863,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.476964,
      NULL,
      0.870432,
      NULL,
      1.422865,
      NULL,
      4,
      9.014038,
      4,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.219906,
      0.955565,
      '24143',
      '23122',
      '',
      1,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


