set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7633982';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      3.909931,
      0.820181,
      1,
      NULL,
      '3431',
      1.426077,
      0.007655,
      NULL,
      NULL,
      ' 5-13-1989',
      62.864838,
      NULL,
      3.083778,
      0,
      1.558939,
      NULL,
      9,
      2,
      28.312332,
      89.840032,
      2,
      ' 9- 5-1993',
      ' 1-23-1989',
      ' 5-27-1998',
      0,
      1,
      3,
      1,
      1.161254,
      NULL,
      NULL,
      0,
      1.643600,
      208.194809,
      NULL,
      5.239261,
      13.723641,
      NULL,
      39,
      18.007213,
      10,
      1,
      NULL,
      1.209902,
      NULL,
      1,
      1.690815,
      NULL,
      1.756683,
      0.370906,
      1.429526,
      NULL,
      1,
      1.573173,
      187.177456,
      NULL,
      8.871129,
      7.703275,
      0,
      7,
      2,
      0,
      0.370911,
      2.523001,
      3,
      NULL,
      3.769250,
      2.248201,
      3.096548,
      0,
      0.627954,
      5.344122,
      1.118210,
      2,
      0.667856,
      NULL,
      1.325556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.554299,
      2.379496,
      NULL,
      NULL,
      NULL,
      1,
      1.561723,
      1,
      1,
      0.278112,
      1,
      0,
      1,
      1.996793,
      0,
      1.215992,
      NULL,
      1.129520,
      0.658353,
      NULL,
      1.744293,
      1,
      NULL,
      0,
      3.833880,
      0.905643,
      1.646899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.682912,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.842402,
      0,
      0.147711,
      0.678892,
      1,
      0,
      1,
      0,
      1.689034,
      1,
      0,
      1.954863,
      1.899871,
      NULL,
      1,
      8,
      0.352333,
      2.516782,
      2.061271,
      1.560202,
      10.237734,
      2,
      0,
      NULL,
      6,
      5.808606,
      4,
      1,
      1.679506,
      NULL,
      NULL,
      NULL,
      6.985677,
      2.618357,
      NULL,
      2,
      6.423130,
      6.723449,
      9,
      1.637177,
      NULL,
      0.180614,
      ' 8-23-1991',
      1327,
      NULL,
      1711.641711,
      1.714949,
      1,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.515582,
      1,
      0.543143,
      1,
      1.408372,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.402708,
      1,
      NULL,
      3.861013,
      1,
      1,
      0,
      NULL,
      NULL,
      2,
      0.498610,
      1,
      0,
      5.149385,
      3,
      1,
      3.734944,
      0,
      NULL,
      NULL,
      NULL,
      1,
      7.302217,
      0.873189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.617365,
      1.444084,
      1.513200,
      1.861989,
      1196,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      12,
      NULL,
      NULL,
      173,
      159.596767,
      168.977347,
      67.373336,
      175,
      1.886191,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      11,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.551137,
      NULL,
      11.380913,
      25.475829,
      44,
      3.919019,
      0.109901,
      NULL,
      NULL,
      '',
      '',
      0.706927,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.918210,
      35,
      276,
      17,
      1,
      39.245202,
      0,
      NULL,
      NULL,
      0.782024,
      0,
      1.570347,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.410528,
      3,
      1.371207,
      NULL,
      0.148439,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3.375400,
      NULL,
      3.143088,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.737413,
      0.388954,
      2.291942,
      1.438551,
      1,
      1.532737,
      NULL,
      NULL,
      3,
      9.841756,
      NULL,
      NULL,
      1.647509,
      NULL,
      NULL,
      NULL,
      3.828720,
      0.759152,
      3,
      1.384564,
      3.932421,
      1.035867,
      2,
      2.183786,
      1,
      3.180109,
      3,
      1,
      3,
      1.707869,
      1,
      2.911263,
      2,
      1,
      0,
      2.170921,
      NULL,
      0.035536,
      1,
      2.535777,
      0.334633,
      3.996465,
      NULL,
      NULL,
      3.084674,
      0,
      NULL,
      NULL,
      1.081243,
      NULL,
      NULL,
      1.014899,
      NULL,
      NULL,
      8,
      1.726118,
      7.166726,
      3.404315,
      1.623291,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      1.249886,
      NULL,
      NULL,
      NULL,
      0.948272,
      1.352474,
      0.494320,
      0.952448,
      1,
      1.296934,
      1,
      NULL,
      NULL,
      6,
      NULL,
      5,
      1.877920,
      NULL,
      3,
      1.052096,
      NULL,
      NULL,
      3,
      1,
      3,
      0.091101,
      NULL,
      NULL,
      1.179462,
      NULL,
      NULL,
      0.408390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.214699,
      1.994483,
      3.219867,
      0.244187,
      1.257074,
      0,
      7.846989,
      0,
      5.197972,
      6,
      1.141530,
      6.827035,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.135535,
      2,
      1.424719,
      3,
      3,
      1.327754,
      3,
      10,
      NULL,
      2.667996,
      3,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      0.530233,
      0,
      5,
      NULL,
      2,
      2,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      0.452825,
      0,
      1,
      2.257827,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.600587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.468666,
      2,
      NULL,
      1.920611,
      3.818663,
      0.777449,
      0.580845,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      148.845910,
      NULL,
      NULL,
      NULL,
      3.384997,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.504194,
      NULL,
      NULL,
      NULL,
      3.326977,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.056218,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      2.466948,
      NULL,
      NULL,
      0.924869,
      0.259628,
      NULL,
      NULL,
      0.043350,
      0.493646,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285771,
      NULL,
      NULL,
      1.240568,
      3,
      NULL,
      NULL,
      2.087944,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      7.546326,
      3.309074,
      NULL,
      0,
      9,
      2,
      173,
      90,
      1,
      142.049091,
      8.964893,
      0.159600,
      NULL,
      NULL,
      1.806234,
      18,
      1.682896,
      3,
      29.923668,
      13,
      0,
      NULL,
      NULL,
      0.500665,
      NULL,
      0.524558,
      188.451609,
      53,
      1.677247,
      0,
      1.069293,
      0,
      1.489967,
      1.340809,
      1.605493,
      1,
      NULL,
      1,
      0.191966,
      0,
      1,
      0,
      0.254730,
      0,
      0.670008,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558161,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815197,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446582,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.767057,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.839271,
      1.577011,
      3,
      0,
      1.895354,
      1,
      NULL,
      1,
      NULL,
      0.153953,
      2.707467,
      0.222624,
      0.543856,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.636651,
      NULL,
      NULL,
      1.436187,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.939996,
      1,
      NULL,
      1,
      0.465790,
      NULL,
      1.772522,
      3,
      NULL,
      1,
      1.948623,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.303288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364528,
      NULL,
      1.295775,
      NULL,
      0,
      NULL,
      7,
      NULL,
      4,
      NULL,
      1,
      0,
      67,
      NULL,
      2.344370,
      1.230691,
      1.816829,
      '01214',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


