set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2.526075,
      NULL,
      3.724722,
      2,
      4,
      0,
      NULL,
      '431',
      '40044214',
      29.101754,
      NULL,
      '2434034',
      0,
      1.474114,
      5,
      2,
      '3122',
      1.153506,
      1,
      NULL,
      NULL,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      3,
      ' 5-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-28-1994',
      ' 3- 5-1976',
      NULL,
      NULL,
      0.659333,
      NULL,
      2.152973,
      0,
      0,
      0,
      0,
      1,
      6.069267,
      0,
      14.220575,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.490116,
      NULL,
      0.187738,
      2.520753,
      0,
      0.889118,
      1.226583,
      1.417985,
      0,
      1.369616,
      1,
      NULL,
      0.685874,
      NULL,
      5,
      3,
      1.241585,
      7,
      1,
      0,
      6.075845,
      1.213741,
      0.654645,
      NULL,
      7.595698,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.842780,
      0.605479,
      NULL,
      NULL,
      NULL,
      1.613816,
      NULL,
      NULL,
      5,
      0,
      0.221906,
      3,
      1.590613,
      NULL,
      0,
      3.716828,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0.209387,
      1.518559,
      0.472987,
      0.208533,
      0.985786,
      6,
      NULL,
      3,
      1,
      3.040452,
      1,
      NULL,
      NULL,
      0.952345,
      NULL,
      NULL,
      NULL,
      1.794671,
      NULL,
      0,
      1.153375,
      6,
      2.517117,
      0,
      0.081051,
      0.343641,
      2.248860,
      2.459772,
      NULL,
      6.605991,
      0,
      1,
      0,
      1.479631,
      1.439471,
      NULL,
      1,
      0.085499,
      8,
      5,
      3.074916,
      NULL,
      7,
      0,
      3,
      1,
      0.455425,
      1.388892,
      3.263347,
      NULL,
      1.083656,
      3,
      6.764531,
      NULL,
      NULL,
      3.746938,
      4,
      NULL,
      2.265987,
      NULL,
      0,
      NULL,
      1.214542,
      2.876415,
      ' 4-16-1987',
      161,
      NULL,
      17,
      0.363496,
      0.366728,
      0.116823,
      NULL,
      0.990419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389950,
      0,
      1.329811,
      0,
      0.131224,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      3,
      2.273284,
      NULL,
      0,
      0,
      NULL,
      7.017988,
      NULL,
      2.724506,
      0,
      1.251576,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.162985,
      1.961969,
      2,
      19.967854,
      2,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.429753,
      3.571837,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.920893,
      2,
      4.587511,
      1.200039,
      0.865653,
      3.139903,
      1.624574,
      1.794007,
      1,
      1.551737,
      3,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1.919822,
      NULL,
      0,
      1.056983,
      2,
      NULL,
      9.892643,
      2.034996,
      0,
      9,
      3.944456,
      1.877961,
      2,
      NULL,
      5,
      0.848362,
      1.686889,
      2.692303,
      15,
      1,
      1,
      17,
      NULL,
      34.100122,
      79.853675,
      3,
      3.362196,
      3.649982,
      NULL,
      '41100',
      '',
      1.607645,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      8,
      NULL,
      0,
      25,
      3.455820,
      0.026625,
      2,
      0,
      NULL,
      1.822553,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.041952,
      3,
      1.134215,
      1.269129,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.609310,
      1.523909,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.593292,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0,
      1.369109,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.482104,
      0.555668,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.279476,
      1,
      1.444961,
      2,
      1.513511,
      1.195279,
      0,
      0.431400,
      0.458201,
      1.334083,
      2,
      0.883084,
      1.398351,
      0,
      3,
      NULL,
      0.332770,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.604687,
      0.812044,
      1.007410,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.971035,
      NULL,
      NULL,
      NULL,
      1.935841,
      NULL,
      NULL,
      NULL,
      1.325073,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042470,
      1,
      NULL,
      1.491042,
      NULL,
      1.925349,
      1.189919,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435000,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.594623,
      1,
      0.164030,
      3.482909,
      NULL,
      1.941203,
      7,
      0,
      0,
      2.717457,
      1,
      1.888883,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.074240,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.942937,
      0,
      2.662588,
      NULL,
      1,
      NULL,
      0.907577,
      NULL,
      0,
      1.460887,
      1,
      4.405151,
      0.889669,
      0.030212,
      NULL,
      1,
      1,
      NULL,
      2.793141,
      1,
      0,
      NULL,
      0,
      1.077444,
      0,
      1,
      NULL,
      NULL,
      0.646443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525174,
      NULL,
      NULL,
      0.510537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.703225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.463610,
      NULL,
      1.211206,
      1.854366,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115851,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.111801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.084592,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078298,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059623,
      NULL,
      NULL,
      1.774996,
      NULL,
      NULL,
      0,
      NULL,
      0.901053,
      160,
      6,
      1.808554,
      1,
      NULL,
      NULL,
      1.616946,
      0,
      0.154144,
      2.752420,
      1,
      0,
      0.787746,
      0,
      NULL,
      0.917520,
      1,
      1,
      0,
      3,
      NULL,
      0.148311,
      NULL,
      1.401329,
      NULL,
      NULL,
      NULL,
      0.175637,
      NULL,
      1.943170,
      NULL,
      24.815853,
      NULL,
      NULL,
      25.156167,
      25.455176,
      0,
      0,
      NULL,
      NULL,
      0.505715,
      NULL,
      0.162462,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.220344,
      NULL,
      0.225608,
      NULL,
      0.176520,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0.407071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.611290,
      NULL,
      1.188174,
      NULL,
      0.680431,
      NULL,
      7.215556,
      NULL,
      2.569869,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.543951,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.784183,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214234,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937097,
      1,
      NULL,
      1.436520,
      NULL,
      2.540547,
      NULL,
      93,
      NULL,
      3,
      NULL,
      0.614206,
      NULL,
      NULL,
      0.054718,
      NULL,
      22.678358,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.441240,
      2,
      2,
      NULL,
      NULL,
      3.388602,
      NULL,
      2,
      2.959653,
      NULL,
      0.394167,
      NULL,
      NULL,
      0.512788,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.165473,
      NULL,
      NULL,
      0.787207,
      NULL,
      1,
      0.340457,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1.768245,
      NULL,
      1.010081,
      NULL,
      NULL,
      1,
      1.269961,
      NULL,
      3.014732,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796835,
      NULL,
      1.528732,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.896872,
      NULL,
      NULL,
      47,
      NULL,
      3,
      4,
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


