set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0.444473,
      3.924377,
      2,
      3,
      0.443194,
      2.984843,
      1,
      '420',
      '42100300',
      54.328085,
      46,
      '1410021',
      0,
      1.920240,
      NULL,
      0,
      '2123',
      0.505455,
      1.798411,
      NULL,
      NULL,
      NULL,
      253,
      52.714790,
      NULL,
      0.620118,
      1.932936,
      ' 4- 6-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 0-24-1981',
      NULL,
      0.870677,
      3,
      NULL,
      NULL,
      0.733754,
      2.649844,
      3.349936,
      NULL,
      NULL,
      NULL,
      6.162112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.231726,
      0,
      1,
      0.396733,
      1.586850,
      0.922921,
      0.012052,
      1,
      0.492041,
      1,
      1.180106,
      1,
      1.738779,
      1.223966,
      0.427614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790875,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638387,
      NULL,
      1.685008,
      0.851161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.914863,
      0,
      1,
      1.294830,
      NULL,
      0.827608,
      0.619473,
      NULL,
      1,
      0.993763,
      1.439796,
      0.542763,
      NULL,
      1.924455,
      1.281451,
      NULL,
      1.953735,
      1,
      NULL,
      1.159307,
      0,
      1.722001,
      1.932057,
      NULL,
      0,
      0.400033,
      0.351431,
      1,
      1,
      0.967455,
      0,
      1,
      1.031515,
      0.923333,
      1,
      NULL,
      1.056595,
      0,
      1.963505,
      NULL,
      2.908806,
      0.996990,
      4.655959,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.936343,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.340105,
      0,
      0.881498,
      1.591325,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.423781,
      1.721024,
      3,
      0.928768,
      0.631838,
      NULL,
      0.250937,
      0.586190,
      0.826308,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525764,
      1.963397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.814025,
      1.412653,
      0.423837,
      0.987576,
      NULL,
      1,
      NULL,
      1.417840,
      0.609971,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.697140,
      0,
      1,
      4.976999,
      5,
      3.117153,
      NULL,
      7,
      5.819476,
      4.153515,
      NULL,
      5.325273,
      0.388555,
      3,
      1.541137,
      NULL,
      1,
      1,
      1.319969,
      1,
      0,
      1.263453,
      1.684739,
      NULL,
      1,
      1,
      1.154305,
      NULL,
      NULL,
      1,
      4.506389,
      5.205000,
      NULL,
      5,
      2.837738,
      NULL,
      0.423655,
      0.770187,
      NULL,
      1.636376,
      3,
      3,
      61,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.917018,
      4,
      '40101',
      '21210',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      3,
      22.534534,
      10,
      NULL,
      3.686378,
      35.324181,
      5,
      1.905637,
      2.156616,
      1,
      0,
      1.714818,
      0,
      NULL,
      NULL,
      1.076556,
      NULL,
      NULL,
      3.337825,
      3.130702,
      1,
      1,
      NULL,
      NULL,
      0.830223,
      NULL,
      NULL,
      0.057092,
      0.379021,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.299772,
      NULL,
      NULL,
      0.845914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.887132,
      0.936294,
      2.640878,
      0.273078,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115730,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480378,
      NULL,
      NULL,
      1,
      1.614510,
      0,
      3.529085,
      1,
      0,
      3.821075,
      1.893815,
      1.097049,
      0,
      1.591182,
      NULL,
      0,
      3.046984,
      0.045734,
      3.487965,
      0,
      NULL,
      NULL,
      0.063658,
      NULL,
      NULL,
      3.981223,
      NULL,
      NULL,
      3,
      3.274653,
      2.942981,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.883940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737003,
      0.800296,
      1.577001,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2.838335,
      NULL,
      2,
      3,
      0.869392,
      1,
      0.424756,
      NULL,
      NULL,
      3.946854,
      1.806865,
      1.134326,
      NULL,
      NULL,
      NULL,
      1.677570,
      NULL,
      NULL,
      1.968569,
      NULL,
      NULL,
      0.616081,
      NULL,
      NULL,
      0.725144,
      NULL,
      NULL,
      1.277819,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      NULL,
      7,
      0,
      0.208386,
      1,
      NULL,
      NULL,
      0.963759,
      NULL,
      NULL,
      1,
      0,
      1.414027,
      1,
      NULL,
      1,
      2.965689,
      0.875523,
      1.468175,
      0.140763,
      1,
      NULL,
      3.768369,
      0,
      1,
      NULL,
      NULL,
      0.991055,
      1,
      NULL,
      1.907825,
      1.219122,
      0,
      0.573466,
      0,
      1,
      1.691337,
      NULL,
      0.202237,
      1,
      3.614849,
      0.660974,
      2.379203,
      NULL,
      0.700961,
      1,
      0.681702,
      NULL,
      1.165350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.827180,
      NULL,
      NULL,
      0.157902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222986,
      1,
      1,
      0,
      1,
      3.742903,
      3.335489,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740445,
      1.223311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.370653,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.512854,
      1.457010,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.892530,
      0.024714,
      NULL,
      NULL,
      NULL,
      0.835542,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.417401,
      1.247086,
      NULL,
      NULL,
      3,
      3.148550,
      NULL,
      NULL,
      0.342243,
      NULL,
      NULL,
      NULL,
      1.188110,
      0.019384,
      NULL,
      NULL,
      1.691769,
      0.063703,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.561990,
      0.007549,
      0.740458,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.410654,
      136.337453,
      NULL,
      NULL,
      1.903072,
      NULL,
      1,
      0.243738,
      NULL,
      1.287466,
      0.129890,
      0,
      NULL,
      1.091795,
      NULL,
      0.120657,
      1,
      1,
      NULL,
      1,
      3.061535,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.538280,
      NULL,
      1.390087,
      NULL,
      3,
      NULL,
      80.350138,
      NULL,
      0,
      17.892295,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.405583,
      NULL,
      0.914135,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.334600,
      NULL,
      0,
      NULL,
      1.059898,
      NULL,
      1,
      NULL,
      1.540547,
      1.757156,
      1,
      0.623054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337557,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.677099,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.365669,
      NULL,
      0.712760,
      NULL,
      0.537848,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      95.351863,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178381,
      0,
      0.536070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.182599,
      NULL,
      364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770119,
      1,
      0.307506,
      4.999819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.630918,
      2,
      4.517527,
      1,
      3.736971,
      NULL,
      2.579074,
      2,
      2,
      1,
      2.621366,
      NULL,
      0,
      0.099057,
      NULL,
      0.001639,
      2.631125,
      0,
      0,
      2,
      0,
      0.009940,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.488738,
      1,
      1.483899,
      1.630209,
      NULL,
      1.732801,
      0,
      NULL,
      0,
      1,
      0,
      1.033193,
      0,
      0,
      0.519216,
      3.487884,
      1.100887,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504676,
      0.727303,
      0.752814,
      0.726933,
      NULL,
      3,
      7,
      2.515667,
      1,
      NULL,
      NULL,
      NULL,
      7.771821,
      3,
      4,
      2,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


