set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3000312',
      2,
      1,
      0,
      2,
      NULL,
      1.571755,
      1.137778,
      NULL,
      NULL,
      ' 6-17-1999',
      17.764671,
      NULL,
      0.123396,
      0.452888,
      0.302751,
      NULL,
      41.017690,
      2,
      157.915679,
      42,
      1,
      NULL,
      NULL,
      ' 5-21-1978',
      1.666594,
      3.568789,
      NULL,
      2,
      0,
      NULL,
      3.412495,
      1,
      1.153460,
      2.635532,
      3,
      NULL,
      5.961356,
      8,
      18.294976,
      6.099466,
      25.883494,
      3,
      1,
      NULL,
      1,
      0.296842,
      1,
      1,
      1.313941,
      1,
      0.321965,
      1,
      1,
      NULL,
      44.596272,
      10.625523,
      NULL,
      NULL,
      1,
      1,
      0.639965,
      1.493769,
      0.037368,
      0,
      NULL,
      NULL,
      NULL,
      0.204121,
      0,
      1,
      1,
      2.003599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521193,
      3.368117,
      1.392368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.688119,
      2.098567,
      NULL,
      NULL,
      1.373679,
      0,
      NULL,
      0.179033,
      0.987513,
      1,
      1.392696,
      0.146731,
      0,
      0,
      1.112538,
      1,
      1,
      NULL,
      NULL,
      1.012869,
      0.666612,
      0,
      0.096340,
      0,
      NULL,
      1.533960,
      1,
      0,
      1.437044,
      3,
      0.368023,
      NULL,
      2,
      2,
      6.212428,
      9,
      0.806695,
      0.137157,
      3,
      2,
      4.691364,
      NULL,
      7,
      1.778391,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.554758,
      3,
      0.603740,
      0.741272,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.809648,
      NULL,
      1.528406,
      2.678248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.171756,
      1.222428,
      1.651628,
      1.524661,
      0,
      0,
      1.508220,
      3,
      0.834602,
      NULL,
      5,
      1,
      3.422712,
      0.962389,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.075132,
      0,
      0,
      1.736873,
      0.999914,
      0.952053,
      1.309810,
      23,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.098967,
      1.872587,
      1.760015,
      3.462000,
      5.460503,
      2,
      3.739182,
      4.743942,
      2.440664,
      0.451770,
      3,
      4.180200,
      0.780082,
      7,
      0,
      1,
      0,
      0,
      0.892541,
      1.619989,
      0,
      1,
      1,
      0,
      0,
      1.076065,
      2.666088,
      5,
      0,
      11.216518,
      8,
      3,
      11,
      3.192105,
      5.471048,
      NULL,
      1.899531,
      3.286554,
      0,
      0.948490,
      0,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      58,
      2,
      3,
      NULL,
      '32410',
      '01041',
      NULL,
      1,
      '22031',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      5.346137,
      1,
      40,
      3,
      1.642490,
      NULL,
      0,
      2.830049,
      1.788868,
      3.380383,
      1.460410,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292849,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.062817,
      1.373214,
      2.894564,
      0.437987,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.593683,
      1,
      2,
      NULL,
      1,
      0.498569,
      3.900344,
      NULL,
      0.318568,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953271,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810742,
      1,
      0.727957,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.428288,
      NULL,
      NULL,
      3.350386,
      0.927772,
      1.328763,
      1,
      1.977112,
      NULL,
      NULL,
      0.442726,
      1,
      NULL,
      0,
      0,
      0,
      0,
      3.091051,
      1,
      1.889628,
      NULL,
      NULL,
      1.673327,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.158589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.416587,
      2,
      2.744364,
      0,
      17.070964,
      NULL,
      NULL,
      NULL,
      8.399013,
      3,
      3,
      0,
      1,
      0,
      2.585864,
      3.374526,
      4.144284,
      4,
      3,
      1.726260,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.051095,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      6,
      5,
      4,
      2,
      5,
      3,
      NULL,
      NULL,
      2,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      1,
      7.018866,
      4,
      1.848026,
      0,
      2,
      NULL,
      3,
      0,
      0,
      2.805409,
      1,
      1.787144,
      0.549170,
      1.703356,
      NULL,
      1.264457,
      3,
      1,
      NULL,
      NULL,
      0.461124,
      5.531868,
      0.476184,
      NULL,
      1,
      0.530548,
      1.986153,
      0,
      0.713022,
      NULL,
      NULL,
      5.836298,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      2.101520,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.934015,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.973142,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747469,
      NULL,
      1,
      NULL,
      1.534961,
      2.920962,
      NULL,
      NULL,
      NULL,
      1.001040,
      1.219177,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      12.045151,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.847856,
      NULL,
      NULL,
      0.033290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.810924,
      NULL,
      NULL,
      NULL,
      3.957423,
      1,
      NULL,
      NULL,
      1.279794,
      NULL,
      NULL,
      NULL,
      NULL,
      3.339044,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.293777,
      3.948381,
      NULL,
      NULL,
      0.335760,
      3.876394,
      NULL,
      NULL,
      1.174728,
      2,
      NULL,
      NULL,
      5.117899,
      6,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      3.304284,
      9,
      NULL,
      0,
      NULL,
      2.188778,
      1.704301,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.143992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      3,
      NULL,
      NULL,
      0,
      1.845757,
      1.028134,
      1,
      NULL,
      1,
      1.295133,
      1.308770,
      0.483465,
      1.539670,
      1,
      1.025113,
      1.097996,
      0,
      1.595600,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.701298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444168,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2.229361,
      NULL,
      2.207184,
      NULL,
      68,
      NULL,
      0.938488,
      NULL,
      3.716481,
      NULL,
      1.014370,
      NULL,
      0.519566,
      1.105231,
      1.105239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353099,
      2,
      26,
      21.988404,
      1.335115,
      NULL,
      NULL,
      NULL,
      1.225821,
      3.780928,
      1.264910,
      0,
      0,
      1,
      NULL,
      0.767050,
      2,
      2,
      3.777570,
      1,
      0.871829,
      0,
      0.364725,
      NULL,
      2.512710,
      2,
      NULL,
      1,
      NULL,
      1.093417,
      0,
      1,
      1,
      1,
      NULL,
      0,
      2,
      0.049455,
      1,
      NULL,
      2,
      0.160730,
      1,
      0.031365,
      NULL,
      0.949139,
      3.666819,
      0,
      NULL,
      3.696538,
      0,
      1.966219,
      1,
      3.620535,
      1.807371,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0.718712,
      5.659704,
      NULL,
      NULL,
      NULL,
      27,
      100,
      3,
      NULL,
      NULL,
      '00000',
      '32300',
      NULL,
      1.408945,
      NULL,
      '',
      NULL,
      1.642236,
      '',
      NULL,
      '');
commit;
end;
/


