set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8121184';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0211232',
      3.548347,
      0,
      3,
      3,
      NULL,
      0.885519,
      3.973698,
      1,
      2,
      ' 5-20-2000',
      2.782507,
      NULL,
      4,
      3.649313,
      1.371678,
      ' 1-14-1994',
      20,
      NULL,
      155,
      73.355612,
      0.379926,
      '11-29-2000',
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      0.986093,
      1.084649,
      2.210201,
      2,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      21,
      3,
      35,
      2.978482,
      2,
      1.523444,
      NULL,
      NULL,
      0,
      1,
      0.987278,
      0.236699,
      0,
      0,
      0.730495,
      11,
      NULL,
      0,
      3.648359,
      6.705843,
      0,
      0.485559,
      1,
      1.473006,
      0.894311,
      6.789043,
      0,
      0.455969,
      1,
      NULL,
      1.091719,
      0.047201,
      0.973450,
      3,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.420830,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878028,
      0,
      1,
      NULL,
      NULL,
      1.736555,
      1.593540,
      NULL,
      1,
      0.855707,
      NULL,
      0.152833,
      NULL,
      0.401573,
      2,
      3.926416,
      1.957223,
      1.530608,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.639323,
      NULL,
      0,
      2.225508,
      NULL,
      NULL,
      2,
      7.013637,
      0.325802,
      3.073375,
      5.298651,
      0.507148,
      NULL,
      3.370499,
      7.314270,
      6,
      3,
      0.903120,
      NULL,
      3.833219,
      3,
      5.328394,
      NULL,
      1,
      3.790619,
      '10-27-1974',
      394.206770,
      ' 9- 4-2002',
      NULL,
      0.822185,
      1,
      0.898817,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910646,
      NULL,
      0,
      0,
      1,
      0.432159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.127808,
      7,
      NULL,
      3.425959,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      0,
      0.408555,
      NULL,
      NULL,
      NULL,
      NULL,
      2.488444,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      0.294791,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.073723,
      3.720837,
      1.915047,
      3.538691,
      NULL,
      NULL,
      0.396992,
      1,
      1.917022,
      NULL,
      2,
      2,
      5,
      0.482693,
      5,
      1,
      0.652045,
      0.803198,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.423026,
      1,
      0.627255,
      NULL,
      1.377356,
      NULL,
      0.441778,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5.486826,
      NULL,
      1,
      2.392840,
      0,
      1.355016,
      33,
      3.706006,
      3,
      NULL,
      59,
      49.331563,
      44.913783,
      NULL,
      0.862919,
      2.471325,
      '04220',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      4,
      NULL,
      NULL,
      0,
      NULL,
      13,
      NULL,
      2,
      0,
      0,
      0.966007,
      1.702716,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.735932,
      3.645113,
      0.570796,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.541972,
      NULL,
      1,
      3,
      NULL,
      1.391950,
      1.713560,
      2,
      0.686765,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.307999,
      NULL,
      NULL,
      NULL,
      3.941122,
      3.001313,
      1.350772,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.637654,
      NULL,
      0,
      0,
      1,
      1,
      1.920317,
      0.972539,
      0,
      1,
      0,
      0.847500,
      0.772565,
      NULL,
      0.931549,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401265,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.570663,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504844,
      0,
      3,
      2.002850,
      3.791723,
      1.126794,
      1,
      2.195609,
      1,
      1.599136,
      7.112772,
      7,
      NULL,
      3,
      0.436462,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.408545,
      0,
      0,
      3.534795,
      0,
      11.847372,
      NULL,
      NULL,
      0.868836,
      2,
      3.849202,
      7.613371,
      NULL,
      NULL,
      NULL,
      3.147097,
      0.901158,
      NULL,
      0.662540,
      3.351990,
      0.889031,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445635,
      NULL,
      NULL,
      2.472226,
      2,
      NULL,
      NULL,
      0,
      0.935924,
      0,
      0.033638,
      1.063967,
      2.232839,
      3,
      1.651239,
      NULL,
      1.810420,
      5,
      2,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.395591,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      7.944460,
      6.387464,
      1,
      NULL,
      1.512127,
      1.267383,
      2.287607,
      7,
      3.577796,
      NULL,
      0.888583,
      1.664916,
      0,
      1,
      2,
      NULL,
      NULL,
      0.246947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628843,
      NULL,
      NULL,
      1.402198,
      NULL,
      NULL,
      0.748982,
      0,
      0.562170,
      1.573698,
      1.630035,
      2,
      NULL,
      NULL,
      NULL,
      3.298947,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.395195,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941072,
      NULL,
      NULL,
      NULL,
      0.043036,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.837194,
      NULL,
      NULL,
      NULL,
      3.434497,
      1,
      NULL,
      NULL,
      0.102451,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.928531,
      1,
      NULL,
      NULL,
      1.998903,
      0,
      NULL,
      NULL,
      1.535385,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      33.914321,
      0.158602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.115460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602136,
      NULL,
      0,
      87,
      2.696230,
      NULL,
      0.613726,
      0.132112,
      0,
      NULL,
      0,
      0.768607,
      1.905529,
      0.720720,
      NULL,
      1,
      0,
      0.374452,
      1.425669,
      0.848440,
      1.262962,
      1,
      0.496698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.791187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567254,
      0.597270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.090716,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490622,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882988,
      0.781990,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.949208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664716,
      2.621542,
      NULL,
      NULL,
      NULL,
      3.194390,
      0,
      0,
      NULL,
      3.637508,
      3,
      NULL,
      1.641929,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1.401098,
      NULL,
      NULL,
      0.035286,
      1.172345,
      NULL,
      15,
      1.929327,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      3.337694,
      NULL,
      0.202189,
      1.979413,
      1,
      NULL,
      1,
      0.407010,
      3,
      NULL,
      0.340552,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705097,
      1.354199,
      1.399406,
      NULL,
      1.407305,
      0,
      7.084406,
      2,
      9.898070,
      3,
      0,
      1,
      NULL,
      50,
      NULL,
      0.371710,
      2.722877,
      '10431',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


