set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912456';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      3.429072,
      NULL,
      NULL,
      NULL,
      ' 8-14-1980',
      13,
      NULL,
      3.598492,
      0.851388,
      1.955948,
      '11- 0-1979',
      73,
      0,
      74,
      17,
      NULL,
      ' 7-25-1988',
      ' 1-28-1979',
      ' 0-10-1976',
      2,
      NULL,
      0.113800,
      3,
      NULL,
      NULL,
      6,
      1.030709,
      0.487160,
      116.678803,
      1.713890,
      NULL,
      0,
      NULL,
      5,
      NULL,
      NULL,
      5,
      2.778970,
      9.428403,
      NULL,
      2.634073,
      1,
      1,
      1,
      NULL,
      1.686013,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.893947,
      0.253992,
      NULL,
      5,
      1,
      1,
      0.810559,
      3.724590,
      0,
      7,
      1.016755,
      4.710707,
      NULL,
      3,
      1,
      NULL,
      1,
      2,
      1.897131,
      NULL,
      1.558124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4,
      0,
      0,
      1,
      1.655133,
      3,
      1.554414,
      2,
      1,
      0.812409,
      NULL,
      2,
      2.037978,
      0.041733,
      0.608880,
      3.015483,
      1.654069,
      0.614243,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.793950,
      NULL,
      NULL,
      0,
      1.068194,
      NULL,
      0,
      NULL,
      NULL,
      0.425140,
      0.933994,
      0.262202,
      0.991093,
      1.409803,
      1.469222,
      1.864021,
      NULL,
      0,
      NULL,
      NULL,
      0.142060,
      1.464960,
      NULL,
      0.121134,
      1,
      2.605334,
      0.100684,
      1,
      0.161163,
      3,
      4,
      NULL,
      2,
      NULL,
      1.388985,
      1.315323,
      0,
      1,
      2,
      3,
      2.304187,
      3,
      4,
      5,
      1,
      7.002991,
      9,
      5,
      0,
      5,
      NULL,
      NULL,
      960.863089,
      ' 7-10-1992',
      1140,
      0.171865,
      NULL,
      1.538640,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749797,
      0.505028,
      1,
      NULL,
      1.867489,
      1,
      0.354416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.140541,
      1.465612,
      1,
      1.402916,
      1,
      0,
      0,
      0.010687,
      0.437872,
      3.869591,
      5.753225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.990039,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.548312,
      0.945723,
      1.399283,
      0.457344,
      0.405033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.230607,
      1,
      NULL,
      2.142408,
      0,
      1,
      0.686739,
      NULL,
      2,
      NULL,
      0.576016,
      1.631324,
      2,
      NULL,
      NULL,
      0,
      1.239157,
      NULL,
      0.907609,
      3,
      1,
      NULL,
      0.999833,
      0.156925,
      1.159380,
      NULL,
      NULL,
      0,
      3.022956,
      0.978579,
      3,
      1.777794,
      NULL,
      10,
      NULL,
      9.819096,
      4,
      3,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      48,
      3.932459,
      1,
      NULL,
      20,
      NULL,
      74.315770,
      NULL,
      0,
      1,
      '22220',
      '',
      '',
      1,
      '',
      '',
      '',
      3.411326,
      '34421',
      '2104',
      '',
      1,
      7,
      176.698897,
      21,
      1.052976,
      2.014924,
      3,
      10.101503,
      0.382383,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.203217,
      NULL,
      3.036661,
      0,
      NULL,
      NULL,
      0.164020,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.083974,
      0.735073,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.296448,
      8,
      6,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.960362,
      3,
      NULL,
      NULL,
      0.217034,
      NULL,
      0.362012,
      NULL,
      NULL,
      2.678790,
      1,
      0,
      1,
      NULL,
      1.837904,
      0.592597,
      NULL,
      1,
      2.027488,
      1,
      0.666449,
      1,
      3,
      1,
      1.280600,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.369735,
      NULL,
      NULL,
      10,
      4,
      1,
      1.286144,
      1.272357,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.624125,
      NULL,
      1.994926,
      0,
      3.571618,
      0.187561,
      1.089495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.339014,
      1,
      NULL,
      0.556600,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.902279,
      1.152392,
      NULL,
      NULL,
      0.350239,
      NULL,
      NULL,
      0.918986,
      NULL,
      NULL,
      1.555820,
      NULL,
      NULL,
      0.363202,
      NULL,
      NULL,
      1.982805,
      NULL,
      NULL,
      3,
      NULL,
      1.785877,
      3,
      1,
      NULL,
      5.589617,
      4,
      1,
      3.301699,
      7.339395,
      3,
      0,
      1.633591,
      1.236079,
      0.872862,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      2,
      1,
      NULL,
      1.691923,
      0,
      2,
      0.551504,
      1.070214,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.962602,
      2,
      5,
      6,
      NULL,
      4,
      3.721488,
      2,
      3,
      2,
      0,
      0,
      0.140641,
      1.765501,
      1.942225,
      0,
      NULL,
      NULL,
      1.211416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.443772,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.315983,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.917386,
      NULL,
      NULL,
      1,
      1.301430,
      1.228447,
      NULL,
      NULL,
      0.407020,
      1.055985,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020479,
      NULL,
      NULL,
      NULL,
      1.655350,
      NULL,
      NULL,
      NULL,
      0.057136,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523918,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.439051,
      NULL,
      NULL,
      NULL,
      3.199080,
      127.236545,
      142,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.599147,
      NULL,
      0.065686,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1.169524,
      1.445035,
      1.210021,
      1,
      1,
      0.974090,
      0.244895,
      0,
      0.692454,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      4.223721,
      5.720270,
      18,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      0.367237,
      0.822680,
      NULL,
      1,
      0.110006,
      NULL,
      1.006935,
      NULL,
      NULL,
      0.569582,
      NULL,
      NULL,
      NULL,
      0.274317,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.302941,
      0.464384,
      NULL,
      3.534074,
      2.978648,
      NULL,
      0.078772,
      0,
      NULL,
      3,
      NULL,
      0.884359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.174985,
      7.937325,
      NULL,
      3,
      0,
      NULL,
      88,
      NULL,
      NULL,
      1,
      0,
      '11342',
      '',
      '',
      1.842210,
      NULL,
      '',
      '',
      2,
      NULL,
      '2130',
      '');
commit;
end;
/


