set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9607352';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '0400123',
      3.063798,
      0.450295,
      1,
      2,
      '2024',
      NULL,
      1,
      NULL,
      NULL,
      ' 9- 1-2003',
      26,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11.333974,
      2.229061,
      149,
      114,
      1.656079,
      NULL,
      '11-26-1976',
      ' 4-19-1999',
      2,
      NULL,
      0.906139,
      3.549523,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      22,
      14,
      5.730509,
      14,
      NULL,
      2.604568,
      2,
      0,
      0.188384,
      3.658997,
      1.537607,
      1,
      0,
      0,
      NULL,
      1.549184,
      3,
      0.681889,
      NULL,
      NULL,
      8.114236,
      2,
      4.744929,
      1.675140,
      0,
      NULL,
      1,
      0.805598,
      0,
      NULL,
      4.577723,
      1,
      1.547408,
      3,
      1,
      1.236097,
      2.276386,
      0,
      1,
      0.789322,
      NULL,
      NULL,
      0.054496,
      NULL,
      NULL,
      7,
      0.522729,
      1,
      2.411106,
      NULL,
      0.608762,
      0,
      1.855885,
      0,
      NULL,
      0,
      1,
      1,
      2,
      1.605871,
      1,
      0.832837,
      1.340751,
      1.806909,
      0,
      4,
      5,
      4.193023,
      1.136631,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.636533,
      NULL,
      NULL,
      1.008570,
      1,
      0,
      NULL,
      0,
      NULL,
      5.698050,
      1.687289,
      NULL,
      4.866585,
      1.182979,
      1,
      0.527756,
      3.768343,
      0.505338,
      1.602829,
      1,
      1.006787,
      1.639031,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.279146,
      3.558934,
      0,
      2,
      0.784466,
      0,
      NULL,
      0.349094,
      1.972908,
      5,
      1,
      0.085059,
      1,
      1,
      5.758944,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      2.597034,
      1.196419,
      ' 8- 4-2000',
      109.320855,
      NULL,
      1.131439,
      0,
      0,
      1,
      0.407679,
      0.775167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.476290,
      0.881344,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.290390,
      NULL,
      8,
      NULL,
      3.922828,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.370521,
      3.707931,
      0.804667,
      1.556234,
      1,
      0,
      NULL,
      4,
      5.203061,
      NULL,
      5,
      0.252207,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.456000,
      0,
      1.043241,
      0.000387,
      0.839095,
      6,
      2.906304,
      1.544749,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982395,
      3.131203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.375897,
      NULL,
      NULL,
      1.825807,
      3.792757,
      3,
      2.266555,
      2,
      1.869866,
      0.585177,
      0,
      2.360501,
      0,
      0.944825,
      1.190002,
      1,
      0,
      NULL,
      1.062609,
      NULL,
      NULL,
      0,
      3.693401,
      0,
      2.361473,
      3.507896,
      0,
      3.558325,
      6.469985,
      NULL,
      0,
      0,
      2.617584,
      NULL,
      2.912952,
      1,
      53.782112,
      NULL,
      1,
      NULL,
      15.226060,
      25,
      78,
      NULL,
      2,
      2,
      NULL,
      '',
      '',
      0.393210,
      '',
      '',
      '',
      3.900751,
      '2144',
      '',
      '',
      1,
      15,
      36.554444,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415208,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844896,
      NULL,
      NULL,
      0.171932,
      NULL,
      NULL,
      0.293906,
      NULL,
      NULL,
      2,
      4,
      0.901648,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.777930,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.219279,
      0,
      NULL,
      2.407797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1.579701,
      1,
      0.383496,
      NULL,
      NULL,
      NULL,
      5.350262,
      3,
      NULL,
      3,
      3.048895,
      0.969044,
      3.076908,
      0.585658,
      NULL,
      0.786031,
      0,
      1.210980,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.723524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.909049,
      0.081614,
      NULL,
      0,
      NULL,
      NULL,
      0.475596,
      3.923083,
      0.971916,
      5.079637,
      1.452043,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.204974,
      1.409301,
      3,
      2.230329,
      0.441471,
      0.478457,
      3,
      0.591672,
      0.737829,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.536770,
      2,
      1,
      2,
      5.878612,
      0,
      0,
      NULL,
      NULL,
      1.495028,
      NULL,
      NULL,
      0.036060,
      1,
      1.927318,
      1.992969,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.911315,
      3.286023,
      0,
      NULL,
      1.607315,
      0.597891,
      0,
      4.126960,
      NULL,
      NULL,
      3,
      18,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.242560,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      1.622161,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.858715,
      3.145818,
      NULL,
      NULL,
      1,
      2.712504,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1.637510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.974776,
      NULL,
      NULL,
      0,
      10,
      NULL,
      NULL,
      0.015240,
      0.954443,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.120886,
      2.561305,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626601,
      NULL,
      NULL,
      0.084630,
      NULL,
      1,
      0,
      2,
      0,
      1.906788,
      1.953283,
      0.883967,
      0.077464,
      0,
      0.079152,
      1.577574,
      1,
      3.533928,
      0,
      0,
      NULL,
      1,
      NULL,
      0.360891,
      0.925094,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.190011,
      NULL,
      0,
      NULL,
      0.900620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723450,
      0.670365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156016,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455027,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.190656,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.227441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.385166,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.215357,
      1.549619,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      296.265693,
      NULL,
      0.381391,
      NULL,
      0.023972,
      NULL,
      NULL,
      NULL,
      2,
      23.957225,
      14,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.364277,
      NULL,
      1,
      0,
      0.560926,
      7.298794,
      3.290865,
      2,
      NULL,
      0,
      1.518556,
      1,
      1.503498,
      0,
      0.524578,
      1,
      NULL,
      2,
      0.721911,
      3,
      NULL,
      0,
      2,
      0.856662,
      1.123414,
      NULL,
      0,
      1.850614,
      2,
      1,
      0.761816,
      NULL,
      1.087300,
      0.869528,
      1.310190,
      0.535545,
      0,
      3,
      3,
      0.890664,
      0.460528,
      NULL,
      0,
      0,
      0.287121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.986672,
      0.779850,
      0.928038,
      NULL,
      1.309300,
      1,
      4,
      5.413043,
      1,
      NULL,
      NULL,
      60.269252,
      16,
      6.378397,
      2,
      0.530166,
      '13033',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      '0134',
      '',
      '');
commit;
end;
/


