set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9222256';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1,
      2.890913,
      0.696781,
      2.402553,
      NULL,
      1,
      3,
      '31',
      NULL,
      21.746592,
      41,
      '1400112',
      1,
      1,
      3,
      3,
      '2140',
      2,
      0.118691,
      NULL,
      NULL,
      ' 0-21-1985',
      47,
      NULL,
      NULL,
      3.179042,
      NULL,
      ' 2- 2-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0.101322,
      '10-11-1986',
      NULL,
      ' 3- 7-2000',
      0.025743,
      3,
      2.892292,
      NULL,
      1.717140,
      3.431634,
      3.233984,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2.011904,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.012402,
      0.931786,
      0,
      1,
      0.838493,
      1.076858,
      NULL,
      2.861839,
      2.961674,
      1,
      NULL,
      10.037950,
      0,
      0,
      0.015761,
      NULL,
      4.113257,
      1.606506,
      1.886941,
      4,
      7.224491,
      NULL,
      1.333099,
      3,
      0,
      1.389672,
      0.935990,
      NULL,
      1.539213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0,
      1,
      1.686769,
      NULL,
      0,
      0,
      NULL,
      0.216678,
      3,
      0,
      1.163211,
      0.404796,
      0,
      1,
      0.693163,
      1.461129,
      NULL,
      NULL,
      0.081211,
      2,
      NULL,
      0.175213,
      0,
      1,
      NULL,
      NULL,
      1.586028,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      7,
      5,
      1.792626,
      NULL,
      0.068131,
      2.542075,
      NULL,
      0,
      1.496429,
      6.811661,
      0.484257,
      1.342057,
      NULL,
      0,
      0,
      NULL,
      1.542405,
      1.945148,
      5,
      2.225646,
      1.111023,
      1.989219,
      NULL,
      1.406662,
      NULL,
      0,
      0.354338,
      1,
      NULL,
      0,
      0.574414,
      0.986765,
      4.704001,
      NULL,
      7,
      1,
      4.899026,
      0.258034,
      2.203360,
      5,
      0,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1995',
      424,
      ' 9- 2-2001',
      520,
      1.730198,
      0.981544,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      3.750883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454269,
      1,
      1.225136,
      1,
      0.280728,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.909703,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.970053,
      NULL,
      0.666876,
      0,
      1.888807,
      NULL,
      0,
      0.667294,
      23.145914,
      3.400242,
      0.465621,
      NULL,
      NULL,
      NULL,
      0.070069,
      1,
      NULL,
      NULL,
      0.401325,
      3.906584,
      0,
      NULL,
      0.573434,
      1,
      1,
      0.993948,
      0,
      1.801025,
      NULL,
      0.431024,
      0,
      0,
      1,
      3,
      NULL,
      0,
      1.837854,
      1.200863,
      0.374592,
      0,
      NULL,
      1,
      NULL,
      1.874018,
      1.919847,
      NULL,
      NULL,
      9,
      6,
      10.908208,
      8,
      6.403473,
      5,
      NULL,
      1,
      NULL,
      2,
      NULL,
      68,
      0,
      NULL,
      20.455988,
      NULL,
      29.974304,
      98,
      4,
      5,
      5.167362,
      NULL,
      '23102',
      '',
      0.861791,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.739971,
      9.620605,
      226.236025,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.537901,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.580793,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.520674,
      2.027400,
      NULL,
      0,
      2.184175,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.910616,
      1.950332,
      0.064237,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.162618,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.255276,
      NULL,
      NULL,
      NULL,
      1.349807,
      NULL,
      NULL,
      0.879881,
      1,
      0,
      2.234796,
      0.078090,
      1.041806,
      2.701146,
      2.423549,
      1,
      0.120388,
      0,
      2.939383,
      2.886860,
      0.720606,
      0,
      0,
      1.618854,
      1.707227,
      0.005118,
      0.095087,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.235612,
      2.662847,
      NULL,
      NULL,
      3.884994,
      2,
      NULL,
      0.635704,
      1.144385,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.442092,
      5.645896,
      1.751388,
      NULL,
      NULL,
      NULL,
      1.828656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.415704,
      NULL,
      NULL,
      1.932090,
      NULL,
      NULL,
      1.352131,
      NULL,
      NULL,
      NULL,
      2.677891,
      NULL,
      1.395367,
      NULL,
      NULL,
      1.939356,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.806154,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.852343,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.973322,
      NULL,
      NULL,
      7,
      2,
      2.716080,
      5,
      1,
      2.000729,
      3,
      NULL,
      NULL,
      1,
      1,
      1,
      0.455145,
      0.660741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683422,
      NULL,
      NULL,
      0.779566,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609369,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.780955,
      3.930539,
      1,
      NULL,
      NULL,
      7.358689,
      NULL,
      NULL,
      NULL,
      4.650178,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.039230,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684823,
      NULL,
      NULL,
      NULL,
      1.958537,
      NULL,
      NULL,
      NULL,
      1.159531,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.654403,
      NULL,
      NULL,
      NULL,
      3.154027,
      3.278244,
      5,
      7.361124,
      3.359494,
      0.817826,
      5,
      1,
      23.061290,
      15.754429,
      1,
      NULL,
      NULL,
      2.123804,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.349977,
      1965,
      30.751730,
      1.671328,
      1,
      3,
      NULL,
      3,
      3.827325,
      1.925431,
      1,
      0.154665,
      1.041815,
      0,
      2,
      0.704147,
      0,
      0,
      1.666260,
      0,
      1,
      NULL,
      NULL,
      3.369328,
      0.839591,
      0.324164,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      126,
      1,
      1.674686,
      NULL,
      NULL,
      NULL,
      3.181498,
      NULL,
      3.224411,
      2,
      0.541494,
      1,
      1,
      2,
      3.132487,
      NULL,
      0,
      1.270674,
      2.354585,
      0.502684,
      0.979602,
      2.663485,
      NULL,
      1.938045,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.408947,
      1,
      1.995859,
      0.875169,
      0.390450,
      0.902846,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.559566,
      NULL,
      0,
      NULL,
      10.094838,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.316673,
      NULL,
      2,
      NULL,
      3.310577,
      NULL,
      0.846105,
      NULL,
      3.111404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      48,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      1.267926,
      1,
      1,
      NULL,
      NULL,
      1,
      3,
      3.437825,
      0.281117,
      0.317680,
      NULL,
      NULL,
      0,
      NULL,
      0.694605,
      3.676930,
      NULL,
      NULL,
      3.270962,
      1,
      0.654697,
      0,
      NULL,
      1.028097,
      3,
      NULL,
      0.829461,
      NULL,
      NULL,
      1.087922,
      1,
      NULL,
      0.671585,
      1.959584,
      NULL,
      0,
      0,
      NULL,
      1.929390,
      2,
      NULL,
      0,
      1,
      NULL,
      0.161133,
      1.243541,
      NULL,
      1.569217,
      NULL,
      NULL,
      0.438246,
      0.053170,
      NULL,
      1.596179,
      0.251199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172359,
      NULL,
      1.669444,
      NULL,
      1,
      NULL,
      NULL,
      4.165211,
      NULL,
      0,
      NULL,
      NULL,
      39,
      73.423001,
      4,
      3.996048,
      6.572220,
      '04123',
      '40341',
      '12444',
      1.171295,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


