set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9676087';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      3,
      1,
      2.981501,
      3,
      1.040955,
      NULL,
      '114',
      '34013213',
      77.243177,
      2,
      NULL,
      3.889295,
      1.862391,
      2,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      ' 1-17-1989',
      39,
      NULL,
      NULL,
      0,
      1,
      ' 7-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 6-15-2000',
      2.230488,
      1.305028,
      NULL,
      2.021352,
      0.513029,
      NULL,
      3,
      0.199517,
      0,
      NULL,
      8,
      18,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      7.300290,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.200672,
      NULL,
      4,
      1.081377,
      3,
      0,
      0,
      3.070869,
      1.799968,
      0.005361,
      2,
      0.457187,
      NULL,
      NULL,
      1.711842,
      0.371765,
      NULL,
      NULL,
      1.643360,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749898,
      0.782602,
      1.022596,
      2.837419,
      1.336498,
      NULL,
      0,
      1,
      NULL,
      0,
      1.429016,
      0.136032,
      3.111540,
      NULL,
      0.381770,
      3,
      2.484087,
      0,
      1.102694,
      0,
      0,
      2.707771,
      0.781478,
      2,
      2.868720,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.303080,
      2.737499,
      2.942173,
      1,
      5.188121,
      2,
      1.454146,
      0,
      0.640359,
      2.258934,
      NULL,
      3,
      0.981192,
      0,
      0.742965,
      1,
      1.889859,
      1,
      0,
      NULL,
      1.241747,
      NULL,
      1,
      1.682198,
      1.650790,
      0.094881,
      0.810074,
      0,
      NULL,
      0,
      1.176617,
      0.488090,
      NULL,
      3.002291,
      NULL,
      4.276003,
      8.036143,
      0,
      2,
      2.637696,
      NULL,
      1.432449,
      2.487329,
      1.434286,
      3.892772,
      0.104617,
      3.264422,
      1,
      '11- 4-1995',
      645,
      ' 9- 7-1982',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.064886,
      NULL,
      4.465808,
      1.576270,
      0,
      2.013670,
      0.749988,
      4,
      4,
      NULL,
      0,
      1.460137,
      1,
      3.143019,
      0.204076,
      1,
      1.626931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677852,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.438601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.602599,
      NULL,
      1.971227,
      0.077646,
      2.031399,
      0.553004,
      NULL,
      NULL,
      NULL,
      NULL,
      2.466796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443754,
      0.606483,
      0.849744,
      0.199041,
      3,
      0.768217,
      0,
      1,
      NULL,
      1.817523,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.973880,
      2.007620,
      1,
      1,
      1,
      1.814163,
      NULL,
      1,
      1.432997,
      0.213334,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      9.115427,
      NULL,
      5,
      0,
      NULL,
      3.658144,
      NULL,
      1.747232,
      4.781806,
      NULL,
      3,
      NULL,
      46.169592,
      2.475173,
      NULL,
      8.889662,
      NULL,
      NULL,
      NULL,
      2.744791,
      4,
      2,
      '24404',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      1.397401,
      '2400',
      NULL,
      NULL,
      2,
      3,
      145.007930,
      9.543817,
      3.085586,
      18.700145,
      9,
      NULL,
      0.860700,
      2.079847,
      3,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.112305,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.734082,
      1.937428,
      2,
      1,
      NULL,
      NULL,
      1,
      1.188168,
      1,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.547539,
      5.912488,
      0.228063,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.010951,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.567341,
      NULL,
      1.949172,
      0,
      0.016354,
      1.724764,
      2,
      1,
      1.467162,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.642242,
      2.935363,
      3,
      NULL,
      2.543964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.662314,
      1.011164,
      7,
      3,
      0,
      0,
      1,
      0,
      3.586556,
      NULL,
      0.335021,
      NULL,
      NULL,
      NULL,
      0.670897,
      2.226064,
      0,
      0,
      3.226149,
      1.407892,
      3,
      1.394952,
      3.044563,
      1.494500,
      NULL,
      NULL,
      1.509313,
      2,
      5.455061,
      1,
      NULL,
      0.610072,
      2,
      2.878531,
      0,
      NULL,
      1,
      5.163545,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577210,
      NULL,
      NULL,
      1.240825,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.693467,
      0.535682,
      1.196715,
      2,
      3,
      NULL,
      1,
      0,
      NULL,
      0.377487,
      NULL,
      NULL,
      5.245094,
      3,
      3,
      3.214638,
      0.731288,
      0.467132,
      3.529563,
      0,
      0.218429,
      1.621191,
      0,
      3,
      2,
      NULL,
      NULL,
      5,
      1,
      NULL,
      4.597603,
      4.454071,
      5,
      1.765700,
      1.585396,
      5.177188,
      3,
      3.347212,
      NULL,
      NULL,
      2,
      1.418686,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      1.283452,
      NULL,
      NULL,
      0.415275,
      NULL,
      NULL,
      3,
      NULL,
      1.155822,
      0.300771,
      NULL,
      NULL,
      0,
      NULL,
      0.919434,
      3.479991,
      NULL,
      2.325486,
      3.558264,
      NULL,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3,
      NULL,
      5.282427,
      7,
      NULL,
      NULL,
      1,
      0.896068,
      1.624869,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.771028,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.557245,
      NULL,
      NULL,
      NULL,
      2.116257,
      NULL,
      NULL,
      NULL,
      0.492898,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.644911,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.225993,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.313967,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.055719,
      0.221654,
      5,
      1,
      1,
      6.405376,
      59.506427,
      1,
      NULL,
      NULL,
      1.040858,
      NULL,
      NULL,
      3,
      NULL,
      9,
      NULL,
      186.924051,
      41.165608,
      1,
      NULL,
      NULL,
      0.963071,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0.484720,
      0,
      1.575476,
      0.609863,
      NULL,
      0,
      1.070296,
      1,
      0,
      0.131320,
      1,
      0.311305,
      NULL,
      1.775892,
      0.531555,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.291199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.393411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020488,
      0.931061,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.407647,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121907,
      2,
      NULL,
      1,
      NULL,
      0.164640,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0.338074,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.937127,
      0,
      NULL,
      3,
      0.103315,
      4,
      1,
      1.106577,
      7.896054,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.483447,
      1,
      NULL,
      0,
      2,
      NULL,
      1.046917,
      NULL,
      NULL,
      1.587926,
      1,
      NULL,
      0.684289,
      1.900400,
      NULL,
      NULL,
      0.529456,
      NULL,
      0.311754,
      0.815328,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.775072,
      0.857558,
      NULL,
      NULL,
      1.399063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443561,
      NULL,
      1.681405,
      NULL,
      0,
      NULL,
      0.676669,
      10,
      2,
      0.966841,
      1,
      1.521506,
      3,
      48.380591,
      5,
      1,
      0.140668,
      '31444',
      '',
      '',
      0.191444,
      '',
      '',
      '',
      0.153274,
      '3322',
      '',
      NULL);
commit;
end;
/


