set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9687307';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      '00',
      NULL,
      24,
      '4320401',
      3.848077,
      NULL,
      NULL,
      2,
      '4432',
      NULL,
      1.045102,
      NULL,
      NULL,
      NULL,
      9,
      72,
      NULL,
      0.974100,
      NULL,
      ' 5- 1-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      3.554468,
      ' 9-12-2000',
      '10-14-1987',
      ' 7-19-1987',
      3,
      1.023572,
      3.350514,
      NULL,
      0,
      0.851011,
      3,
      1.869013,
      NULL,
      NULL,
      NULL,
      5.115775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0.792375,
      0.345096,
      NULL,
      0.921108,
      0.671925,
      1.209278,
      1.720018,
      0,
      1.811592,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.002032,
      1,
      1,
      0,
      1.921965,
      1,
      0,
      0.141606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573128,
      1.880792,
      NULL,
      0.912872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192434,
      1,
      0.726569,
      1.505748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.695900,
      4,
      1.721821,
      1.513254,
      1.829165,
      0.842217,
      0,
      1,
      1.119629,
      1,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      5,
      2.244573,
      0.017227,
      1.535597,
      NULL,
      0,
      0.414999,
      NULL,
      0,
      3.652370,
      1.008879,
      0.249984,
      NULL,
      1,
      0,
      4.140191,
      2.423234,
      2.541251,
      0,
      NULL,
      2.515595,
      1,
      0.430067,
      0.056299,
      0.564581,
      NULL,
      0.675513,
      5.017388,
      NULL,
      1.404536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.322992,
      0,
      NULL,
      0.267226,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656811,
      0,
      NULL,
      1.416024,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.443772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.068716,
      NULL,
      0.389245,
      0.146895,
      1,
      NULL,
      NULL,
      14,
      NULL,
      0,
      5.626409,
      NULL,
      23,
      1.669135,
      1,
      1.613894,
      1,
      3.223976,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      0,
      0,
      1.639071,
      NULL,
      3.853454,
      4,
      3,
      0,
      3,
      1,
      0,
      0,
      0,
      1.942433,
      NULL,
      0,
      1.396148,
      0,
      1,
      2.922091,
      NULL,
      9.065530,
      8.622936,
      4,
      4.154730,
      10,
      3,
      0.888784,
      0.836571,
      6.931156,
      NULL,
      1,
      2.205860,
      38.708157,
      0.816440,
      NULL,
      86.746917,
      NULL,
      55.178340,
      15,
      5,
      NULL,
      0,
      '24214',
      '3330',
      '',
      1.450398,
      '',
      NULL,
      NULL,
      0.096973,
      '',
      '',
      '',
      1,
      11,
      23.442877,
      NULL,
      3,
      NULL,
      2.021304,
      NULL,
      2.413197,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.568858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.875774,
      NULL,
      1.824770,
      0,
      NULL,
      NULL,
      0.784363,
      NULL,
      NULL,
      0.953725,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      3.582554,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      1.638928,
      1.831131,
      1.991273,
      NULL,
      NULL,
      1.232241,
      NULL,
      NULL,
      1.301407,
      1.185371,
      2.650111,
      1.495736,
      0,
      1.132735,
      NULL,
      3,
      NULL,
      1.982804,
      NULL,
      2,
      0.208993,
      0,
      3.669714,
      2,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      2.983530,
      1,
      0.824661,
      4,
      2,
      0.154358,
      0.081398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391379,
      3,
      NULL,
      NULL,
      NULL,
      1.031688,
      NULL,
      NULL,
      3.997441,
      0.742080,
      1.258238,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581589,
      1,
      NULL,
      NULL,
      NULL,
      1.979947,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.452350,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4.167808,
      3,
      2,
      NULL,
      NULL,
      2,
      4.718041,
      1.595926,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      3,
      0,
      NULL,
      0.646802,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.947008,
      1.845257,
      2,
      NULL,
      NULL,
      1.044148,
      4.851573,
      NULL,
      0.800400,
      4.732303,
      3.789239,
      2,
      3,
      3,
      5,
      0.845861,
      NULL,
      0,
      0,
      1,
      1.827923,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317344,
      NULL,
      NULL,
      1.703076,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.589579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608422,
      NULL,
      NULL,
      5.074537,
      NULL,
      NULL,
      NULL,
      0.861290,
      0.403607,
      2.554932,
      0.910544,
      1,
      3,
      NULL,
      NULL,
      3.158748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.737140,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.295214,
      NULL,
      0,
      1.978254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.570489,
      NULL,
      0,
      1.245081,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.028339,
      1.769001,
      0,
      NULL,
      NULL,
      0.376603,
      1.003030,
      NULL,
      NULL,
      1.679444,
      NULL,
      NULL,
      NULL,
      0.641947,
      NULL,
      NULL,
      NULL,
      1.777181,
      3.764938,
      NULL,
      1,
      10.757427,
      6,
      5.475750,
      0,
      10.888115,
      NULL,
      0,
      28,
      3,
      1.634101,
      NULL,
      NULL,
      0.680083,
      NULL,
      NULL,
      1,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      1.045122,
      NULL,
      0.767142,
      351,
      7.899577,
      1.485140,
      0,
      NULL,
      NULL,
      1,
      1,
      0.534043,
      NULL,
      0,
      1.150261,
      NULL,
      0,
      0,
      NULL,
      0.818542,
      0.858386,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461612,
      1.168529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955892,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283610,
      0.307421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045063,
      0.359971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.747557,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.972326,
      0.161469,
      0,
      NULL,
      1.631891,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963044,
      4,
      1.100431,
      1.537625,
      1.388341,
      3.622828,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.661999,
      1,
      0.674325,
      1,
      0.040399,
      1.562327,
      0.835113,
      1.052612,
      NULL,
      1.979576,
      0.457851,
      1.262829,
      0.053071,
      3,
      2.474401,
      2,
      2.014386,
      0,
      NULL,
      1,
      1.640481,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      2.689317,
      1,
      1,
      1,
      1.386060,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.711609,
      5.161893,
      8.378935,
      4,
      1.296741,
      NULL,
      NULL,
      49,
      32,
      NULL,
      1,
      3,
      '32231',
      '4213',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


