set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.231360,
      7,
      2,
      2.685582,
      1,
      0.575114,
      0,
      1,
      '14',
      NULL,
      NULL,
      10.965908,
      '1311134',
      1,
      0,
      3,
      3,
      '4423',
      3.397273,
      1,
      NULL,
      NULL,
      ' 4-23-1982',
      52,
      26.055109,
      NULL,
      1,
      0,
      ' 1- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1990',
      3.332408,
      1.126875,
      0.184092,
      NULL,
      NULL,
      NULL,
      3.847989,
      1.772953,
      NULL,
      NULL,
      NULL,
      2.982542,
      3.485161,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      0.350259,
      0.702878,
      0,
      5,
      1.554788,
      1,
      0.688685,
      0.600708,
      0.270625,
      3.114049,
      0.260703,
      6,
      1,
      1,
      NULL,
      1.300738,
      NULL,
      1.661975,
      5,
      8.859856,
      1,
      3,
      2,
      1,
      1.555001,
      NULL,
      0,
      NULL,
      1.191460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.976234,
      5,
      3,
      NULL,
      0,
      3,
      2.761521,
      2.978358,
      1.911526,
      NULL,
      NULL,
      2.325871,
      1.717631,
      1,
      2.210421,
      NULL,
      3,
      3,
      0.081975,
      1.415782,
      0.400915,
      8,
      2,
      4,
      3,
      0.184142,
      NULL,
      NULL,
      1.191517,
      NULL,
      NULL,
      NULL,
      4.922073,
      1,
      0,
      6.963018,
      NULL,
      6,
      2.279871,
      0,
      0.601880,
      1,
      0,
      1.303277,
      NULL,
      0.523034,
      1.264692,
      0.554614,
      0,
      1,
      NULL,
      2.922719,
      3,
      2,
      8.511520,
      9,
      1,
      NULL,
      6,
      2,
      4.584393,
      9.543367,
      1,
      1,
      8,
      7,
      2.878772,
      4.467457,
      0,
      7,
      7,
      6.804184,
      6,
      NULL,
      3,
      0.892971,
      5,
      6,
      2.631106,
      '10-26-1991',
      65,
      ' 4-20-1977',
      12,
      1,
      NULL,
      0.956019,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.922535,
      1,
      1.953221,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.649857,
      NULL,
      NULL,
      NULL,
      NULL,
      3.849558,
      1.930277,
      NULL,
      0.757240,
      0.546632,
      4.936940,
      9.792291,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821865,
      3,
      0.514187,
      0.252877,
      1,
      3.600142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.317747,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      1.352087,
      3.914349,
      NULL,
      1.306687,
      NULL,
      0.926757,
      1.551255,
      NULL,
      NULL,
      NULL,
      1,
      1.992821,
      NULL,
      0.627382,
      1,
      3,
      1.611969,
      2.859451,
      3.639279,
      NULL,
      NULL,
      0.018811,
      0,
      3.042196,
      NULL,
      3.330350,
      NULL,
      0,
      1,
      0,
      0.836750,
      1.837837,
      1,
      NULL,
      0,
      1.880626,
      1.554872,
      1,
      1,
      0.511499,
      3.927369,
      1,
      0,
      9.847272,
      NULL,
      NULL,
      10.448457,
      0,
      2,
      0.175133,
      3.459992,
      3,
      1.421783,
      1,
      32,
      2,
      NULL,
      60,
      NULL,
      NULL,
      NULL,
      3,
      4.165885,
      3,
      '14413',
      '',
      '',
      1.940052,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      3,
      NULL,
      23,
      0,
      10.972047,
      2.808194,
      0.546687,
      4.537707,
      2.902521,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.746112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.505219,
      NULL,
      2.996878,
      3.709175,
      2,
      3.768002,
      2,
      NULL,
      1,
      2.611700,
      2,
      3,
      0.548516,
      NULL,
      NULL,
      1.897464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.514073,
      2,
      5.495187,
      0.697367,
      1.668364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.099376,
      NULL,
      0.976974,
      3,
      0.805175,
      0.911417,
      1,
      2.500505,
      NULL,
      0.208864,
      NULL,
      2.040098,
      3,
      0,
      2.043235,
      0,
      NULL,
      3.433860,
      NULL,
      0.801041,
      1,
      0,
      3,
      1.643587,
      NULL,
      1.759463,
      1,
      0.837405,
      NULL,
      NULL,
      0,
      1.958979,
      1,
      11.645674,
      NULL,
      1,
      2,
      0.003970,
      NULL,
      NULL,
      NULL,
      1.882221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.814933,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      3.406603,
      1,
      3.624572,
      1,
      NULL,
      NULL,
      4.287598,
      3.818716,
      2,
      1,
      1.540117,
      0,
      0.419899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.359478,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0.467934,
      1,
      0.566464,
      NULL,
      NULL,
      1.963603,
      2,
      2,
      2.826223,
      0,
      NULL,
      NULL,
      3.988795,
      8,
      NULL,
      1,
      NULL,
      3,
      3.210204,
      2.809977,
      3,
      1,
      NULL,
      2,
      1,
      2,
      11,
      4,
      NULL,
      1,
      2,
      1,
      3,
      0.196677,
      1,
      2.506767,
      3.790888,
      1,
      NULL,
      0.652012,
      1,
      9.297483,
      NULL,
      6,
      0,
      NULL,
      5.860358,
      1,
      3.394091,
      9.817023,
      1,
      1.954185,
      1,
      1,
      0.633189,
      1.924330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.689908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.850442,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.969591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859786,
      NULL,
      NULL,
      NULL,
      1.614220,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.700622,
      NULL,
      NULL,
      NULL,
      1.645788,
      NULL,
      NULL,
      NULL,
      0.607220,
      NULL,
      NULL,
      NULL,
      0.118459,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.573556,
      NULL,
      NULL,
      NULL,
      3.454721,
      NULL,
      NULL,
      NULL,
      1.225921,
      NULL,
      NULL,
      NULL,
      0.494383,
      6.563055,
      7.402947,
      0,
      8,
      2.552321,
      1.929346,
      NULL,
      NULL,
      1.931364,
      NULL,
      NULL,
      1.054763,
      NULL,
      NULL,
      2,
      4,
      2.264250,
      1,
      NULL,
      0.131887,
      11,
      0,
      1,
      0.067992,
      NULL,
      0.215418,
      NULL,
      0.189519,
      NULL,
      1.400116,
      NULL,
      0.475034,
      1.926666,
      0.658088,
      0.344900,
      0.952336,
      1.259450,
      0,
      0.400712,
      0.587643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781441,
      3,
      NULL,
      4,
      4,
      0.778450,
      1,
      5.907130,
      15.481070,
      3,
      NULL,
      1,
      1.868121,
      2.149093,
      NULL,
      2,
      0.050614,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.526585,
      NULL,
      NULL,
      2,
      NULL,
      1.099118,
      2,
      NULL,
      1,
      2.470133,
      NULL,
      3.008897,
      0.534421,
      NULL,
      0,
      1.867856,
      NULL,
      0.222422,
      NULL,
      NULL,
      1.161977,
      1,
      NULL,
      0.100668,
      1.418325,
      0.318799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084246,
      NULL,
      0.247620,
      NULL,
      1.031581,
      NULL,
      0.158496,
      7.868320,
      8,
      0.029938,
      NULL,
      NULL,
      58.819327,
      9.965236,
      2,
      1,
      0.699466,
      '40214',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


