set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0434224',
      3.862424,
      1.507493,
      1,
      NULL,
      '0423',
      2.361899,
      1.168632,
      NULL,
      NULL,
      ' 0- 1-1979',
      99,
      NULL,
      NULL,
      0,
      1,
      NULL,
      58.501567,
      0.067652,
      NULL,
      73.976312,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807023,
      0,
      0.732105,
      0.006399,
      0,
      4,
      NULL,
      0.994674,
      NULL,
      0.004786,
      8,
      3,
      NULL,
      NULL,
      NULL,
      5.069807,
      4.336547,
      1.340831,
      6.874932,
      0,
      NULL,
      0.375198,
      1.708793,
      0,
      NULL,
      0.672620,
      1.177037,
      1,
      0.153439,
      0,
      2,
      3.975104,
      1,
      NULL,
      3.105315,
      0.080061,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.823090,
      NULL,
      NULL,
      1,
      4.292899,
      1.747014,
      0.436195,
      1.080193,
      NULL,
      0.133165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.364008,
      7.789188,
      9.492559,
      NULL,
      0.702956,
      1,
      1.232348,
      1.744528,
      0.994285,
      1.309090,
      0,
      3.515402,
      1,
      NULL,
      0,
      3.827180,
      NULL,
      1.554590,
      2.951064,
      1.246582,
      1,
      NULL,
      4,
      1.704466,
      0.862922,
      1.048055,
      1,
      NULL,
      NULL,
      0.726423,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.343075,
      NULL,
      0.163427,
      1.908994,
      NULL,
      0,
      1,
      0.724680,
      1.498782,
      NULL,
      0,
      NULL,
      0,
      1.258156,
      1,
      NULL,
      0.519554,
      1.611144,
      1.758436,
      NULL,
      1.047282,
      NULL,
      0,
      1.526528,
      1.914432,
      0.726948,
      NULL,
      0.795950,
      1,
      1,
      6,
      NULL,
      5.636354,
      1,
      1.317003,
      1.793530,
      1.950056,
      NULL,
      2.853805,
      1,
      3,
      4,
      1,
      0,
      NULL,
      1199.778658,
      ' 2- 9-2002',
      NULL,
      NULL,
      0.947584,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.449924,
      0.294096,
      NULL,
      0,
      1.542494,
      1.607837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215554,
      0,
      1,
      0,
      1,
      0.961716,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275566,
      0.437225,
      0.349381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.027287,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.687108,
      1.379097,
      2.807376,
      0,
      2,
      0.888685,
      1.351690,
      1.275727,
      2.837166,
      0,
      2.645441,
      NULL,
      1,
      1,
      0.817506,
      3,
      NULL,
      1,
      0.499441,
      11.315703,
      1,
      0,
      NULL,
      1,
      1.613315,
      1,
      NULL,
      0.110458,
      NULL,
      3,
      NULL,
      0.364194,
      1.313834,
      NULL,
      1.205165,
      1,
      8,
      0,
      NULL,
      NULL,
      NULL,
      0.146252,
      3.738874,
      0,
      19,
      NULL,
      1,
      71,
      NULL,
      NULL,
      NULL,
      0.674703,
      NULL,
      4,
      '23410',
      '32014',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      NULL,
      37,
      3,
      22,
      0.209072,
      8.924466,
      0,
      0,
      0,
      1.659488,
      1.296691,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.296737,
      NULL,
      NULL,
      0.454235,
      NULL,
      NULL,
      1.300340,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      2.216128,
      3,
      0.527828,
      NULL,
      NULL,
      3,
      2,
      0.751082,
      1.383911,
      0.269948,
      NULL,
      NULL,
      NULL,
      0.814542,
      NULL,
      NULL,
      NULL,
      0,
      3.621468,
      2.776295,
      0,
      3,
      3,
      NULL,
      1.472559,
      3.527122,
      3.513622,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      0.414266,
      0,
      2,
      0.275685,
      1.302691,
      3.091194,
      1,
      2,
      0.140055,
      1.552859,
      NULL,
      NULL,
      0.399851,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      4,
      9,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.260448,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.810774,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.800389,
      NULL,
      NULL,
      0.098643,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.715932,
      NULL,
      NULL,
      1.431776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.984791,
      5,
      6.995859,
      NULL,
      NULL,
      NULL,
      1.541236,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4.358625,
      0.850912,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      1.222676,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.524643,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.439939,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0.771011,
      0.505042,
      1.772828,
      2.304879,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504034,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283564,
      1.346790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823671,
      0,
      NULL,
      NULL,
      0.194264,
      1,
      NULL,
      NULL,
      1.715954,
      NULL,
      NULL,
      NULL,
      1.722910,
      1.129124,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.129659,
      NULL,
      NULL,
      NULL,
      1.181995,
      NULL,
      NULL,
      1.593519,
      1,
      NULL,
      NULL,
      0.874572,
      NULL,
      NULL,
      NULL,
      1,
      615.497093,
      105.884018,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.383856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586672,
      7.197757,
      1,
      72.397328,
      31,
      NULL,
      0.845099,
      NULL,
      1.257776,
      NULL,
      0,
      1.349581,
      1.650734,
      1,
      1.598047,
      0.534723,
      0.102077,
      1.647141,
      1,
      1.065032,
      1.450110,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      6,
      0.396872,
      1,
      0,
      1.835639,
      4,
      0.436397,
      3,
      2.062419,
      NULL,
      0,
      1.268823,
      1,
      0,
      NULL,
      2.833817,
      0.900872,
      2.493522,
      0.392329,
      0,
      1.056450,
      0,
      1,
      0.504882,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.572369,
      0.694553,
      0,
      0.568880,
      1,
      1.987642,
      0.688235,
      1,
      NULL,
      NULL,
      2.512634,
      2,
      1.486142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245638,
      NULL,
      NULL,
      0.644875,
      0.569553,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      52.822888,
      111,
      4,
      1.471483,
      3.294876,
      '30342',
      '31442',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


