set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      NULL,
      29,
      23.826472,
      NULL,
      3.669868,
      1.586509,
      6,
      0,
      '4022',
      5.721264,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      6,
      NULL,
      1.566473,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1977',
      ' 8-26-1990',
      ' 2- 8-2000',
      1,
      2.109040,
      NULL,
      3.812505,
      0.668340,
      0.105333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.647161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.114321,
      0.136387,
      NULL,
      0,
      0.926156,
      1,
      NULL,
      0,
      1.273201,
      0,
      NULL,
      0.566345,
      2,
      4,
      2,
      1.191978,
      NULL,
      0.308491,
      NULL,
      NULL,
      0.724595,
      0,
      0,
      1.493666,
      1.210674,
      1,
      1.394712,
      1.035699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.546665,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.600118,
      1.821847,
      1.939166,
      1.219713,
      0.620072,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1.177199,
      1,
      0.121025,
      0.815632,
      1,
      0.665869,
      NULL,
      1,
      4.895400,
      1.679154,
      0.739588,
      2,
      1.720408,
      NULL,
      3.840050,
      0,
      3,
      3,
      2.084928,
      NULL,
      NULL,
      NULL,
      NULL,
      2.867723,
      2,
      NULL,
      NULL,
      2.580919,
      2,
      NULL,
      1.515210,
      0,
      NULL,
      2,
      0.001541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.849774,
      0.432186,
      NULL,
      0.324455,
      0.950788,
      0.751304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765141,
      NULL,
      NULL,
      5.764183,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.505269,
      1.483767,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.893813,
      NULL,
      0,
      NULL,
      7,
      2.323835,
      4.003856,
      1.535141,
      3.267321,
      2,
      NULL,
      3.781858,
      2.306635,
      2.288694,
      4.386478,
      1,
      0.902962,
      1,
      NULL,
      0.656149,
      0.776456,
      1.348163,
      NULL,
      1.775212,
      0,
      1.228981,
      NULL,
      1,
      2.956351,
      0,
      0,
      NULL,
      7,
      2.652946,
      8,
      NULL,
      1,
      3,
      2,
      3.126046,
      NULL,
      2.499356,
      1,
      9.251374,
      NULL,
      NULL,
      44.441805,
      NULL,
      NULL,
      15,
      NULL,
      1,
      2.812023,
      '34304',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.371153,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020889,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.249258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.752489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.937375,
      NULL,
      NULL,
      1.595669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.537875,
      NULL,
      0.099068,
      2,
      2.126629,
      0.021542,
      NULL,
      NULL,
      4.641156,
      0.715554,
      0,
      3,
      NULL,
      2.551831,
      NULL,
      2.560226,
      3.365087,
      NULL,
      0.574719,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.502244,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.956301,
      1.378122,
      1,
      NULL,
      NULL,
      0,
      7,
      9,
      7,
      NULL,
      6.130157,
      0,
      NULL,
      NULL,
      2.890461,
      1.304276,
      3,
      0.723750,
      2,
      2,
      0.859735,
      NULL,
      NULL,
      2.070213,
      2.316693,
      0,
      NULL,
      1.532484,
      NULL,
      2,
      NULL,
      3,
      2.275567,
      3,
      3.425865,
      1.056138,
      3.659871,
      NULL,
      0,
      5,
      6,
      6,
      6.115442,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.016651,
      1.327488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.749373,
      NULL,
      1.278228,
      1.424704,
      1.721736,
      NULL,
      1.497246,
      NULL,
      NULL,
      NULL,
      19.954053,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460272,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.504141,
      NULL,
      NULL,
      NULL,
      0.166039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.124994,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722668,
      1,
      1,
      3.557007,
      6,
      2,
      0.313339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      173,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1.579186,
      0.559310,
      1,
      0,
      1,
      0.039740,
      0.279295,
      0,
      1.213663,
      0.097505,
      1,
      1.478665,
      0.254804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.012375,
      0.456198,
      0.343950,
      4,
      1,
      2.096640,
      NULL,
      12.487187,
      3.058346,
      NULL,
      NULL,
      1.399573,
      1.204775,
      1.544077,
      0,
      1.436641,
      NULL,
      0,
      1.720596,
      1,
      NULL,
      0.131137,
      0.438776,
      0,
      3,
      1,
      1,
      0,
      3,
      1.331796,
      NULL,
      0.880533,
      NULL,
      1,
      0,
      NULL,
      1.707053,
      1.599869,
      2.938004,
      0.450812,
      0,
      0.803581,
      0,
      1.315110,
      3.511376,
      1.459639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442761,
      0,
      1,
      1,
      0.127130,
      0,
      0,
      2.604196,
      0.559850,
      0,
      NULL,
      0,
      79.223788,
      10,
      5.782731,
      NULL,
      7.412725,
      '01304',
      '21323',
      '14240',
      1.678432,
      '',
      '',
      NULL,
      1.120097,
      '',
      '',
      '');
commit;
end;
/


