set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.983750,
      1,
      2.076284,
      0.570734,
      2,
      NULL,
      0.791546,
      2,
      '400',
      '01143211',
      NULL,
      5,
      '2332313',
      0.292797,
      0.574338,
      2,
      2,
      '0233',
      5.688115,
      0.205941,
      NULL,
      NULL,
      ' 0-24-2000',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 1-16-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 1-15-1982',
      0,
      0.022419,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      7.014230,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      0.055586,
      0.665097,
      0,
      1.118438,
      0,
      NULL,
      0.973066,
      NULL,
      0.734817,
      NULL,
      4.554619,
      1.472555,
      1,
      2,
      3.563206,
      1.473318,
      1.076140,
      0,
      1.487096,
      0.954625,
      1.813266,
      0,
      0,
      0,
      NULL,
      1.581306,
      1,
      1.529058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990404,
      0.287462,
      0,
      0.917583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.914023,
      3.006250,
      0.718273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.743565,
      1,
      0,
      1,
      0.524009,
      0,
      0,
      NULL,
      0,
      NULL,
      1.846388,
      0.578431,
      1.883501,
      1.976074,
      0.052698,
      1.533324,
      NULL,
      0,
      0,
      1,
      0.501782,
      0,
      1,
      5.304098,
      5.443542,
      5.812006,
      1,
      0,
      0,
      0.073183,
      6,
      1.250332,
      0,
      3.624879,
      2.171701,
      4,
      0,
      NULL,
      2,
      1,
      5.674229,
      0,
      0.548195,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.099465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.280985,
      0.899269,
      NULL,
      1,
      1.544164,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      1.427292,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.626160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.635700,
      NULL,
      0.390936,
      2,
      0.939684,
      1,
      1.410073,
      0.125149,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.822762,
      NULL,
      6.003378,
      4.887460,
      2,
      0.187562,
      0.579736,
      NULL,
      NULL,
      0,
      5,
      2.262325,
      2,
      0.445344,
      0.303715,
      0.827134,
      NULL,
      0.835005,
      0.420483,
      1.164572,
      0.810842,
      0.632023,
      1.277176,
      0.622501,
      1,
      1.885204,
      1,
      0.177056,
      NULL,
      11.113983,
      3,
      6.541989,
      10,
      11,
      7.937389,
      3,
      NULL,
      NULL,
      3.939308,
      3.408324,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '30221',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '0141',
      '',
      '',
      0.628639,
      6.581693,
      199,
      7.779088,
      1.172464,
      26.913463,
      0,
      0,
      1.886601,
      3,
      0.510221,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403701,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.878690,
      NULL,
      NULL,
      1.216635,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.041133,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.630551,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.198904,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.119150,
      NULL,
      NULL,
      0,
      0,
      0.078631,
      NULL,
      1.265045,
      3,
      NULL,
      NULL,
      2.581603,
      NULL,
      NULL,
      NULL,
      1.616027,
      1,
      0,
      NULL,
      1.270383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245817,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.306325,
      1.495671,
      NULL,
      NULL,
      NULL,
      1.112614,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.183334,
      0.536478,
      2,
      1,
      NULL,
      NULL,
      2,
      4,
      2.328441,
      3,
      2,
      0,
      0.148011,
      0.182831,
      0,
      4,
      0.098839,
      0,
      1.754475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.025819,
      2,
      0,
      1,
      NULL,
      NULL,
      0.807998,
      8,
      4.310575,
      8,
      0,
      5.836197,
      1,
      1,
      3.081003,
      0.310304,
      1,
      1.295902,
      NULL,
      3,
      1,
      2,
      0,
      NULL,
      4,
      4.276756,
      3.709978,
      NULL,
      0.215858,
      3,
      NULL,
      3,
      3.965011,
      3.843318,
      3.544228,
      1.047047,
      2,
      2,
      0.395444,
      6,
      7,
      4,
      7.886052,
      1.281601,
      7,
      0.338282,
      1,
      6.670863,
      1,
      1,
      0.256524,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545747,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.433200,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3.613602,
      1,
      2,
      3,
      9,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.991169,
      NULL,
      1.788604,
      NULL,
      1.679284,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.575953,
      NULL,
      0.135411,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      1,
      0.844371,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453629,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.489176,
      0.582687,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.321356,
      0,
      NULL,
      NULL,
      0.698439,
      1,
      NULL,
      0.018863,
      1.949918,
      1,
      NULL,
      NULL,
      3,
      1.787175,
      NULL,
      1.437664,
      1,
      5,
      NULL,
      1.411659,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      50.621597,
      34.455061,
      0.996316,
      58.783364,
      3,
      NULL,
      NULL,
      NULL,
      1.624021,
      NULL,
      NULL,
      0.560651,
      NULL,
      NULL,
      0.280627,
      NULL,
      NULL,
      0.356298,
      NULL,
      0,
      NULL,
      0,
      0.290833,
      0.763651,
      NULL,
      NULL,
      0.294882,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.813096,
      NULL,
      NULL,
      1,
      0.343429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773438,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568485,
      0.254027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.697878,
      NULL,
      0,
      NULL,
      NULL,
      1.311364,
      1.687657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.325975,
      NULL,
      1.974754,
      3,
      5,
      2,
      2.963351,
      NULL,
      5.751424,
      2,
      2,
      0.050729,
      1.273273,
      NULL,
      0,
      0.498938,
      0,
      0.414462,
      1.465246,
      1,
      0,
      1.574475,
      NULL,
      1.775765,
      3,
      1.833462,
      3.659672,
      0,
      3,
      0,
      1,
      1.626007,
      1.256901,
      0.272409,
      0.835728,
      NULL,
      0,
      0.410922,
      3.665519,
      1.242299,
      1.517582,
      NULL,
      1.831962,
      0,
      NULL,
      3.602322,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942523,
      1,
      0.827542,
      0,
      1,
      0,
      6,
      NULL,
      0.146739,
      1.688948,
      NULL,
      NULL,
      12.201555,
      41,
      0.316451,
      4,
      2,
      '44244',
      '12000',
      NULL,
      0,
      NULL,
      '',
      '',
      2.982070,
      '3313',
      NULL,
      NULL);
commit;
end;
/


