set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.859716,
      1.539657,
      1,
      2,
      2.012671,
      3,
      2,
      2,
      '244',
      '00414334',
      60,
      17.780418,
      '2414202',
      2,
      0.135106,
      NULL,
      0,
      NULL,
      1.777914,
      1.989617,
      NULL,
      NULL,
      ' 4-23-1999',
      58.309076,
      13,
      NULL,
      0,
      2.710400,
      ' 3-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2- 6-1976',
      '10- 3-1986',
      ' 1-28-1993',
      3.084717,
      0.425473,
      1.225965,
      2,
      2.590273,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      11,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041326,
      NULL,
      0.429149,
      1.598292,
      0,
      NULL,
      1.989634,
      NULL,
      NULL,
      0,
      0.665985,
      0.041403,
      3.450830,
      2,
      9,
      7,
      0.403670,
      0,
      0.935209,
      0,
      1.131354,
      1,
      0,
      5.780953,
      0,
      NULL,
      1.895690,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284984,
      1,
      1.450259,
      0.921861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.853476,
      8,
      1,
      0,
      1.144932,
      1,
      NULL,
      NULL,
      0.727844,
      NULL,
      NULL,
      1,
      NULL,
      1.821126,
      3,
      5.929057,
      0.433767,
      0.275520,
      0,
      1.048507,
      NULL,
      1.505712,
      0.927210,
      0,
      1,
      0.403049,
      1,
      NULL,
      0.944063,
      1,
      NULL,
      1,
      0,
      0,
      0.348083,
      0,
      1,
      7,
      0,
      5.629518,
      1,
      0,
      NULL,
      5.158791,
      NULL,
      0.720948,
      NULL,
      1,
      5.045641,
      9.338458,
      5,
      2,
      NULL,
      4.915909,
      1,
      4.757091,
      NULL,
      4,
      0,
      '11- 5-1991',
      NULL,
      NULL,
      9,
      1,
      1,
      1,
      0.123455,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.462590,
      2.228841,
      1.864350,
      0,
      0,
      1,
      0.385010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.972500,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836980,
      NULL,
      NULL,
      2.378006,
      0,
      5.275915,
      1.547105,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.972223,
      0,
      NULL,
      NULL,
      0.575530,
      0.877876,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.313965,
      3.033548,
      4.231441,
      7.126751,
      1,
      0,
      3,
      2.355108,
      3,
      1.845761,
      5.319403,
      3,
      2,
      1,
      1.032900,
      1.021283,
      NULL,
      NULL,
      1.164539,
      0,
      1,
      0,
      NULL,
      0.804257,
      1,
      0.664562,
      NULL,
      4.595630,
      0,
      2.828029,
      2,
      2,
      0,
      3,
      2,
      3.018260,
      2.120617,
      0.101011,
      1.358667,
      2,
      3,
      21,
      2,
      0.296821,
      NULL,
      NULL,
      29.643802,
      60.206944,
      1.648441,
      2.510821,
      1.916370,
      NULL,
      '',
      '',
      1.720797,
      NULL,
      '',
      '',
      NULL,
      '03233',
      '',
      NULL,
      1.377037,
      19.996057,
      29,
      13,
      0.312879,
      38,
      2.994665,
      1.946070,
      0,
      0.016207,
      1.639843,
      1,
      0,
      NULL,
      NULL,
      1.427662,
      NULL,
      NULL,
      0.416270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301273,
      NULL,
      NULL,
      0.392844,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.995695,
      NULL,
      NULL,
      0.109691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.613643,
      NULL,
      NULL,
      3.299382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.243804,
      1,
      NULL,
      NULL,
      1.092702,
      NULL,
      NULL,
      0.348798,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      2.674431,
      1,
      0,
      NULL,
      3.901851,
      2,
      0.891439,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      0,
      NULL,
      1.400443,
      0.964810,
      NULL,
      NULL,
      NULL,
      0.991964,
      NULL,
      NULL,
      NULL,
      0.454676,
      NULL,
      NULL,
      NULL,
      1.311378,
      1.273975,
      3,
      1,
      1.615966,
      1.836729,
      NULL,
      NULL,
      1.449537,
      NULL,
      NULL,
      1.645118,
      1,
      0.548830,
      2,
      3,
      1.338620,
      1.283271,
      2,
      1.797565,
      1.757029,
      NULL,
      NULL,
      1.135295,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      9.097250,
      0.376257,
      0,
      0,
      6.995315,
      NULL,
      NULL,
      1.129107,
      5.982675,
      1,
      2,
      3.621626,
      1.761527,
      3.238714,
      3.704179,
      NULL,
      3.498325,
      2.737305,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      0.526823,
      1.307201,
      NULL,
      2,
      0.253754,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2,
      5.800473,
      NULL,
      1,
      7.856335,
      3.578408,
      NULL,
      6,
      1,
      1.653369,
      0.650526,
      NULL,
      NULL,
      3.513559,
      NULL,
      NULL,
      1.184836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471361,
      NULL,
      NULL,
      1.762832,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      0,
      NULL,
      0,
      1.688718,
      4,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      2.548669,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920261,
      NULL,
      NULL,
      NULL,
      0.291395,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.459655,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.774930,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.789386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3.957178,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      33.584438,
      NULL,
      1.459251,
      6.661068,
      NULL,
      1,
      NULL,
      NULL,
      1.939280,
      NULL,
      NULL,
      0.070674,
      NULL,
      NULL,
      0.550219,
      NULL,
      NULL,
      0,
      NULL,
      0,
      215,
      0.707614,
      1,
      1,
      0.165721,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1.910019,
      1.954332,
      0,
      1,
      1,
      1,
      1.952959,
      0.829132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847262,
      1.114603,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.580071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.643639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.017773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660934,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      0.283978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.197672,
      NULL,
      0.754621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.460585,
      NULL,
      8.936663,
      2.900532,
      0,
      NULL,
      2,
      1.538022,
      0.719783,
      1.254389,
      2.872837,
      NULL,
      1,
      NULL,
      0,
      0.908660,
      NULL,
      0.785213,
      0.414320,
      NULL,
      0.385026,
      1,
      0.323557,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      1.469831,
      NULL,
      1.941552,
      2.359086,
      2,
      0,
      NULL,
      1.409919,
      2.721909,
      1.691454,
      NULL,
      0.569325,
      1.989475,
      3.120922,
      0.279003,
      3.249623,
      1.799761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198984,
      1,
      1,
      1,
      1.831447,
      6,
      3.357354,
      1.016635,
      2.140846,
      0,
      0.782047,
      82.561423,
      53,
      4.320095,
      NULL,
      5,
      '41402',
      '04440',
      '00123',
      1.892690,
      NULL,
      '',
      '',
      NULL,
      '2240',
      '',
      '');
commit;
end;
/


