set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7624465';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1012002',
      1.073847,
      0,
      3,
      1,
      '1301',
      3,
      1,
      NULL,
      NULL,
      ' 7-27-1987',
      56,
      NULL,
      3.581509,
      1,
      0.613296,
      ' 9- 6-1983',
      39,
      0.874764,
      336.333783,
      23,
      3,
      ' 6-19-1984',
      ' 8-20-1996',
      ' 6-29-1987',
      2.980278,
      0,
      1,
      NULL,
      0,
      3.965418,
      3,
      0,
      0.914404,
      NULL,
      3,
      8,
      1.433888,
      24.030421,
      31,
      2.931834,
      NULL,
      4,
      1,
      5,
      1.278833,
      1,
      NULL,
      1,
      0.848215,
      NULL,
      1.430164,
      3.101023,
      0,
      1,
      0.460493,
      3.823425,
      5,
      NULL,
      3.615778,
      3,
      1,
      1.214490,
      0.505590,
      2,
      0,
      3,
      0.716230,
      0.002721,
      1,
      0,
      1,
      NULL,
      0.863050,
      2.648759,
      1.665635,
      1,
      1.198679,
      NULL,
      NULL,
      1.226034,
      NULL,
      NULL,
      6.619373,
      2.305249,
      NULL,
      3.541348,
      1.958496,
      2.226038,
      1.927806,
      1,
      3.889662,
      0,
      1.107576,
      0,
      0.171755,
      1,
      0.889168,
      1,
      0,
      1.845683,
      1,
      0.099281,
      1.948627,
      0.184853,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536308,
      0.725534,
      NULL,
      2,
      4.344941,
      4.674184,
      0,
      0.343760,
      NULL,
      1.414423,
      0,
      0.988014,
      0,
      NULL,
      0,
      1.961192,
      0.468035,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5,
      0.283094,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.662255,
      NULL,
      0.920243,
      NULL,
      4.093690,
      0.317100,
      2.045466,
      7.174494,
      5.580934,
      NULL,
      1,
      4.570583,
      NULL,
      8.826177,
      7,
      3.604101,
      NULL,
      2,
      NULL,
      ' 2- 5-1996',
      NULL,
      ' 4-27-1987',
      76,
      0.924418,
      1,
      NULL,
      4.295356,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.623351,
      NULL,
      1.840905,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.791351,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.517695,
      0,
      0.650676,
      0,
      NULL,
      1.281288,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300090,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308183,
      NULL,
      NULL,
      1,
      0.819072,
      NULL,
      NULL,
      0.305684,
      17.254644,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.349246,
      2,
      NULL,
      0,
      2.705902,
      2.638847,
      0.828414,
      2,
      0,
      2,
      2,
      2.319030,
      0,
      1,
      7.720965,
      0.211247,
      1.895135,
      1,
      0,
      0.926702,
      NULL,
      0,
      0,
      1.024453,
      NULL,
      1,
      1.114216,
      0,
      0,
      1,
      9,
      10.141695,
      3,
      3.653325,
      11.796632,
      3.335090,
      0.768036,
      NULL,
      NULL,
      3,
      1,
      1.081841,
      35.889536,
      3.062859,
      1.934844,
      NULL,
      61,
      67.079405,
      20.764444,
      3,
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.703153,
      '',
      '',
      '',
      2.689744,
      1,
      289,
      5,
      2.040887,
      25,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324985,
      0,
      NULL,
      NULL,
      0.267869,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.631122,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.626505,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.034527,
      NULL,
      NULL,
      NULL,
      2.996925,
      3,
      0.255738,
      0.690496,
      NULL,
      NULL,
      NULL,
      0.588660,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534117,
      0,
      3,
      2.081291,
      0.000365,
      0.119553,
      NULL,
      NULL,
      2.272142,
      1,
      NULL,
      NULL,
      NULL,
      1.662505,
      0.714687,
      0.350021,
      2.986954,
      0.975131,
      1.377765,
      1.744144,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.567178,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      2.137919,
      1,
      1.619607,
      0.398072,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.437064,
      NULL,
      NULL,
      1.140164,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.169396,
      3,
      2,
      4,
      NULL,
      9.038168,
      0.245967,
      0.488055,
      0,
      0.130815,
      NULL,
      NULL,
      5.804110,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.410736,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.846645,
      NULL,
      NULL,
      0.445659,
      NULL,
      1.787366,
      2,
      3,
      2,
      7.672281,
      4,
      5,
      5.047936,
      0,
      6.919645,
      NULL,
      7,
      NULL,
      1,
      1.654384,
      3,
      NULL,
      2,
      NULL,
      2,
      3.213907,
      3.045238,
      5.667734,
      5.572223,
      1.745163,
      1.993865,
      2.133631,
      NULL,
      2.584331,
      1.920389,
      1.242312,
      0,
      NULL,
      3.062963,
      3,
      0.635701,
      2.580401,
      NULL,
      6.237242,
      NULL,
      NULL,
      NULL,
      1.805057,
      NULL,
      3,
      3,
      NULL,
      0,
      0,
      0.860077,
      0.778981,
      3.698562,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340326,
      NULL,
      NULL,
      1.858879,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.778238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.691600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.128013,
      0,
      1.882996,
      1,
      1,
      0.265427,
      0.915986,
      NULL,
      NULL,
      7.627295,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.019626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.487639,
      NULL,
      NULL,
      NULL,
      0.584094,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.496179,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.382462,
      NULL,
      NULL,
      NULL,
      0.433659,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.315423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.850536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097624,
      NULL,
      NULL,
      1.870774,
      NULL,
      NULL,
      0.734755,
      NULL,
      1.603814,
      0,
      0.152220,
      1.853870,
      0.336814,
      1.970668,
      1,
      NULL,
      1.376498,
      0.164919,
      0,
      0.222053,
      1,
      0,
      1.867269,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      6.858824,
      2,
      2.887063,
      5.281863,
      NULL,
      NULL,
      NULL,
      1.806071,
      1,
      1.181069,
      2.853068,
      NULL,
      NULL,
      0,
      NULL,
      1.933897,
      1,
      NULL,
      1,
      0.156411,
      NULL,
      2,
      0.136104,
      NULL,
      0.074623,
      1,
      NULL,
      NULL,
      3.728734,
      NULL,
      1,
      NULL,
      NULL,
      0.024872,
      3.349906,
      NULL,
      1.570767,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892985,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      0.405749,
      49.263870,
      37.104232,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      '03241',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


