set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '3103414',
      2,
      0.981003,
      3,
      2,
      '3101',
      3.330778,
      0,
      NULL,
      NULL,
      NULL,
      24.601411,
      NULL,
      2.478328,
      0,
      0.000997,
      ' 6-18-1996',
      0,
      5.179492,
      247.940715,
      83.436449,
      1.008598,
      ' 9- 3-1990',
      NULL,
      ' 2-28-1993',
      0,
      NULL,
      NULL,
      0.684123,
      NULL,
      0,
      2,
      NULL,
      1.894146,
      NULL,
      1,
      7.942434,
      3,
      NULL,
      9.760320,
      5.840344,
      11.894907,
      2.509543,
      2,
      4,
      0,
      NULL,
      0.129408,
      0.883875,
      1.037491,
      1.224603,
      0,
      1,
      NULL,
      1.236388,
      1,
      8,
      0,
      0.131126,
      0.337093,
      1.530936,
      1,
      1,
      0,
      1,
      0.595381,
      1.325175,
      1,
      1,
      1.639885,
      0,
      NULL,
      0.991818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428545,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.917398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      0.153263,
      1,
      NULL,
      1,
      1.032101,
      1.612861,
      0.154116,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      1.582740,
      1.572065,
      NULL,
      1.679371,
      2.399702,
      2,
      1,
      1.847071,
      0,
      3.229485,
      NULL,
      2,
      6,
      2,
      5,
      NULL,
      7,
      0,
      1.456757,
      8.490911,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      3,
      0.101686,
      1,
      0.988411,
      3.947726,
      ' 3-12-1997',
      1219,
      ' 0-22-1988',
      274,
      1,
      1,
      1.496796,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082311,
      NULL,
      0.092073,
      0.115083,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.820113,
      0,
      NULL,
      1.751423,
      0.289870,
      1,
      2.205998,
      0.112211,
      1,
      1.238861,
      1.981576,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.290136,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.595373,
      0.283087,
      1.246448,
      1.719475,
      0,
      0,
      0.237180,
      1.441907,
      2924.267048,
      0.016371,
      0.039187,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067960,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      0.308650,
      2,
      NULL,
      3.267428,
      0,
      3,
      0,
      0,
      0,
      NULL,
      1,
      0.765870,
      0.161733,
      NULL,
      0.551509,
      1,
      1.545851,
      0,
      1,
      0.254170,
      NULL,
      11.947778,
      3.416407,
      11,
      NULL,
      4.822641,
      4.568713,
      1.221989,
      1.884051,
      1,
      1,
      2.517369,
      25.913587,
      NULL,
      0,
      NULL,
      29,
      60,
      16.319313,
      3.290703,
      0.418750,
      1.681188,
      '24113',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.182013,
      38,
      66.069743,
      25,
      1.710578,
      NULL,
      26,
      33.985916,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.453101,
      1.349822,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.357968,
      1,
      1.760624,
      0.275473,
      NULL,
      NULL,
      0.936159,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726665,
      NULL,
      NULL,
      NULL,
      7.321567,
      7,
      0,
      1.734904,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.710458,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310497,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.177028,
      1,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.318002,
      NULL,
      1.369394,
      1.543061,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2.530552,
      0.060700,
      NULL,
      NULL,
      3.061526,
      1,
      0,
      NULL,
      3.442995,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.384697,
      1.493721,
      NULL,
      1,
      NULL,
      NULL,
      1.598530,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.174743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.567853,
      NULL,
      1,
      NULL,
      0.388764,
      NULL,
      1,
      4.151688,
      1.584977,
      2,
      4.413421,
      0.273783,
      3,
      0,
      0,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      2.390547,
      0.409374,
      0,
      2.239413,
      2,
      3,
      3.793903,
      1.205733,
      0,
      2.628544,
      3,
      NULL,
      5.764917,
      3.699793,
      NULL,
      6,
      6,
      0,
      2.942819,
      7,
      3.947426,
      0,
      1,
      1,
      1.405394,
      0.287684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167712,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.296517,
      NULL,
      NULL,
      1.486349,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.779842,
      NULL,
      NULL,
      0.516605,
      NULL,
      NULL,
      3.778636,
      0.115268,
      2,
      2,
      0,
      2.552786,
      1.850691,
      0,
      NULL,
      2,
      NULL,
      58,
      NULL,
      85,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.378870,
      NULL,
      NULL,
      NULL,
      3.386929,
      NULL,
      NULL,
      NULL,
      1.150370,
      NULL,
      1.260321,
      NULL,
      1.760131,
      NULL,
      2.340161,
      NULL,
      2,
      NULL,
      1.128664,
      NULL,
      0.001847,
      NULL,
      NULL,
      NULL,
      2.231694,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.434231,
      NULL,
      1.621762,
      NULL,
      NULL,
      NULL,
      3.602661,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.213021,
      NULL,
      1.358665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066419,
      NULL,
      0,
      NULL,
      1.791960,
      NULL,
      2.341655,
      NULL,
      2,
      NULL,
      9,
      NULL,
      4.246102,
      NULL,
      3,
      NULL,
      1.240775,
      1.553201,
      2,
      7,
      2,
      NULL,
      126.012466,
      NULL,
      315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      9.615536,
      0,
      53.759342,
      2,
      NULL,
      NULL,
      NULL,
      2.901145,
      2,
      0.984678,
      7049.968511,
      NULL,
      0.661681,
      1,
      0.488282,
      1.413067,
      1,
      1,
      0.844897,
      0,
      NULL,
      0,
      1.725577,
      1.364194,
      0,
      0,
      1.279303,
      0,
      1,
      1.111504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.566126,
      0,
      1.546897,
      NULL,
      0,
      1,
      NULL,
      1.916412,
      1.501267,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.379001,
      NULL,
      0.889014,
      0.937589,
      NULL,
      2.575071,
      1.952877,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.340235,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035820,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      2.103365,
      7,
      3.043214,
      1.505919,
      3.797632,
      61,
      96.657675,
      NULL,
      0,
      2.826535,
      '20320',
      NULL,
      '',
      1.157071,
      '',
      '',
      NULL,
      1.057061,
      NULL,
      '',
      '');
commit;
end;
/


